/************************************************************************************************/
/* Stata User File for H147 Data                                                                 */
/*                                                                                              */
/* This file contains information and a sample Stata program to create a permanent              */
/* Stata dataset for users who want to use Stata in processing the MEPS data provided           */
/* in this PUF release.  Stata (StataCorp) has the capability to produce                        */
/* appropriate standard errors for estimates from a survey with a complex sample                */
/* design such as the Medical Expenditure Panel Survey (MEPS).                                  */
/* The input file for creating a permanent Stata dataset is the ASCII data file                 */
/* (H147.DAT) supplied in this PUF release, which in turn can be extracted from the              */
/* .EXE file. After entering the Stata interactive environment access the Stata DO-File         */
/* editor by clicking on the appropriate icon in the command line at the top of the             */
/* screen.  Copy and paste the following Stata commands into the editor and save as a           */
/* DO file.  A DO file is a Stata program which may then be executed using the DO command.      */
/* For example, if the DO file is named H147.DO and is located in the directory                  */
/* C:\MEPS\PROG, then the file may be executed by typing the following command into             */
/* the Stata command line:                                                                      */
/*                         do C:\MEPS\PROG\H147.DO                                               */
/* The program below will output the Stata dataset H147.DTA                                      */
/************************************************************************************************/


#delimit ;
cd $datadir/MEPS/dat/fullyearconsolidated;
clear;

* INPUT ALL VARIABLES;
infix
  long   DUID 1-5
  int    PID 6-8
  str    DUPERSID 9-16
  byte   PANEL 17-18
  str    FAMID31 19-20
  str    FAMID42 21-22
  str    FAMID53 23-24
  str    FAMID11 25-26
  str    FAMIDYR 27-28
  str    CPSFAMID 29-30
  byte   FCSZ1231 31-32
  byte   FCRP1231 33-34
  str    RULETR31 35-36
  str    RULETR42 37-38
  str    RULETR53 39-40
  str    RULETR11 41-42
  byte   RUSIZE31 43-44
  byte   RUSIZE42 45-46
  byte   RUSIZE53 47-48
  byte   RUSIZE11 49-50
  byte   RUCLAS31 51-52
  byte   RUCLAS42 53-54
  byte   RUCLAS53 55-56
  byte   RUCLAS11 57-57
  byte   FAMSZE31 58-59
  byte   FAMSZE42 60-61
  byte   FAMSZE53 62-63
  byte   FAMSZE11 64-65
  byte   FMRS1231 66-67
  byte   FAMS1231 68-69
  byte   FAMSZEYR 70-71
  byte   FAMRFPYR 72-72
  byte   REGION31 73-74
  byte   REGION42 75-76
  byte   REGION53 77-78
  byte   REGION11 79-80
  byte   MSA31 81-82
  byte   MSA42 83-84
  byte   MSA53 85-86
  byte   MSA11 87-88
  int    REFPRS31 89-91
  int    REFPRS42 92-94
  int    REFPRS53 95-97
  int    REFPRS11 98-100
  byte   RESP31 101-101
  byte   RESP42 102-102
  byte   RESP53 103-103
  byte   RESP11 104-104
  byte   PROXY31 105-106
  byte   PROXY42 107-108
  byte   PROXY53 109-110
  byte   PROXY11 111-111
  byte   INTVLANG 112-113
  byte   BEGRFD31 114-115
  byte   BEGRFM31 116-117
  int    BEGRFY31 118-121
  byte   ENDRFD31 122-123
  byte   ENDRFM31 124-125
  int    ENDRFY31 126-129
  byte   BEGRFD42 130-131
  byte   BEGRFM42 132-133
  int    BEGRFY42 134-137
  byte   ENDRFD42 138-139
  byte   ENDRFM42 140-141
  int    ENDRFY42 142-145
  byte   BEGRFD53 146-147
  byte   BEGRFM53 148-149
  int    BEGRFY53 150-153
  byte   ENDRFD53 154-155
  byte   ENDRFM53 156-157
  int    ENDRFY53 158-161
  byte   ENDRFD11 162-163
  byte   ENDRFM11 164-165
  int    ENDRFY11 166-169
  byte   KEYNESS 170-170
  byte   INSCOP31 171-171
  byte   INSCOP42 172-172
  byte   INSCOP53 173-173
  byte   INSCOP11 174-174
  byte   INSC1231 175-175
  byte   INSCOPE 176-176
  byte   ELGRND31 177-177
  byte   ELGRND42 178-178
  byte   ELGRND53 179-179
  byte   ELGRND11 180-180
  byte   PSTATS31 181-182
  byte   PSTATS42 183-184
  byte   PSTATS53 185-186
  str    RURSLT31 187-188
  str    RURSLT42 189-190
  str    RURSLT53 191-192
  byte   AGE31X 193-194
  byte   AGE42X 195-196
  byte   AGE53X 197-198
  byte   AGE11X 199-200
  byte   AGELAST 201-202
  byte   DOBMM 203-204
  int    DOBYY 205-208
  byte   SEX 209-209
  byte   RACEX 210-210
  byte   RACEAX 211-211
  byte   RACEBX 212-212
  byte   RACEWX 213-213
  byte   RACETHNX 214-214
  byte   HISPANX 215-215
  byte   HISPCAT 216-217
  byte   MARRY31X 218-219
  byte   MARRY42X 220-221
  byte   MARRY53X 222-223
  byte   MARRY11X 224-225
  int    SPOUID31 226-228
  int    SPOUID42 229-231
  int    SPOUID53 232-234
  int    SPOUID11 235-237
  byte   SPOUIN31 238-239
  byte   SPOUIN42 240-241
  byte   SPOUIN53 242-243
  byte   SPOUIN11 244-245
  byte   EDUCYR 246-247
  byte   EDUYRDEG 248-249
  byte   HIDEG 250-251
  byte   EDRECODE 252-253
  byte   FTSTU31X 254-255
  byte   FTSTU42X 256-257
  byte   FTSTU53X 258-259
  byte   FTSTU11X 260-261
  byte   ACTDTY31 262-263
  byte   ACTDTY42 264-265
  byte   ACTDTY53 266-267
  byte   HONRDC31 268-269
  byte   HONRDC42 270-271
  byte   HONRDC53 272-273
  byte   RFREL31X 274-275
  byte   RFREL42X 276-277
  byte   RFREL53X 278-279
  byte   RFREL11X 280-281
  int    MOPID31X 282-284
  int    MOPID42X 285-287
  int    MOPID53X 288-290
  int    DAPID31X 291-293
  int    DAPID42X 294-296
  int    DAPID53X 297-299
  byte   RTHLTH31 300-301
  byte   RTHLTH42 302-303
  byte   RTHLTH53 304-305
  byte   MNHLTH31 306-307
  byte   MNHLTH42 308-309
  byte   MNHLTH53 310-311
  byte   HIBPDX 312-313
  byte   HIBPAGED 314-315
  byte   BPMLDX 316-317
  byte   CHDDX 318-319
  byte   CHDAGED 320-321
  byte   ANGIDX 322-323
  byte   ANGIAGED 324-325
  byte   MIDX 326-327
  byte   MIAGED 328-329
  byte   OHRTDX 330-331
  byte   OHRTAGED 332-333
  byte   STRKDX 334-335
  byte   STRKAGED 336-337
  byte   EMPHDX 338-339
  byte   EMPHAGED 340-341
  byte   CHBRON31 342-343
  byte   CHBRON53 344-345
  byte   CHOLDX 346-347
  byte   CHOLAGED 348-349
  byte   CANCERDX 350-351
  byte   CABLADDR 352-353
  byte   BLDRAGED 354-355
  byte   BLDRREMS 356-357
  byte   CABLOOD 358-359
  byte   BLODAGED 360-361
  byte   BLODREMS 362-363
  byte   CABONE 364-365
  byte   BONEAGED 366-367
  byte   BONEREMS 368-369
  byte   CABRAIN 370-371
  byte   BRAIAGED 372-373
  byte   BRAIREMS 374-375
  byte   CABREAST 376-377
  byte   BRSTAGED 378-379
  byte   BRSTREMS 380-381
  byte   CACERVIX 382-383
  byte   CERVAGED 384-385
  byte   CERVREMS 386-387
  byte   CACOLON 388-389
  byte   COLOAGED 390-391
  byte   COLOREMS 392-393
  byte   CAESOPH 394-395
  byte   ESPHAGED 396-397
  byte   ESPHREMS 398-399
  byte   CAKIDNEY 400-401
  byte   KIDNAGED 402-403
  byte   KIDNREMS 404-405
  byte   CALARYNX 406-407
  byte   LRNXAGED 408-409
  byte   LRNXREMS 410-411
  byte   CALEUKEM 412-413
  byte   LEUKAGED 414-415
  byte   LEUKREMS 416-417
  byte   CALIVER 418-419
  byte   LIVRAGED 420-421
  byte   LIVRREMS 422-423
  byte   CALUNG 424-425
  byte   LUNGAGED 426-427
  byte   LUNGREMS 428-429
  byte   CALYMPH 430-431
  byte   LYMPAGED 432-433
  byte   LYMPREMS 434-435
  byte   CAMELANO 436-437
  byte   MELAAGED 438-439
  byte   MELAREMS 440-441
  byte   CAMOUTH 442-443
  byte   MOUTAGED 444-445
  byte   MOUTREMS 446-447
  byte   CAMUSCLE 448-449
  byte   MUSCAGED 450-451
  byte   MUSCREMS 452-453
  byte   CAOTHER 454-455
  byte   OTHRAGED 456-457
  byte   OTHRREMS 458-459
  byte   CAOVARY 460-461
  byte   OVRYAGED 462-463
  byte   OVRYREMS 464-465
  byte   CAPANCRS 466-467
  byte   PANCAGED 468-469
  byte   PANCREMS 470-471
  byte   CAPROSTA 472-473
  byte   PRSTAGED 474-475
  byte   PRSTREMS 476-477
  byte   CARECTUM 478-479
  byte   RECTAGED 480-481
  byte   RECTREMS 482-483
  byte   CASKINNM 484-485
  byte   SKNMAGED 486-487
  byte   SKNMREMS 488-489
  byte   CASKINDK 490-491
  byte   SKDKAGED 492-493
  byte   SKDKREMS 494-495
  byte   CASTOMCH 496-497
  byte   STOMAGED 498-499
  byte   STOMREMS 500-501
  byte   CATESTIS 502-503
  byte   TSTSAGED 504-505
  byte   TSTSREMS 506-507
  byte   CATHROAT 508-509
  byte   THRTAGED 510-511
  byte   THRTREMS 512-513
  byte   CATHYROD 514-515
  byte   THYRAGED 516-517
  byte   THYRREMS 518-519
  byte   CAUTERUS 520-521
  byte   UTERAGED 522-523
  byte   UTERREMS 524-525
  byte   DIABDX 526-527
  byte   DIABAGED 528-529
  byte   JTPAIN31 530-531
  byte   JTPAIN53 532-533
  byte   ARTHDX 534-535
  byte   ARTHTYPE 536-537
  byte   ARTHAGED 538-539
  byte   ASTHDX 540-541
  byte   ASTHAGED 542-543
  byte   ASSTIL31 544-545
  byte   ASSTIL53 546-547
  byte   ASATAK31 548-549
  byte   ASATAK53 550-551
  byte   ASTHEP31 552-553
  byte   ASTHEP53 554-555
  byte   ASACUT53 556-557
  byte   ASMRCN53 558-559
  byte   ASPREV53 560-561
  byte   ASDALY53 562-563
  byte   ASPKFL53 564-565
  byte   ASEVFL53 566-567
  byte   ASWNFL53 568-569
  byte   ADHDADDX 570-571
  byte   ADHDAGED 572-573
  byte   PREGNT31 574-575
  byte   PREGNT42 576-577
  byte   PREGNT53 578-579
  byte   IADLHP31 580-581
  byte   IADLHP42 582-583
  byte   IADLHP53 584-585
  byte   IADL3M31 586-587
  byte   IADL3M42 588-589
  byte   IADL3M53 590-591
  byte   ADLHLP31 592-593
  byte   ADLHLP42 594-595
  byte   ADLHLP53 596-597
  byte   ADL3MO31 598-599
  byte   ADL3MO42 600-601
  byte   ADL3MO53 602-603
  byte   AIDHLP31 604-605
  byte   AIDHLP53 606-607
  byte   WLKLIM31 608-609
  byte   WLKLIM53 610-611
  byte   LFTDIF31 612-613
  byte   LFTDIF53 614-615
  byte   STPDIF31 616-617
  byte   STPDIF53 618-619
  byte   WLKDIF31 620-621
  byte   WLKDIF53 622-623
  byte   MILDIF31 624-625
  byte   MILDIF53 626-627
  byte   STNDIF31 628-629
  byte   STNDIF53 630-631
  byte   BENDIF31 632-633
  byte   BENDIF53 634-635
  byte   RCHDIF31 636-637
  byte   RCHDIF53 638-639
  byte   FNGRDF31 640-641
  byte   FNGRDF53 642-643
  byte   WLK3MO31 644-645
  byte   WLK3MO53 646-647
  byte   ACTLIM31 648-649
  byte   ACTLIM53 650-651
  byte   WRKLIM31 652-653
  byte   WRKLIM53 654-655
  byte   HSELIM31 656-657
  byte   HSELIM53 658-659
  byte   SCHLIM31 660-661
  byte   SCHLIM53 662-663
  byte   UNABLE31 664-665
  byte   UNABLE53 666-667
  byte   SOCLIM31 668-669
  byte   SOCLIM53 670-671
  byte   COGLIM31 672-673
  byte   COGLIM53 674-675
  byte   WRGLAS42 676-677
  byte   SEEDIF42 678-679
  byte   BLIND42 680-681
  byte   READNW42 682-683
  byte   RECPEP42 684-685
  byte   VISION42 686-687
  byte   HEARAD42 688-689
  byte   HEARDI42 690-691
  byte   DEAF42 692-693
  byte   HEARMO42 694-695
  byte   HEARSM42 696-697
  byte   HEARNG42 698-699
  byte   ANYLIM11 700-701
  byte   LSHLTH42 702-703
  byte   NEVILL42 704-705
  byte   SICEAS42 706-707
  byte   HLTHLF42 708-709
  byte   WRHLTH42 710-711
  byte   CHPMED42 712-713
  byte   CHPMHB42 714-715
  byte   CHPMCN42 716-717
  byte   CHSERV42 718-719
  byte   CHSRHB42 720-721
  byte   CHSRCN42 722-723
  byte   CHLIMI42 724-725
  byte   CHLIHB42 726-727
  byte   CHLICO42 728-729
  byte   CHTHER42 730-731
  byte   CHTHHB42 732-733
  byte   CHTHCO42 734-735
  byte   CHCOUN42 736-737
  byte   CHEMPB42 738-739
  byte   CSHCN42 740-741
  byte   MOMPRO42 742-743
  byte   DADPRO42 744-745
  byte   UNHAP42 746-747
  byte   SCHLBH42 748-749
  byte   HAVFUN42 750-751
  byte   ADUPRO42 752-753
  byte   NERVAF42 754-755
  byte   SIBPRO42 756-757
  byte   KIDPRO42 758-759
  byte   SPRPRO42 760-761
  byte   SCHPRO42 762-763
  byte   HOMEBH42 764-765
  byte   TRBLE42 766-767
  byte   CHILCR42 768-769
  byte   CHILWW42 770-771
  byte   CHRTCR42 772-773
  byte   CHRTWW42 774-775
  byte   CHAPPT42 776-777
  byte   CHNDCR42 778-779
  byte   CHENEC42 780-781
  byte   CHLIST42 782-783
  byte   CHEXPL42 784-785
  byte   CHRESP42 786-787
  byte   CHPRTM42 788-789
  byte   CHHECR42 790-791
  byte   CHSPEC42 792-793
  byte   CHEYRE42 794-795
  byte   MESHGT42 796-797
  byte   WHNHGT42 798-799
  byte   MESWGT42 800-801
  byte   WHNWGT42 802-803
  double CHBMIX42 804-808
  byte   MESVIS42 809-810
  byte   MESBPR42 811-812
  byte   WHNBPR42 813-814
  byte   DENTAL42 815-816
  byte   WHNDEN42 817-818
  byte   EATHLT42 819-820
  byte   WHNEAT42 821-822
  byte   PHYSCL42 823-824
  byte   WHNPHY42 825-826
  byte   SAFEST42 827-828
  byte   WHNSAF42 829-830
  byte   BOOST42 831-832
  byte   WHNBST42 833-834
  byte   LAPBLT42 835-836
  byte   WHNLAP42 837-838
  byte   HELMET42 839-840
  byte   WHNHEL42 841-842
  byte   NOSMOK42 843-844
  byte   WHNSMK42 845-846
  byte   TIMALN42 847-848
  byte   DENTCK53 849-850
  byte   BPCHEK53 851-852
  byte   BPMONT53 853-854
  byte   CHOLCK53 855-856
  byte   CHECK53 857-858
  byte   NOFAT53 859-860
  byte   EXRCIS53 861-862
  byte   FLUSHT53 863-864
  byte   ASPRIN53 865-866
  byte   NOASPR53 867-868
  byte   STOMCH53 869-870
  byte   LSTETH53 871-872
  byte   PSA53 873-874
  byte   HYSTER53 875-876
  byte   PAPSMR53 877-878
  byte   BRSTEX53 879-880
  byte   MAMOGR53 881-882
  byte   BSTST53 883-884
  byte   BSTSRE53 885-886
  byte   CLNTST53 887-888
  byte   CLNTRE53 889-890
  byte   SGMTST53 891-892
  byte   SGMTRE53 893-894
  byte   PHYEXE53 895-896
  double BMINDX53 897-900
  byte   SEATBE53 901-902
  byte   SAQELIG 903-903
  int    ADPRX42 904-906
  byte   ADILCR42 907-908
  byte   ADILWW42 909-910
  byte   ADRTCR42 911-912
  byte   ADRTWW42 913-914
  byte   ADAPPT42 915-916
  byte   ADNDCR42 917-918
  byte   ADEGMC42 919-920
  byte   ADLIST42 921-922
  byte   ADEXPL42 923-924
  byte   ADRESP42 925-926
  byte   ADPRTM42 927-928
  byte   ADINST42 929-930
  byte   ADEZUN42 931-932
  byte   ADTLHW42 933-934
  byte   ADFFRM42 935-936
  byte   ADFHLP42 937-938
  byte   ADHECR42 939-940
  byte   ADSMOK42 941-942
  byte   ADNSMK42 943-944
  byte   ADDRBP42 945-946
  byte   ADSPEC42 947-948
  byte   ADSPRF42 949-950
  byte   ADGENH42 951-952
  byte   ADDAYA42 953-954
  byte   ADCLIM42 955-956
  byte   ADPALS42 957-958
  byte   ADPWLM42 959-960
  byte   ADMALS42 961-962
  byte   ADMWLM42 963-964
  byte   ADPAIN42 965-966
  byte   ADCAPE42 967-968
  byte   ADNRGY42 969-970
  byte   ADDOWN42 971-972
  byte   ADSOCA42 973-974
  double PCS42 975-979
  double MCS42 980-984
  byte   SFFLAG42 985-986
  byte   ADNERV42 987-988
  byte   ADHOPE42 989-990
  byte   ADREST42 991-992
  byte   ADSAD42 993-994
  byte   ADEFRT42 995-996
  byte   ADWRTH42 997-998
  byte   K6SUM42 999-1000
  byte   ADINTR42 1001-1002
  byte   ADDPRS42 1003-1004
  byte   PHQ242 1005-1006
  byte   ADINSA42 1007-1008
  byte   ADINSB42 1009-1010
  byte   ADRISK42 1011-1012
  byte   ADOVER42 1013-1014
  byte   ADCMPM42 1015-1016
  byte   ADCMPD42 1017-1018
  int    ADCMPY42 1019-1022
  byte   ADLANG42 1023-1024
  byte   DSDIA53 1025-1026
  byte   DSA1C53 1027-1028
  byte   DSFT1253 1029-1030
  byte   DSFT1153 1031-1032
  byte   DSFT1053 1033-1034
  byte   DSFB1053 1035-1036
  byte   DSFTNV53 1037-1038
  byte   DSEY1253 1039-1040
  byte   DSEY1153 1041-1042
  byte   DSEY1053 1043-1044
  byte   DSEB1053 1045-1046
  byte   DSEYNV53 1047-1048
  byte   DSCH1253 1049-1050
  byte   DSCH1153 1051-1052
  byte   DSCH1053 1053-1054
  byte   DSCB1053 1055-1056
  byte   DSCHNV53 1057-1058
  byte   DSFL1253 1059-1060
  byte   DSFL1153 1061-1062
  byte   DSFL1053 1063-1064
  byte   DSVB1053 1065-1066
  byte   DSFLNV53 1067-1068
  byte   DSKIDN53 1069-1070
  byte   DSEYPR53 1071-1072
  byte   DSDIET53 1073-1074
  byte   DSMED53 1075-1076
  byte   DSINSU53 1077-1078
  byte   DSCPCP53 1079-1080
  byte   DSCNPC53 1081-1082
  byte   DSCPHN53 1083-1084
  byte   DSCINT53 1085-1086
  byte   DSCGRP53 1087-1088
  byte   DSCONF53 1089-1090
  byte   DSPRX53 1091-1092
  byte   CELIGI53 1093-1093
  byte   CCNRDI53 1094-1095
  byte   CDIAG53 1096-1097
  byte   CTRTMT53 1098-1099
  byte   CFREE53 1100-1101
  byte   CLSTRT53 1102-1103
  byte   CBCK53 1104-1105
  int    CBCKYR53 1106-1109
  byte   CFTRT53 1110-1111
  byte   CWRKP53 1112-1113
  byte   CTMOFF53 1114-1115
  byte   CTMSK53 1116-1117
  byte   CWYASK53 1118-1119
  byte   CWYCNG53 1120-1121
  byte   CEXTM53 1122-1123
  byte   CEXTDI53 1124-1125
  byte   CEXTRT53 1126-1127
  byte   CEXTLT53 1128-1129
  byte   CEXTMT53 1130-1131
  byte   CEXTOT53 1132-1133
  byte   CEXTOG53 1134-1135
  byte   CNPTOF53 1136-1137
  byte   CNPTDI53 1138-1139
  byte   CNPTRT53 1140-1141
  byte   CNPTLT53 1142-1143
  byte   CNPTMT53 1144-1145
  byte   CNPTOT53 1146-1147
  byte   CNPOG53 1148-1149
  byte   CCNGFT53 1150-1151
  byte   CNGFDI53 1152-1153
  byte   CNGFTR53 1154-1155
  byte   CNGFLT53 1156-1157
  byte   CNGFMT53 1158-1159
  byte   CFTTOT53 1160-1161
  byte   CNGFOG53 1162-1163
  byte   CCNGPT53 1164-1165
  byte   CNGPDI53 1166-1167
  byte   CNGPTR53 1168-1169
  byte   CNGPLT53 1170-1171
  byte   CNGPMT53 1172-1173
  byte   CPTTOT53 1174-1175
  byte   CNGPOG53 1176-1177
  byte   CNGFLX53 1178-1179
  byte   CNGFXD53 1180-1181
  byte   CNGFXT53 1182-1183
  byte   CNGFXL53 1184-1185
  byte   CNGFXM53 1186-1187
  byte   CNGLDJ53 1188-1189
  byte   CNGLDD53 1190-1191
  byte   CNGLDT53 1192-1193
  byte   CNGLDL53 1194-1195
  byte   CNGLDM53 1196-1197
  byte   CLDJOB53 1198-1199
  byte   CNGLOG53 1200-1201
  byte   COTARR53 1202-1203
  byte   CPROM53 1204-1205
  byte   CERET53 1206-1207
  byte   CDRET53 1208-1209
  byte   CPTASK53 1210-1211
  byte   CMTASK53 1212-1213
  byte   CLPROD53 1214-1215
  byte   CFRET53 1216-1217
  byte   CLHINS53 1218-1219
  byte   CCLHIN53 1220-1221
  byte   CWRKEF53 1222-1223
  byte   CSLHIN53 1224-1225
  byte   CFMEM53 1226-1227
  byte   CFMTOF53 1228-1229
  byte   CFM2MT53 1230-1231
  byte   CFMEXT53 1232-1233
  byte   CFMETM53 1234-1235
  byte   CFMPOG53 1236-1237
  byte   CFMNPT53 1238-1239
  byte   CFMNTM53 1240-1241
  byte   CFMUOG53 1242-1243
  byte   CFMPTF53 1244-1245
  byte   CFMFTM53 1246-1247
  byte   CFMFOG53 1248-1249
  byte   CFMFTP53 1250-1251
  byte   CFMPTM53 1252-1253
  byte   CFMCOG53 1254-1255
  byte   CFMOTH53 1256-1257
  byte   CFMLDJ53 1258-1259
  byte   CFMGRT53 1260-1261
  byte   CFMDRT53 1262-1263
  byte   CINCOV53 1264-1265
  byte   CINREF53 1266-1267
  byte   CIN2OP53 1268-1269
  byte   CINDND53 1270-1271
  byte   CFNDBT53 1272-1273
  byte   CFNAMT53 1274-1275
  byte   CFNBNK53 1276-1277
  byte   CFNSAC53 1278-1279
  byte   CFNPMT53 1280-1281
  byte   CFNUNB53 1282-1283
  byte   CMCFUP53 1284-1285
  byte   CMCEFF53 1286-1287
  byte   CMCPSY53 1288-1289
  byte   CMCSTY53 1290-1291
  byte   CMCNEC53 1292-1293
  byte   CMNAFF53 1294-1295
  byte   CMNINS53 1296-1297
  byte   CMNACC53 1298-1299
  byte   CMNOFF53 1300-1301
  byte   CMNTIM53 1302-1303
  byte   CMNPLC53 1304-1305
  byte   CMNCRE53 1306-1307
  byte   CMNLNG53 1308-1309
  byte   CMOTHR 1310-1311
  byte   CMMAIN53 1312-1313
  byte   CEFACT53 1314-1315
  byte   CEFLCT53 1316-1317
  byte   CEFOG53 1318-1319
  byte   CEFMTL53 1320-1321
  byte   CEFASK53 1322-1323
  byte   CEFREC53 1324-1325
  byte   CEFAHU53 1326-1327
  byte   CEFRHU53 1328-1329
  byte   CEFBCK53 1330-1331
  byte   CEFRSP53 1332-1333
  byte   CEFOPN53 1334-1335
  byte   CEFSTG53 1336-1337
  byte   CEFCOP53 1338-1339
  byte   CEFPOS53 1340-1341
  byte   CEFHLT53 1342-1343
  int    DDNWRK31 1344-1346
  int    DDNWRK42 1347-1349
  int    DDNWRK53 1350-1352
  int    WKINBD31 1353-1355
  int    WKINBD42 1356-1358
  int    WKINBD53 1359-1361
  byte   DDNSCL31 1362-1363
  byte   DDNSCL42 1364-1365
  byte   DDNSCL53 1366-1367
  byte   SCLNBD31 1368-1369
  byte   SCLNBD42 1370-1371
  byte   SCLNBD53 1372-1373
  int    DDBDYS31 1374-1376
  int    DDBDYS42 1377-1379
  int    DDBDYS53 1380-1382
  byte   OTHDYS31 1383-1384
  byte   OTHDYS42 1385-1386
  byte   OTHDYS53 1387-1388
  byte   OTHNDD31 1389-1390
  int    OTHNDD42 1391-1393
  byte   OTHNDD53 1394-1395
  byte   ACCELI42 1396-1397
  byte   LANGHM42 1398-1399
  byte   ENGCMF42 1400-1401
  byte   ENGSPK42 1402-1403
  byte   USBORN42 1404-1405
  byte   USLIVE42 1406-1407
  byte   HAVEUS42 1408-1409
  byte   YNOUSC42 1410-1411
  byte   NOREAS42 1412-1413
  byte   SELDSI42 1414-1415
  byte   NEWARE42 1416-1417
  byte   DKWHRU42 1418-1419
  byte   USCNOT42 1420-1421
  byte   PERSLA42 1422-1423
  byte   DIFFPL42 1424-1425
  byte   INSRPL42 1426-1427
  byte   MYSELF42 1428-1429
  byte   CARECO42 1430-1431
  byte   NOHINS42 1432-1433
  byte   OTHINS42 1434-1435
  byte   JOBRSN42 1436-1437
  byte   NEWDOC42 1438-1439
  byte   DOCELS42 1440-1441
  byte   NOLIKE42 1442-1443
  byte   HEALTH42 1444-1445
  byte   KNOWDR42 1446-1447
  byte   ONJOB42 1448-1449
  byte   NOGODR42 1450-1451
  byte   TRANS42 1452-1453
  byte   CLINIC42 1454-1455
  byte   OTHREA42 1456-1457
  byte   PROVTY42 1458-1459
  byte   PLCTYP42 1460-1461
  byte   GOTOUS42 1462-1463
  byte   TMTKUS42 1464-1465
  byte   DFTOUS42 1466-1467
  byte   TYPEPE42 1468-1469
  byte   LOCATN42 1470-1471
  byte   HSPLAP42 1472-1473
  byte   WHITPR42 1474-1475
  byte   BLCKPR42 1476-1477
  byte   ASIANP42 1478-1479
  byte   NATAMP42 1480-1481
  byte   PACISP42 1482-1483
  byte   OTHRCP42 1484-1485
  byte   GENDRP42 1486-1487
  byte   MINORP42 1488-1489
  byte   PREVEN42 1490-1491
  byte   REFFRL42 1492-1493
  byte   ONGONG42 1494-1495
  byte   PHNREG42 1496-1497
  byte   OFFHOU42 1498-1499
  byte   AFTHOU42 1500-1501
  byte   TREATM42 1502-1503
  byte   RESPCT42 1504-1505
  byte   DECIDE42 1506-1507
  byte   EXPLOP42 1508-1509
  byte   LANGPR42 1510-1511
  byte   MDUNAB42 1512-1513
  byte   MDUNRS42 1514-1515
  byte   MDUNPR42 1516-1517
  byte   MDDLAY42 1518-1519
  byte   MDDLRS42 1520-1521
  byte   MDDLPR42 1522-1523
  byte   DNUNAB42 1524-1525
  byte   DNUNRS42 1526-1527
  byte   DNUNPR42 1528-1529
  byte   DNDLAY42 1530-1531
  byte   DNDLRS42 1532-1533
  byte   DNDLPR42 1534-1535
  byte   PMUNAB42 1536-1537
  byte   PMUNRS42 1538-1539
  byte   PMUNPR42 1540-1541
  byte   PMDLAY42 1542-1543
  byte   PMDLRS42 1544-1545
  byte   PMDLPR42 1546-1547
  byte   EMPST31 1548-1549
  byte   EMPST42 1550-1551
  byte   EMPST53 1552-1553
  byte   RNDFLG31 1554-1555
  byte   MORJOB31 1556-1557
  byte   MORJOB42 1558-1559
  byte   MORJOB53 1560-1561
  byte   EVRWRK 1562-1563
  double HRWG31X 1564-1569
  double HRWG42X 1570-1575
  double HRWG53X 1576-1581
  byte   HRWGIM31 1582-1582
  byte   HRWGIM42 1583-1583
  byte   HRWGIM53 1584-1584
  byte   HRHOW31 1585-1586
  byte   HRHOW42 1587-1588
  byte   HRHOW53 1589-1590
  byte   DIFFWG31 1591-1592
  byte   DIFFWG42 1593-1594
  byte   DIFFWG53 1595-1596
  double NHRWG31 1597-1602
  double NHRWG42 1603-1608
  double NHRWG53 1609-1614
  int    HOUR31 1615-1617
  int    HOUR42 1618-1620
  int    HOUR53 1621-1623
  byte   TEMPJB31 1624-1625
  byte   TEMPJB42 1626-1627
  byte   TEMPJB53 1628-1629
  byte   SSNLJB31 1630-1631
  byte   SSNLJB42 1632-1633
  byte   SSNLJB53 1634-1635
  byte   SELFCM31 1636-1637
  byte   SELFCM42 1638-1639
  byte   SELFCM53 1640-1641
  byte   DISVW31X 1642-1643
  byte   DISVW42X 1644-1645
  byte   DISVW53X 1646-1647
  byte   CHOIC31 1648-1649
  byte   CHOIC42 1650-1651
  byte   CHOIC53 1652-1653
  byte   INDCAT31 1654-1655
  byte   INDCAT42 1656-1657
  byte   INDCAT53 1658-1659
  int    NUMEMP31 1660-1662
  int    NUMEMP42 1663-1665
  int    NUMEMP53 1666-1668
  byte   MORE31 1669-1670
  byte   MORE42 1671-1672
  byte   MORE53 1673-1674
  byte   UNION31 1675-1676
  byte   UNION42 1677-1678
  byte   UNION53 1679-1680
  byte   NWK31 1681-1682
  byte   NWK42 1683-1684
  byte   NWK53 1685-1686
  byte   CHGJ3142 1687-1688
  byte   CHGJ4253 1689-1690
  byte   YCHJ3142 1691-1692
  byte   YCHJ4253 1693-1694
  byte   STJBMM31 1695-1696
  byte   STJBDD31 1697-1698
  int    STJBYY31 1699-1702
  byte   STJBMM42 1703-1704
  byte   STJBDD42 1705-1706
  int    STJBYY42 1707-1710
  byte   STJBMM53 1711-1712
  byte   STJBDD53 1713-1714
  int    STJBYY53 1715-1718
  byte   EVRETIRE 1719-1720
  byte   OCCCAT31 1721-1722
  byte   OCCCAT42 1723-1724
  byte   OCCCAT53 1725-1726
  byte   PAYVAC31 1727-1728
  byte   PAYVAC42 1729-1730
  byte   PAYVAC53 1731-1732
  byte   SICPAY31 1733-1734
  byte   SICPAY42 1735-1736
  byte   SICPAY53 1737-1738
  byte   PAYDR31 1739-1740
  byte   PAYDR42 1741-1742
  byte   PAYDR53 1743-1744
  byte   RETPLN31 1745-1746
  byte   RETPLN42 1747-1748
  byte   RETPLN53 1749-1750
  byte   BSNTY31 1751-1752
  byte   BSNTY42 1753-1754
  byte   BSNTY53 1755-1756
  byte   JOBORG31 1757-1758
  byte   JOBORG42 1759-1760
  byte   JOBORG53 1761-1762
  byte   HELD31X 1763-1764
  byte   HELD42X 1765-1766
  byte   HELD53X 1767-1768
  byte   OFFER31X 1769-1770
  byte   OFFER42X 1771-1772
  byte   OFFER53X 1773-1774
  byte   OFREMP31 1775-1776
  byte   OFREMP42 1777-1778
  byte   OFREMP53 1779-1780
  byte   YNOINS31 1781-1782
  byte   YNOINS42 1783-1784
  byte   YNOINS53 1785-1786
  byte   SSIDIS11 1787-1788
  byte   AFDC11 1789-1790
  byte   FILEDR11 1791-1792
  byte   WILFIL11 1793-1794
  byte   FLSTAT11 1795-1796
  byte   FILER11 1797-1798
  byte   JTINRU11 1799-1800
  int    JNTPID11 1801-1803
  byte   CLMDEP11 1804-1805
  byte   DEPDNT11 1806-1807
  byte   DPINRU11 1808-1809
  byte   DPOTSD11 1810-1811
  byte   TAXFRM11 1812-1813
  byte   DEDUCT11 1814-1815
  long   TOTDED11 1816-1821
  byte   CLMHIP11 1822-1823
  byte   EICRDT11 1824-1825
  byte   FOODST11 1826-1827
  byte   FOODMN11 1828-1829
  int    FOODVL11 1830-1833
  long   TTLP11X 1834-1839
  long   FAMINC11 1840-1846
  byte   POVCAT11 1847-1847
  double POVLEV11 1848-1858
  long   WAGEP11X 1859-1864
  byte   WAGIMP11 1865-1865
  long   BUSNP11X 1866-1871
  byte   BUSIMP11 1872-1872
  long   UNEMP11X 1873-1877
  byte   UNEIMP11 1878-1878
  long   WCMPP11X 1879-1883
  byte   WCPIMP11 1884-1884
  long   INTRP11X 1885-1890
  byte   INTIMP11 1891-1891
  long   DIVDP11X 1892-1896
  byte   DIVIMP11 1897-1897
  long   SALEP11X 1898-1904
  byte   SALIMP11 1905-1905
  long   PENSP11X 1906-1910
  byte   PENIMP11 1911-1911
  long   SSECP11X 1912-1916
  byte   SSCIMP11 1917-1917
  long   TRSTP11X 1918-1923
  byte   TRTIMP11 1924-1924
  long   VETSP11X 1925-1929
  byte   VETIMP11 1930-1930
  long   IRASP11X 1931-1935
  byte   IRAIMP11 1936-1936
  long   REFDP11X 1937-1941
  byte   REFIMP11 1942-1942
  long   ALIMP11X 1943-1947
  byte   ALIIMP11 1948-1948
  long   CHLDP11X 1949-1953
  byte   CHLIMP11 1954-1954
  long   CASHP11X 1955-1960
  byte   CSHIMP11 1961-1961
  long   SSIP11X 1962-1966
  byte   SSIIMP11 1967-1967
  long   PUBP11X 1968-1972
  byte   PUBIMP11 1973-1973
  long   OTHRP11X 1974-1979
  byte   OTHIMP11 1980-1980
  str    HIEUIDX 1981-1987
  byte   TRIJA11X 1988-1989
  byte   TRIFE11X 1990-1991
  byte   TRIMA11X 1992-1993
  byte   TRIAP11X 1994-1995
  byte   TRIMY11X 1996-1997
  byte   TRIJU11X 1998-1999
  byte   TRIJL11X 2000-2001
  byte   TRIAU11X 2002-2003
  byte   TRISE11X 2004-2005
  byte   TRIOC11X 2006-2007
  byte   TRINO11X 2008-2009
  byte   TRIDE11X 2010-2011
  byte   MCRJA11 2012-2013
  byte   MCRFE11 2014-2015
  byte   MCRMA11 2016-2017
  byte   MCRAP11 2018-2019
  byte   MCRMY11 2020-2021
  byte   MCRJU11 2022-2023
  byte   MCRJL11 2024-2025
  byte   MCRAU11 2026-2027
  byte   MCRSE11 2028-2029
  byte   MCROC11 2030-2031
  byte   MCRNO11 2032-2033
  byte   MCRDE11 2034-2035
  byte   MCRJA11X 2036-2037
  byte   MCRFE11X 2038-2039
  byte   MCRMA11X 2040-2041
  byte   MCRAP11X 2042-2043
  byte   MCRMY11X 2044-2045
  byte   MCRJU11X 2046-2047
  byte   MCRJL11X 2048-2049
  byte   MCRAU11X 2050-2051
  byte   MCRSE11X 2052-2053
  byte   MCROC11X 2054-2055
  byte   MCRNO11X 2056-2057
  byte   MCRDE11X 2058-2059
  byte   MCDJA11 2060-2061
  byte   MCDFE11 2062-2063
  byte   MCDMA11 2064-2065
  byte   MCDAP11 2066-2067
  byte   MCDMY11 2068-2069
  byte   MCDJU11 2070-2071
  byte   MCDJL11 2072-2073
  byte   MCDAU11 2074-2075
  byte   MCDSE11 2076-2077
  byte   MCDOC11 2078-2079
  byte   MCDNO11 2080-2081
  byte   MCDDE11 2082-2083
  byte   MCDJA11X 2084-2085
  byte   MCDFE11X 2086-2087
  byte   MCDMA11X 2088-2089
  byte   MCDAP11X 2090-2091
  byte   MCDMY11X 2092-2093
  byte   MCDJU11X 2094-2095
  byte   MCDJL11X 2096-2097
  byte   MCDAU11X 2098-2099
  byte   MCDSE11X 2100-2101
  byte   MCDOC11X 2102-2103
  byte   MCDNO11X 2104-2105
  byte   MCDDE11X 2106-2107
  byte   OPAJA11 2108-2109
  byte   OPAFE11 2110-2111
  byte   OPAMA11 2112-2113
  byte   OPAAP11 2114-2115
  byte   OPAMY11 2116-2117
  byte   OPAJU11 2118-2119
  byte   OPAJL11 2120-2121
  byte   OPAAU11 2122-2123
  byte   OPASE11 2124-2125
  byte   OPAOC11 2126-2127
  byte   OPANO11 2128-2129
  byte   OPADE11 2130-2131
  byte   OPBJA11 2132-2133
  byte   OPBFE11 2134-2135
  byte   OPBMA11 2136-2137
  byte   OPBAP11 2138-2139
  byte   OPBMY11 2140-2141
  byte   OPBJU11 2142-2143
  byte   OPBJL11 2144-2145
  byte   OPBAU11 2146-2147
  byte   OPBSE11 2148-2149
  byte   OPBOC11 2150-2151
  byte   OPBNO11 2152-2153
  byte   OPBDE11 2154-2155
  byte   STAJA11 2156-2157
  byte   STAFE11 2158-2159
  byte   STAMA11 2160-2161
  byte   STAAP11 2162-2163
  byte   STAMY11 2164-2165
  byte   STAJU11 2166-2167
  byte   STAJL11 2168-2169
  byte   STAAU11 2170-2171
  byte   STASE11 2172-2173
  byte   STAOC11 2174-2175
  byte   STANO11 2176-2177
  byte   STADE11 2178-2179
  byte   PUBJA11X 2180-2181
  byte   PUBFE11X 2182-2183
  byte   PUBMA11X 2184-2185
  byte   PUBAP11X 2186-2187
  byte   PUBMY11X 2188-2189
  byte   PUBJU11X 2190-2191
  byte   PUBJL11X 2192-2193
  byte   PUBAU11X 2194-2195
  byte   PUBSE11X 2196-2197
  byte   PUBOC11X 2198-2199
  byte   PUBNO11X 2200-2201
  byte   PUBDE11X 2202-2203
  byte   PEGJA11 2204-2205
  byte   PEGFE11 2206-2207
  byte   PEGMA11 2208-2209
  byte   PEGAP11 2210-2211
  byte   PEGMY11 2212-2213
  byte   PEGJU11 2214-2215
  byte   PEGJL11 2216-2217
  byte   PEGAU11 2218-2219
  byte   PEGSE11 2220-2221
  byte   PEGOC11 2222-2223
  byte   PEGNO11 2224-2225
  byte   PEGDE11 2226-2227
  byte   PDKJA11 2228-2229
  byte   PDKFE11 2230-2231
  byte   PDKMA11 2232-2233
  byte   PDKAP11 2234-2235
  byte   PDKMY11 2236-2237
  byte   PDKJU11 2238-2239
  byte   PDKJL11 2240-2241
  byte   PDKAU11 2242-2243
  byte   PDKSE11 2244-2245
  byte   PDKOC11 2246-2247
  byte   PDKNO11 2248-2249
  byte   PDKDE11 2250-2251
  byte   PNGJA11 2252-2253
  byte   PNGFE11 2254-2255
  byte   PNGMA11 2256-2257
  byte   PNGAP11 2258-2259
  byte   PNGMY11 2260-2261
  byte   PNGJU11 2262-2263
  byte   PNGJL11 2264-2265
  byte   PNGAU11 2266-2267
  byte   PNGSE11 2268-2269
  byte   PNGOC11 2270-2271
  byte   PNGNO11 2272-2273
  byte   PNGDE11 2274-2275
  byte   POGJA11 2276-2277
  byte   POGFE11 2278-2279
  byte   POGMA11 2280-2281
  byte   POGAP11 2282-2283
  byte   POGMY11 2284-2285
  byte   POGJU11 2286-2287
  byte   POGJL11 2288-2289
  byte   POGAU11 2290-2291
  byte   POGSE11 2292-2293
  byte   POGOC11 2294-2295
  byte   POGNO11 2296-2297
  byte   POGDE11 2298-2299
  byte   PRSJA11 2300-2301
  byte   PRSFE11 2302-2303
  byte   PRSMA11 2304-2305
  byte   PRSAP11 2306-2307
  byte   PRSMY11 2308-2309
  byte   PRSJU11 2310-2311
  byte   PRSJL11 2312-2313
  byte   PRSAU11 2314-2315
  byte   PRSSE11 2316-2317
  byte   PRSOC11 2318-2319
  byte   PRSNO11 2320-2321
  byte   PRSDE11 2322-2323
  byte   POUJA11 2324-2325
  byte   POUFE11 2326-2327
  byte   POUMA11 2328-2329
  byte   POUAP11 2330-2331
  byte   POUMY11 2332-2333
  byte   POUJU11 2334-2335
  byte   POUJL11 2336-2337
  byte   POUAU11 2338-2339
  byte   POUSE11 2340-2341
  byte   POUOC11 2342-2343
  byte   POUNO11 2344-2345
  byte   POUDE11 2346-2347
  byte   PRIJA11 2348-2349
  byte   PRIFE11 2350-2351
  byte   PRIMA11 2352-2353
  byte   PRIAP11 2354-2355
  byte   PRIMY11 2356-2357
  byte   PRIJU11 2358-2359
  byte   PRIJL11 2360-2361
  byte   PRIAU11 2362-2363
  byte   PRISE11 2364-2365
  byte   PRIOC11 2366-2367
  byte   PRINO11 2368-2369
  byte   PRIDE11 2370-2371
  byte   HPEJA11 2372-2373
  byte   HPEFE11 2374-2375
  byte   HPEMA11 2376-2377
  byte   HPEAP11 2378-2379
  byte   HPEMY11 2380-2381
  byte   HPEJU11 2382-2383
  byte   HPEJL11 2384-2385
  byte   HPEAU11 2386-2387
  byte   HPESE11 2388-2389
  byte   HPEOC11 2390-2391
  byte   HPENO11 2392-2393
  byte   HPEDE11 2394-2395
  byte   HPDJA11 2396-2397
  byte   HPDFE11 2398-2399
  byte   HPDMA11 2400-2401
  byte   HPDAP11 2402-2403
  byte   HPDMY11 2404-2405
  byte   HPDJU11 2406-2407
  byte   HPDJL11 2408-2409
  byte   HPDAU11 2410-2411
  byte   HPDSE11 2412-2413
  byte   HPDOC11 2414-2415
  byte   HPDNO11 2416-2417
  byte   HPDDE11 2418-2419
  byte   HPNJA11 2420-2421
  byte   HPNFE11 2422-2423
  byte   HPNMA11 2424-2425
  byte   HPNAP11 2426-2427
  byte   HPNMY11 2428-2429
  byte   HPNJU11 2430-2431
  byte   HPNJL11 2432-2433
  byte   HPNAU11 2434-2435
  byte   HPNSE11 2436-2437
  byte   HPNOC11 2438-2439
  byte   HPNNO11 2440-2441
  byte   HPNDE11 2442-2443
  byte   HPOJA11 2444-2445
  byte   HPOFE11 2446-2447
  byte   HPOMA11 2448-2449
  byte   HPOAP11 2450-2451
  byte   HPOMY11 2452-2453
  byte   HPOJU11 2454-2455
  byte   HPOJL11 2456-2457
  byte   HPOAU11 2458-2459
  byte   HPOSE11 2460-2461
  byte   HPOOC11 2462-2463
  byte   HPONO11 2464-2465
  byte   HPODE11 2466-2467
  byte   HPSJA11 2468-2469
  byte   HPSFE11 2470-2471
  byte   HPSMA11 2472-2473
  byte   HPSAP11 2474-2475
  byte   HPSMY11 2476-2477
  byte   HPSJU11 2478-2479
  byte   HPSJL11 2480-2481
  byte   HPSAU11 2482-2483
  byte   HPSSE11 2484-2485
  byte   HPSOC11 2486-2487
  byte   HPSNO11 2488-2489
  byte   HPSDE11 2490-2491
  byte   HPRJA11 2492-2493
  byte   HPRFE11 2494-2495
  byte   HPRMA11 2496-2497
  byte   HPRAP11 2498-2499
  byte   HPRMY11 2500-2501
  byte   HPRJU11 2502-2503
  byte   HPRJL11 2504-2505
  byte   HPRAU11 2506-2507
  byte   HPRSE11 2508-2509
  byte   HPROC11 2510-2511
  byte   HPRNO11 2512-2513
  byte   HPRDE11 2514-2515
  byte   INSJA11X 2516-2517
  byte   INSFE11X 2518-2519
  byte   INSMA11X 2520-2521
  byte   INSAP11X 2522-2523
  byte   INSMY11X 2524-2525
  byte   INSJU11X 2526-2527
  byte   INSJL11X 2528-2529
  byte   INSAU11X 2530-2531
  byte   INSSE11X 2532-2533
  byte   INSOC11X 2534-2535
  byte   INSNO11X 2536-2537
  byte   INSDE11X 2538-2539
  byte   PRVEV11 2540-2540
  byte   TRIEV11 2541-2541
  byte   MCREV11 2542-2542
  byte   MCDEV11 2543-2543
  byte   OPAEV11 2544-2544
  byte   OPBEV11 2545-2545
  byte   UNINS11 2546-2546
  byte   INSCOV11 2547-2547
  byte   INSURC11 2548-2548
  byte   TRIST31X 2549-2550
  byte   TRIST42X 2551-2552
  byte   TRIST11X 2553-2554
  byte   TRIPR31X 2555-2556
  byte   TRIPR42X 2557-2558
  byte   TRIPR11X 2559-2560
  byte   TRIEX31X 2561-2562
  byte   TRIEX42X 2563-2564
  byte   TRIEX11X 2565-2566
  byte   TRILI31X 2567-2568
  byte   TRILI42X 2569-2570
  byte   TRILI11X 2571-2572
  byte   TRICH31X 2573-2574
  byte   TRICH42X 2575-2576
  byte   TRICH11X 2577-2578
  byte   MCRPD31 2579-2580
  byte   MCRPD42 2581-2582
  byte   MCRPD11 2583-2584
  byte   MCRPD31X 2585-2586
  byte   MCRPD42X 2587-2588
  byte   MCRPD11X 2589-2590
  byte   MCRPB31 2591-2592
  byte   MCRPB42 2593-2594
  byte   MCRPB11 2595-2596
  byte   MCRPHO31 2597-2598
  byte   MCRPHO42 2599-2600
  byte   MCRPHO11 2601-2602
  byte   MCDHMO31 2603-2604
  byte   MCDHMO42 2605-2606
  byte   MCDHMO11 2607-2608
  byte   MCDMC31 2609-2610
  byte   MCDMC42 2611-2612
  byte   MCDMC11 2613-2614
  byte   PRVHMO31 2615-2616
  byte   PRVHMO42 2617-2618
  byte   PRVHMO11 2619-2620
  byte   PRVMNC31 2621-2622
  byte   PRVMNC42 2623-2624
  byte   PRVMNC11 2625-2626
  byte   PRVDRL31 2627-2628
  byte   PRVDRL42 2629-2630
  byte   PRVDRL11 2631-2632
  byte   PHMONP31 2633-2634
  byte   PHMONP42 2635-2636
  byte   PHMONP11 2637-2638
  byte   PMNCNP31 2639-2640
  byte   PMNCNP42 2641-2642
  byte   PMNCNP11 2643-2644
  byte   PRDRNP31 2645-2646
  byte   PRDRNP42 2647-2648
  byte   PRDRNP11 2649-2650
  byte   FSAGT31 2651-2652
  byte   HASFSA31 2653-2654
  double FSAAMT31 2655-2662
  byte   PREVCOVR 2663-2664
  byte   COVRMM 2665-2666
  int    COVRYY 2667-2670
  byte   WASESTB 2671-2672
  byte   WASMCARE 2673-2674
  byte   WASMCAID 2675-2676
  byte   WASCHAMP 2677-2678
  byte   WASVA 2679-2680
  byte   WASPRIV 2681-2682
  byte   WASOTGOV 2683-2684
  byte   WASAFDC 2685-2686
  byte   WASSSI 2687-2688
  byte   WASSTAT1 2689-2690
  byte   WASSTAT2 2691-2692
  byte   WASSTAT3 2693-2694
  byte   WASSTAT4 2695-2696
  byte   WASOTHER 2697-2698
  byte   NOINSBEF 2699-2700
  byte   NOINSTM 2701-2702
  byte   NOINUNIT 2703-2704
  byte   MORECOVR 2705-2706
  byte   INSENDMM 2707-2708
  int    INSENDYY 2709-2712
  byte   TRICR31X 2713-2714
  byte   TRICR42X 2715-2716
  byte   TRICR53X 2717-2718
  byte   TRICR11X 2719-2720
  byte   TRIAT31X 2721-2722
  byte   TRIAT42X 2723-2724
  byte   TRIAT53X 2725-2726
  byte   TRIAT11X 2727-2728
  byte   MCAID31 2729-2730
  byte   MCAID42 2731-2732
  byte   MCAID53 2733-2734
  byte   MCAID11 2735-2736
  byte   MCAID31X 2737-2738
  byte   MCAID42X 2739-2740
  byte   MCAID53X 2741-2742
  byte   MCAID11X 2743-2744
  byte   MCARE31 2745-2746
  byte   MCARE42 2747-2748
  byte   MCARE53 2749-2750
  byte   MCARE11 2751-2752
  byte   MCARE31X 2753-2754
  byte   MCARE42X 2755-2756
  byte   MCARE53X 2757-2758
  byte   MCARE11X 2759-2760
  byte   MCDAT31X 2761-2762
  byte   MCDAT42X 2763-2764
  byte   MCDAT53X 2765-2766
  byte   MCDAT11X 2767-2768
  byte   OTPAAT31 2769-2770
  byte   OTPAAT42 2771-2772
  byte   OTPAAT53 2773-2774
  byte   OTPAAT11 2775-2776
  byte   OTPBAT31 2777-2778
  byte   OTPBAT42 2779-2780
  byte   OTPBAT53 2781-2782
  byte   OTPBAT11 2783-2784
  byte   OTPUBA31 2785-2786
  byte   OTPUBA42 2787-2788
  byte   OTPUBA53 2789-2790
  byte   OTPUBA11 2791-2792
  byte   OTPUBB31 2793-2794
  byte   OTPUBB42 2795-2796
  byte   OTPUBB53 2797-2798
  byte   OTPUBB11 2799-2800
  byte   PRIDK31 2801-2802
  byte   PRIDK42 2803-2804
  byte   PRIDK53 2805-2806
  byte   PRIDK11 2807-2808
  byte   PRIEU31 2809-2810
  byte   PRIEU42 2811-2812
  byte   PRIEU53 2813-2814
  byte   PRIEU11 2815-2816
  byte   PRING31 2817-2818
  byte   PRING42 2819-2820
  byte   PRING53 2821-2822
  byte   PRING11 2823-2824
  byte   PRIOG31 2825-2826
  byte   PRIOG42 2827-2828
  byte   PRIOG53 2829-2830
  byte   PRIOG11 2831-2832
  byte   PRIS31 2833-2834
  byte   PRIS42 2835-2836
  byte   PRIS53 2837-2838
  byte   PRIS11 2839-2840
  byte   PRIV31 2841-2842
  byte   PRIV42 2843-2844
  byte   PRIV53 2845-2846
  byte   PRIV11 2847-2848
  byte   PRIVAT31 2849-2850
  byte   PRIVAT42 2851-2852
  byte   PRIVAT53 2853-2854
  byte   PRIVAT11 2855-2856
  byte   PROUT31 2857-2858
  byte   PROUT42 2859-2860
  byte   PROUT53 2861-2862
  byte   PROUT11 2863-2864
  byte   PUB31X 2865-2866
  byte   PUB42X 2867-2868
  byte   PUB53X 2869-2870
  byte   PUB11X 2871-2872
  byte   PUBAT31X 2873-2874
  byte   PUBAT42X 2875-2876
  byte   PUBAT53X 2877-2878
  byte   PUBAT11X 2879-2880
  byte   INS31X 2881-2882
  byte   INS42X 2883-2884
  byte   INS53X 2885-2886
  byte   INS11X 2887-2888
  byte   INSAT31X 2889-2890
  byte   INSAT42X 2891-2892
  byte   INSAT53X 2893-2894
  byte   INSAT11X 2895-2896
  byte   STAPR31 2897-2898
  byte   STAPR42 2899-2900
  byte   STAPR53 2901-2902
  byte   STAPR11 2903-2904
  byte   STPRAT31 2905-2906
  byte   STPRAT42 2907-2908
  byte   STPRAT53 2909-2910
  byte   STPRAT11 2911-2912
  byte   EVRUNINS 2913-2913
  byte   EVRUNAT 2914-2914
  byte   DENTIN31 2915-2916
  byte   DENTIN42 2917-2918
  byte   DENTIN53 2919-2920
  byte   DNTINS31 2921-2922
  byte   DNTINS11 2923-2924
  byte   PMEDIN31 2925-2926
  byte   PMEDIN42 2927-2928
  byte   PMEDIN53 2929-2930
  byte   PMDINS31 2931-2932
  byte   PMDINS11 2933-2934
  byte   PMEDUP31 2935-2936
  byte   PMEDUP42 2937-2938
  byte   PMEDUP53 2939-2940
  byte   PMEDPY31 2941-2942
  byte   PMEDPY42 2943-2944
  byte   PMEDPY53 2945-2946
  double PMEDPP31 2947-2953
  double PMEDPP42 2954-2960
  double PMEDPP53 2961-2967
  byte   GDCPBM42 2968-2969
  byte   APRTRM42 2970-2971
  byte   APRDLM42 2972-2973
  byte   LKINFM42 2974-2975
  byte   PBINFM42 2976-2977
  byte   CSTSVM42 2978-2979
  byte   PBSVCM42 2980-2981
  byte   PPRWKM42 2982-2983
  byte   PBPWKM42 2984-2985
  byte   RTPLNM42 2986-2987
  byte   GDCPBT42 2988-2989
  byte   APRTRT42 2990-2991
  byte   APRDLT42 2992-2993
  byte   LKINFT42 2994-2995
  byte   PBINFT42 2996-2997
  byte   CSTSVT42 2998-2999
  byte   PBSVCT42 3000-3001
  byte   PPRWKT42 3002-3003
  byte   PBPWKT42 3004-3005
  byte   RTPLNT42 3006-3007
  long   TOTTCH11 3008-3014
  long   TOTEXP11 3015-3021
  long   TOTSLF11 3022-3026
  long   TOTMCR11 3027-3032
  long   TOTMCD11 3033-3039
  long   TOTPRV11 3040-3045
  long   TOTVA11 3046-3051
  long   TOTTRI11 3052-3057
  long   TOTOFD11 3058-3062
  long   TOTSTL11 3063-3067
  long   TOTWCP11 3068-3073
  long   TOTOPR11 3074-3079
  long   TOTOPU11 3080-3085
  long   TOTOSR11 3086-3090
  long   TOTPTR11 3091-3096
  long   TOTOTH11 3097-3102
  int    OBTOTV11 3103-3105
  long   OBVTCH11 3106-3111
  long   OBVEXP11 3112-3117
  long   OBVSLF11 3118-3122
  long   OBVMCR11 3123-3128
  long   OBVMCD11 3129-3133
  long   OBVPRV11 3134-3138
  long   OBVVA11 3139-3143
  long   OBVTRI11 3144-3148
  long   OBVOFD11 3149-3153
  int    OBVSTL11 3154-3157
  long   OBVWCP11 3158-3162
  long   OBVOPR11 3163-3167
  long   OBVOPU11 3168-3172
  long   OBVOSR11 3173-3177
  long   OBVPTR11 3178-3182
  long   OBVOTH11 3183-3187
  int    OBDRV11 3188-3190
  long   OBDTCH11 3191-3196
  long   OBDEXP11 3197-3202
  long   OBDSLF11 3203-3207
  long   OBDMCR11 3208-3213
  long   OBDMCD11 3214-3218
  long   OBDPRV11 3219-3223
  long   OBDVA11 3224-3228
  long   OBDTRI11 3229-3233
  long   OBDOFD11 3234-3238
  int    OBDSTL11 3239-3242
  long   OBDWCP11 3243-3247
  long   OBDOPR11 3248-3252
  long   OBDOPU11 3253-3257
  long   OBDOSR11 3258-3262
  long   OBDPTR11 3263-3267
  long   OBDOTH11 3268-3272
  int    OBOTHV11 3273-3275
  long   OBOTCH11 3276-3281
  long   OBOEXP11 3282-3286
  long   OBOSLF11 3287-3291
  long   OBOMCR11 3292-3296
  long   OBOMCD11 3297-3301
  long   OBOPRV11 3302-3306
  long   OBOVA11 3307-3311
  int    OBOTRI11 3312-3315
  int    OBOOFD11 3316-3319
  int    OBOSTL11 3320-3323
  long   OBOWCP11 3324-3328
  long   OBOOPR11 3329-3333
  long   OBOOPU11 3334-3338
  long   OBOOSR11 3339-3343
  long   OBOPTR11 3344-3348
  long   OBOOTH11 3349-3353
  int    OBCHIR11 3354-3356
  long   OBCTCH11 3357-3361
  long   OBCEXP11 3362-3366
  long   OBCSLF11 3367-3371
  int    OBCMCR11 3372-3375
  long   OBCMCD11 3376-3380
  int    OBCPRV11 3381-3384
  long   OBCVA11 3385-3389
  int    OBCTRI11 3390-3393
  byte   OBCOFD11 3394-3395
  int    OBCSTL11 3396-3398
  int    OBCWCP11 3399-3402
  int    OBCOPR11 3403-3405
  int    OBCOPU11 3406-3408
  long   OBCOSR11 3409-3413
  int    OBCPTR11 3414-3417
  long   OBCOTH11 3418-3422
  int    OBNURS11 3423-3425
  long   OBNTCH11 3426-3431
  long   OBNEXP11 3432-3436
  int    OBNSLF11 3437-3440
  long   OBNMCR11 3441-3445
  long   OBNMCD11 3446-3450
  long   OBNPRV11 3451-3455
  int    OBNVA11 3456-3459
  int    OBNTRI11 3460-3462
  int    OBNOFD11 3463-3466
  int    OBNSTL11 3467-3469
  int    OBNWCP11 3470-3472
  int    OBNOPR11 3473-3476
  int    OBNOPU11 3477-3480
  int    OBNOSR11 3481-3484
  long   OBNPTR11 3485-3489
  int    OBNOTH11 3490-3493
  byte   OBOPTO11 3494-3494
  long   OBETCH11 3495-3499
  int    OBEEXP11 3500-3503
  int    OBESLF11 3504-3507
  int    OBEMCR11 3508-3511
  int    OBEMCD11 3512-3514
  int    OBEPRV11 3515-3518
  int    OBEVA11 3519-3522
  int    OBETRI11 3523-3525
  int    OBEOFD11 3526-3528
  int    OBESTL11 3529-3531
  int    OBEWCP11 3532-3534
  int    OBEOPR11 3535-3538
  int    OBEOPU11 3539-3541
  int    OBEOSR11 3542-3544
  int    OBEPTR11 3545-3548
  int    OBEOTH11 3549-3552
  byte   OBASST11 3553-3554
  long   OBATCH11 3555-3559
  long   OBAEXP11 3560-3564
  long   OBASLF11 3565-3569
  int    OBAMCR11 3570-3573
  int    OBAMCD11 3574-3577
  int    OBAPRV11 3578-3581
  int    OBAVA11 3582-3584
  int    OBATRI11 3585-3587
  int    OBAOFD11 3588-3590
  int    OBASTL11 3591-3593
  int    OBAWCP11 3594-3597
  int    OBAOPR11 3598-3600
  byte   OBAOPU11 3601-3602
  int    OBAOSR11 3603-3606
  int    OBAPTR11 3607-3610
  int    OBAOTH11 3611-3614
  int    OBTHER11 3615-3617
  long   OBTTCH11 3618-3623
  long   OBTEXP11 3624-3628
  long   OBTSLF11 3629-3633
  int    OBTMCR11 3634-3637
  long   OBTMCD11 3638-3642
  long   OBTPRV11 3643-3647
  int    OBTVA11 3648-3651
  int    OBTTRI11 3652-3655
  byte   OBTOFD11 3656-3656
  int    OBTSTL11 3657-3660
  long   OBTWCP11 3661-3665
  long   OBTOPR11 3666-3670
  int    OBTOPU11 3671-3674
  int    OBTOSR11 3675-3678
  long   OBTPTR11 3679-3683
  long   OBTOTH11 3684-3688
  int    OPTOTV11 3689-3691
  long   OPTTCH11 3692-3697
  long   OPTEXP11 3698-3703
  long   OPTSLF11 3704-3708
  long   OPTMCR11 3709-3713
  long   OPTMCD11 3714-3718
  long   OPTPRV11 3719-3724
  long   OPTVA11 3725-3729
  long   OPTTRI11 3730-3735
  long   OPTOFD11 3736-3740
  long   OPTSTL11 3741-3745
  long   OPTWCP11 3746-3750
  long   OPTOPR11 3751-3756
  long   OPTOPU11 3757-3761
  long   OPTOSR11 3762-3766
  long   OPTPTR11 3767-3772
  long   OPTOTH11 3773-3778
  long   OPFTCH11 3779-3784
  long   OPFEXP11 3785-3790
  long   OPFSLF11 3791-3795
  long   OPFMCR11 3796-3800
  long   OPFMCD11 3801-3805
  long   OPFPRV11 3806-3811
  long   OPFVA11 3812-3816
  long   OPFTRI11 3817-3822
  long   OPFOFD11 3823-3827
  long   OPFSTL11 3828-3832
  long   OPFWCP11 3833-3837
  long   OPFOPR11 3838-3843
  long   OPFOPU11 3844-3848
  long   OPFOSR11 3849-3853
  long   OPFPTR11 3854-3859
  long   OPFOTH11 3860-3865
  long   OPDEXP11 3866-3870
  long   OPDTCH11 3871-3875
  int    OPDSLF11 3876-3879
  long   OPDMCR11 3880-3884
  int    OPDMCD11 3885-3888
  long   OPDPRV11 3889-3893
  int    OPDVA11 3894-3897
  int    OPDTRI11 3898-3901
  byte   OPDOFD11 3902-3902
  int    OPDSTL11 3903-3906
  int    OPDWCP11 3907-3910
  int    OPDOPR11 3911-3914
  int    OPDOPU11 3915-3918
  int    OPDOSR11 3919-3922
  long   OPDPTR11 3923-3927
  int    OPDOTH11 3928-3931
  int    OPDRV11 3932-3934
  long   OPVTCH11 3935-3940
  long   OPVEXP11 3941-3946
  long   OPVSLF11 3947-3951
  long   OPVMCR11 3952-3956
  long   OPVMCD11 3957-3961
  long   OPVPRV11 3962-3967
  long   OPVVA11 3968-3972
  long   OPVTRI11 3973-3977
  long   OPVOFD11 3978-3982
  long   OPVSTL11 3983-3987
  long   OPVWCP11 3988-3992
  long   OPVOPR11 3993-3998
  long   OPVOPU11 3999-4003
  long   OPVOSR11 4004-4008
  long   OPVPTR11 4009-4014
  long   OPVOTH11 4015-4020
  long   OPSEXP11 4021-4025
  long   OPSTCH11 4026-4030
  int    OPSSLF11 4031-4034
  long   OPSMCR11 4035-4039
  int    OPSMCD11 4040-4043
  long   OPSPRV11 4044-4048
  int    OPSVA11 4049-4051
  int    OPSTRI11 4052-4055
  byte   OPSOFD11 4056-4056
  int    OPSSTL11 4057-4060
  int    OPSWCP11 4061-4064
  int    OPSOPR11 4065-4068
  int    OPSOPU11 4069-4072
  int    OPSOSR11 4073-4076
  long   OPSPTR11 4077-4081
  int    OPSOTH11 4082-4085
  byte   OPOTHV11 4086-4087
  long   OPOTCH11 4088-4093
  long   OPOEXP11 4094-4098
  long   OPOSLF11 4099-4103
  long   OPOMCR11 4104-4108
  int    OPOMCD11 4109-4112
  long   OPOPRV11 4113-4117
  long   OPOVA11 4118-4122
  long   OPOTRI11 4123-4127
  int    OPOOFD11 4128-4131
  int    OPOSTL11 4132-4135
  int    OPOWCP11 4136-4139
  int    OPOOPR11 4140-4143
  int    OPOOPU11 4144-4147
  long   OPOOSR11 4148-4152
  long   OPOPTR11 4153-4157
  long   OPOOTH11 4158-4162
  long   OPPEXP11 4163-4167
  long   OPPTCH11 4168-4172
  int    OPPSLF11 4173-4176
  int    OPPMCR11 4177-4180
  int    OPPMCD11 4181-4183
  long   OPPPRV11 4184-4188
  int    OPPVA11 4189-4191
  int    OPPTRI11 4192-4194
  byte   OPPOFD11 4195-4195
  int    OPPSTL11 4196-4199
  int    OPPWCP11 4200-4203
  int    OPPOPR11 4204-4206
  int    OPPOPU11 4207-4210
  int    OPPOSR11 4211-4213
  long   OPPPTR11 4214-4218
  int    OPPOTH11 4219-4222
  int    AMCHIR11 4223-4225
  long   AMCTCH11 4226-4230
  long   AMCEXP11 4231-4235
  long   AMCSLF11 4236-4240
  int    AMCMCR11 4241-4244
  long   AMCMCD11 4245-4249
  int    AMCPRV11 4250-4253
  long   AMCVA11 4254-4258
  int    AMCTRI11 4259-4262
  byte   AMCOFD11 4263-4264
  int    AMCSTL11 4265-4267
  int    AMCWCP11 4268-4271
  int    AMCOPR11 4272-4274
  int    AMCOPU11 4275-4277
  long   AMCOSR11 4278-4282
  int    AMCPTR11 4283-4286
  long   AMCOTH11 4287-4291
  int    AMNURS11 4292-4294
  long   AMNTCH11 4295-4300
  long   AMNEXP11 4301-4305
  int    AMNSLF11 4306-4309
  long   AMNMCR11 4310-4314
  long   AMNMCD11 4315-4319
  long   AMNPRV11 4320-4324
  int    AMNVA11 4325-4328
  long   AMNTRI11 4329-4333
  int    AMNOFD11 4334-4337
  int    AMNSTL11 4338-4341
  int    AMNWCP11 4342-4344
  int    AMNOPR11 4345-4348
  int    AMNOPU11 4349-4352
  int    AMNOSR11 4353-4356
  long   AMNPTR11 4357-4361
  int    AMNOTH11 4362-4365
  byte   AMOPTO11 4366-4366
  long   AMETCH11 4367-4371
  int    AMEEXP11 4372-4375
  int    AMESLF11 4376-4379
  int    AMEMCR11 4380-4383
  int    AMEMCD11 4384-4386
  int    AMEPRV11 4387-4390
  int    AMEVA11 4391-4394
  int    AMETRI11 4395-4397
  int    AMEOFD11 4398-4400
  int    AMESTL11 4401-4403
  int    AMEWCP11 4404-4406
  int    AMEOPR11 4407-4410
  int    AMEOPU11 4411-4413
  int    AMEOSR11 4414-4416
  int    AMEPTR11 4417-4420
  int    AMEOTH11 4421-4424
  byte   AMASST11 4425-4426
  long   AMATCH11 4427-4431
  long   AMAEXP11 4432-4436
  long   AMASLF11 4437-4441
  int    AMAMCR11 4442-4445
  int    AMAMCD11 4446-4449
  int    AMAPRV11 4450-4453
  int    AMAVA11 4454-4457
  int    AMATRI11 4458-4461
  int    AMAOFD11 4462-4464
  int    AMASTL11 4465-4467
  int    AMAWCP11 4468-4471
  int    AMAOPR11 4472-4474
  int    AMAOPU11 4475-4477
  long   AMAOSR11 4478-4482
  int    AMAPTR11 4483-4486
  long   AMAOTH11 4487-4491
  int    AMTHER11 4492-4494
  long   AMTTCH11 4495-4500
  long   AMTEXP11 4501-4505
  long   AMTSLF11 4506-4510
  long   AMTMCR11 4511-4515
  long   AMTMCD11 4516-4520
  long   AMTPRV11 4521-4525
  int    AMTVA11 4526-4529
  int    AMTTRI11 4530-4533
  int    AMTOFD11 4534-4537
  int    AMTSTL11 4538-4541
  long   AMTWCP11 4542-4546
  long   AMTOPR11 4547-4551
  int    AMTOPU11 4552-4555
  int    AMTOSR11 4556-4559
  long   AMTPTR11 4560-4564
  long   AMTOTH11 4565-4569
  byte   AMTOTC11 4570-4571
  byte   AMDRC11 4572-4572
  byte   ERTOT11 4573-4574
  long   ERTTCH11 4575-4580
  long   ERTEXP11 4581-4585
  long   ERTSLF11 4586-4590
  long   ERTMCR11 4591-4595
  long   ERTMCD11 4596-4600
  long   ERTPRV11 4601-4605
  long   ERTVA11 4606-4610
  int    ERTTRI11 4611-4614
  int    ERTOFD11 4615-4618
  long   ERTSTL11 4619-4623
  long   ERTWCP11 4624-4628
  long   ERTOPR11 4629-4633
  long   ERTOPU11 4634-4638
  long   ERTOSR11 4639-4643
  long   ERTPTR11 4644-4648
  long   ERTOTH11 4649-4653
  long   ERFTCH11 4654-4659
  long   ERFEXP11 4660-4664
  long   ERFSLF11 4665-4669
  long   ERFMCR11 4670-4674
  long   ERFMCD11 4675-4679
  long   ERFPRV11 4680-4684
  long   ERFVA11 4685-4689
  int    ERFTRI11 4690-4693
  int    ERFOFD11 4694-4697
  long   ERFSTL11 4698-4702
  long   ERFWCP11 4703-4707
  long   ERFOPR11 4708-4712
  long   ERFOPU11 4713-4717
  long   ERFOSR11 4718-4722
  long   ERFPTR11 4723-4727
  long   ERFOTH11 4728-4732
  int    ERDEXP11 4733-4736
  long   ERDTCH11 4737-4741
  int    ERDSLF11 4742-4745
  int    ERDMCR11 4746-4749
  int    ERDMCD11 4750-4753
  int    ERDPRV11 4754-4757
  int    ERDVA11 4758-4760
  int    ERDTRI11 4761-4763
  byte   ERDOFD11 4764-4764
  int    ERDSTL11 4765-4768
  int    ERDWCP11 4769-4771
  int    ERDOPR11 4772-4775
  int    ERDOPU11 4776-4778
  int    ERDOSR11 4779-4782
  int    ERDPTR11 4783-4786
  int    ERDOTH11 4787-4790
  byte   IPZERO11 4791-4791
  long   ZIFTCH11 4792-4796
  long   ZIFEXP11 4797-4801
  int    ZIFSLF11 4802-4805
  long   ZIFMCR11 4806-4810
  long   ZIFMCD11 4811-4815
  long   ZIFPRV11 4816-4820
  byte   ZIFVA11 4821-4821
  int    ZIFTRI11 4822-4825
  byte   ZIFOFD11 4826-4826
  byte   ZIFSTL11 4827-4827
  int    ZIFWCP11 4828-4831
  byte   ZIFOPR11 4832-4833
  byte   ZIFOPU11 4834-4834
  int    ZIFOSR11 4835-4838
  long   ZIFPTR11 4839-4843
  int    ZIFOTH11 4844-4847
  int    ZIDEXP11 4848-4851
  long   ZIDTCH11 4852-4856
  int    ZIDSLF11 4857-4859
  int    ZIDMCR11 4860-4863
  int    ZIDMCD11 4864-4867
  int    ZIDPRV11 4868-4871
  byte   ZIDVA11 4872-4872
  int    ZIDTRI11 4873-4875
  byte   ZIDOFD11 4876-4876
  int    ZIDSTL11 4877-4880
  int    ZIDWCP11 4881-4884
  int    ZIDOPR11 4885-4887
  byte   ZIDOPU11 4888-4889
  byte   ZIDOSR11 4890-4890
  int    ZIDPTR11 4891-4894
  int    ZIDOTH11 4895-4898
  byte   IPDIS11 4899-4899
  long   IPTEXP11 4900-4905
  long   IPTTCH11 4906-4912
  long   IPTSLF11 4913-4917
  long   IPTMCR11 4918-4923
  long   IPTMCD11 4924-4929
  long   IPTPRV11 4930-4935
  long   IPTVA11 4936-4941
  long   IPTTRI11 4942-4946
  long   IPTOFD11 4947-4951
  long   IPTSTL11 4952-4956
  long   IPTWCP11 4957-4962
  long   IPTOPR11 4963-4968
  long   IPTOPU11 4969-4973
  long   IPTOSR11 4974-4978
  long   IPTPTR11 4979-4984
  long   IPTOTH11 4985-4990
  long   IPFEXP11 4991-4996
  long   IPFTCH11 4997-5003
  long   IPFSLF11 5004-5008
  long   IPFMCR11 5009-5014
  long   IPFMCD11 5015-5020
  long   IPFPRV11 5021-5026
  long   IPFVA11 5027-5032
  long   IPFTRI11 5033-5037
  long   IPFOFD11 5038-5042
  long   IPFSTL11 5043-5047
  long   IPFWCP11 5048-5053
  long   IPFOPR11 5054-5059
  long   IPFOPU11 5060-5064
  long   IPFOSR11 5065-5069
  long   IPFPTR11 5070-5075
  long   IPFOTH11 5076-5081
  long   IPDEXP11 5082-5086
  long   IPDTCH11 5087-5092
  long   IPDSLF11 5093-5097
  long   IPDMCR11 5098-5102
  long   IPDMCD11 5103-5107
  long   IPDPRV11 5108-5112
  int    IPDVA11 5113-5116
  long   IPDTRI11 5117-5121
  byte   IPDOFD11 5122-5122
  int    IPDSTL11 5123-5126
  long   IPDWCP11 5127-5131
  long   IPDOPR11 5132-5136
  int    IPDOPU11 5137-5140
  int    IPDOSR11 5141-5144
  long   IPDPTR11 5145-5149
  long   IPDOTH11 5150-5154
  int    IPNGTD11 5155-5157
  byte   DVTOT11 5158-5159
  long   DVTTCH11 5160-5164
  long   DVTEXP11 5165-5169
  long   DVTSLF11 5170-5174
  int    DVTMCR11 5175-5178
  long   DVTMCD11 5179-5183
  long   DVTPRV11 5184-5188
  int    DVTVA11 5189-5192
  int    DVTTRI11 5193-5196
  int    DVTOFD11 5197-5200
  int    DVTSTL11 5201-5204
  int    DVTWCP11 5205-5207
  int    DVTOPR11 5208-5211
  int    DVTOPU11 5212-5215
  int    DVTOSR11 5216-5219
  long   DVTPTR11 5220-5224
  int    DVTOTH11 5225-5228
  byte   DVGEN11 5229-5230
  long   DVGTCH11 5231-5235
  long   DVGEXP11 5236-5240
  long   DVGSLF11 5241-5245
  int    DVGMCR11 5246-5249
  int    DVGMCD11 5250-5253
  long   DVGPRV11 5254-5258
  int    DVGVA11 5259-5262
  int    DVGTRI11 5263-5266
  int    DVGOFD11 5267-5270
  int    DVGSTL11 5271-5274
  int    DVGWCP11 5275-5277
  int    DVGOPR11 5278-5281
  int    DVGOPU11 5282-5285
  int    DVGOSR11 5286-5289
  long   DVGPTR11 5290-5294
  int    DVGOTH11 5295-5298
  byte   DVORTH11 5299-5300
  long   DVOTCH11 5301-5305
  long   DVOEXP11 5306-5310
  long   DVOSLF11 5311-5315
  int    DVOMCR11 5316-5319
  long   DVOMCD11 5320-5324
  long   DVOPRV11 5325-5329
  int    DVOVA11 5330-5332
  int    DVOTRI11 5333-5335
  byte   DVOOFD11 5336-5337
  int    DVOSTL11 5338-5341
  byte   DVOWCP11 5342-5342
  int    DVOOPR11 5343-5346
  int    DVOOPU11 5347-5349
  int    DVOOSR11 5350-5353
  long   DVOPTR11 5354-5358
  int    DVOOTH11 5359-5362
  int    HHTOTD11 5363-5365
  int    HHAGD11 5366-5368
  long   HHATCH11 5369-5374
  long   HHAEXP11 5375-5380
  int    HHASLF11 5381-5384
  long   HHAMCR11 5385-5389
  long   HHAMCD11 5390-5395
  long   HHAPRV11 5396-5400
  int    HHAVA11 5401-5404
  byte   HHATRI11 5405-5405
  byte   HHAOFD11 5406-5406
  long   HHASTL11 5407-5411
  int    HHAWCP11 5412-5414
  int    HHAOPR11 5415-5418
  long   HHAOPU11 5419-5423
  int    HHAOSR11 5424-5427
  long   HHAPTR11 5428-5432
  long   HHAOTH11 5433-5437
  int    HHINDD11 5438-5440
  long   HHNTCH11 5441-5445
  long   HHNEXP11 5446-5450
  long   HHNSLF11 5451-5455
  long   HHNMCD11 5456-5460
  int    HHNMCR11 5461-5463
  int    HHNPRV11 5464-5467
  byte   HHNVA11 5468-5468
  byte   HHNTRI11 5469-5469
  byte   HHNOFD11 5470-5470
  byte   HHNSTL11 5471-5471
  byte   HHNWCP11 5472-5472
  byte   HHNOPR11 5473-5474
  int    HHNOPU11 5475-5478
  byte   HHNOSR11 5479-5479
  int    HHNPTR11 5480-5483
  int    HHNOTH11 5484-5487
  int    HHINFD11 5488-5490
  long   VISEXP11 5491-5495
  long   VISTCH11 5496-5500
  int    VISSLF11 5501-5504
  long   VISMCR11 5505-5509
  int    VISMCD11 5510-5513
  long   VISPRV11 5514-5518
  int    VISVA11 5519-5521
  int    VISTRI11 5522-5524
  int    VISOFD11 5525-5527
  int    VISSTL11 5528-5530
  byte   VISWCP11 5531-5531
  int    VISOPR11 5532-5534
  int    VISOPU11 5535-5537
  int    VISOSR11 5538-5541
  long   VISPTR11 5542-5546
  int    VISOTH11 5547-5550
  long   OTHTCH11 5551-5555
  long   OTHEXP11 5556-5560
  long   OTHSLF11 5561-5565
  int    OTHMCR11 5566-5569
  long   OTHMCD11 5570-5574
  long   OTHPRV11 5575-5579
  int    OTHVA11 5580-5583
  int    OTHTRI11 5584-5587
  byte   OTHOFD11 5588-5588
  int    OTHSTL11 5589-5591
  int    OTHWCP11 5592-5595
  int    OTHOPR11 5596-5599
  int    OTHOPU11 5600-5602
  int    OTHOSR11 5603-5606
  long   OTHPTR11 5607-5611
  int    OTHOTH11 5612-5615
  int    RXTOT11 5616-5618
  long   RXEXP11 5619-5625
  long   RXSLF11 5626-5630
  long   RXMCR11 5631-5636
  long   RXMCD11 5637-5643
  long   RXPRV11 5644-5648
  long   RXVA11 5649-5653
  long   RXTRI11 5654-5658
  int    RXOFD11 5659-5662
  long   RXSTL11 5663-5667
  long   RXWCP11 5668-5672
  long   RXOPR11 5673-5677
  int    RXOPU11 5678-5681
  int    RXOSR11 5682-5685
  long   RXPTR11 5686-5690
  long   RXOTH11 5691-5695
  double PERWT11F 5696-5708
  double FAMWT11F 5709-5720
  double FAMWT11C 5721-5732
  double SAQWT11F 5733-5744
  double DIABW11F 5745-5756
  double CSAQW11F 5757-5768
  int    VARSTR 5769-5772
  byte   VARPSU 5773-5773
using H147.dat;

*DEFINE VARIABLE LABELS;
label variable DUID "DWELLING UNIT ID";
label variable PID "PERSON NUMBER";
label variable DUPERSID "PERSON ID (DUID + PID)";
label variable PANEL "PANEL NUMBER";
label variable FAMID31 "FAMILY ID (STUDENT MERGED IN) - R3/1";
label variable FAMID42 "FAMILY ID (STUDENT MERGED IN) - R4/2";
label variable FAMID53 "FAMILY ID (STUDENT MERGED IN) - R5/3";
label variable FAMID11 "FAMILY ID (STUDENT MERGED IN) - 12/31/11";
label variable FAMIDYR "ANNUAL FAMILY IDENTIFIER";
label variable CPSFAMID "CPSFAMID";
label variable FCSZ1231 "FAM SIZE RESPONDING 12/31 CPS FAMILY";
label variable FCRP1231 "REF PERSON OF 12/31 CPS FAMILY";
label variable RULETR31 "RU LETTER - R3/1";
label variable RULETR42 "RU LETTER - R4/2";
label variable RULETR53 "RU LETTER - R5/3";
label variable RULETR11 "RU LETTER AS OF 12/31/11";
label variable RUSIZE31 "RU SIZE - R3/1";
label variable RUSIZE42 "RU SIZE - R4/2";
label variable RUSIZE53 "RU SIZE - R5/3";
label variable RUSIZE11 "RU SIZE AS OF 12/31/11";
label variable RUCLAS31 "RU FIELDED AS:STANDARD/NEW/STUDENT-R3/1";
label variable RUCLAS42 "RU FIELDED AS:STANDARD/NEW/STUDENT-R4/2";
label variable RUCLAS53 "RU FIELDED AS:STANDARD/NEW/STUDENT-R5/3";
label variable RUCLAS11 "RU FIELDED AS:STANDARD/NEW/STUD-12/31/11";
label variable FAMSZE31 "RU SIZE INCLUDING STUDENTS - R3/1";
label variable FAMSZE42 "RU SIZE INCLUDING STUDENTS - R4/2";
label variable FAMSZE53 "RU SIZE INCLUDING STUDENTS - R5/3";
label variable FAMSZE11 "RU SIZE INCLUDING STUDENT AS OF 12/31/11";
label variable FMRS1231 "MEMBER OF RESPONDING 12/31 FAMILY";
label variable FAMS1231 "FAMILY SIZE OF RESPONDING 12/31 FAMILY";
label variable FAMSZEYR "SIZE OF RESPONDING ANNUALIZED FAMILY";
label variable FAMRFPYR "REFERENCE PERSON OF ANNUALIZED FAMILY";
label variable REGION31 "CENSUS REGION - R3/1";
label variable REGION42 "CENSUS REGION - R4/2";
label variable REGION53 "CENSUS REGION - R5/3";
label variable REGION11 "CENSUS REGION AS OF 12/31/11";
label variable MSA31 "MSA STATUS - R3/1";
label variable MSA42 "MSA STATUS - R4/2";
label variable MSA53 "MSA STATUS - R5/3";
label variable MSA11 "MSA AS OF 12/31/11";
label variable REFPRS31 "REFERENCE PERSON AT - R3/1";
label variable REFPRS42 "REFERENCE PERSON AT - R4/2";
label variable REFPRS53 "REFERENCE PERSON AT - R5/3";
label variable REFPRS11 "REFERENCE PERSON AS OF 12/31/11";
label variable RESP31 "1ST RESPONDENT INDICATOR FOR R3/1";
label variable RESP42 "1ST RESPONDENT INDICATOR FOR R4/2";
label variable RESP53 "1ST RESPONDENT INDICATOR FOR R5/3";
label variable RESP11 "1ST RESPONDENT INDICATOR AS OF 12/31/11";
label variable PROXY31 "WAS RESPONDENT A PROXY IN R3/1";
label variable PROXY42 "WAS RESPONDENT A PROXY IN R4/2";
label variable PROXY53 "WAS RESPONDENT A PROXY IN R5/3";
label variable PROXY11 "WAS RESPONDENT A PROXY AS OF 12/31/11";
label variable INTVLANG "LANGUAGE INTERVIEW WAS COMPLETED";
label variable BEGRFD31 "R3/1 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM31 "R3/1 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY31 "R3/1 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD31 "R3/1 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM31 "R3/1 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY31 "R3/1 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFD42 "R4/2 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM42 "R4/2 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY42 "R4/2 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD42 "R4/2 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM42 "R4/2 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY42 "R4/2 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFD53 "R5/3 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM53 "R5/3 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY53 "R5/3 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD53 "R5/3 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM53 "R5/3 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY53 "R5/3 REFERENCE PERIOD END DATE: YEAR";
label variable ENDRFD11 "2011 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM11 "2011 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY11 "2011 REFERENCE PERIOD END DATE: YEAR";
label variable KEYNESS "PERSON KEY STATUS";
label variable INSCOP31 "INSCOPE - R3/1";
label variable INSCOP42 "INSCOPE - R4/2";
label variable INSCOP53 "INSCOPE - R5/3";
label variable INSCOP11 "INSCOPE - R5/3 START THROUGH 12/31/11";
label variable INSC1231 "INSCOPE STATUS ON 12/31/11";
label variable INSCOPE "WAS PERSON EVER INSCOPE IN 2011";
label variable ELGRND31 "ELIGIBILITY - R3/1";
label variable ELGRND42 "ELIGIBILITY - R4/2";
label variable ELGRND53 "ELIGIBILITY - R5/3";
label variable ELGRND11 "ELIGIBILITY STATUS AS OF 12/31/11";
label variable PSTATS31 "PERSON DISPOSITION STATUS - R3/1";
label variable PSTATS42 "PERSON DISPOSITION STATUS - R4/2";
label variable PSTATS53 "PERSON DISPOSITION STATUS - R5/3";
label variable RURSLT31 "RU RESULT - R3/1";
label variable RURSLT42 "RU RESULT - R4/2";
label variable RURSLT53 "RU RESULT - R5/3";
label variable AGE31X "AGE - R3/1 (EDITED/IMPUTED)";
label variable AGE42X "AGE - R4/2 (EDITED/IMPUTED)";
label variable AGE53X "AGE - R5/3 (EDITED/IMPUTED)";
label variable AGE11X "AGE AS OF 12/31/11 (EDITED/IMPUTED)";
label variable AGELAST "PERSON S AGE LAST TIME ELIGIBLE";
label variable DOBMM "DATE OF BIRTH: MONTH";
label variable DOBYY "DATE OF BIRTH: YEAR";
label variable SEX "SEX";
label variable RACEX "RACE (EDITED/IMPUTED)";
label variable RACEAX "ASIAN AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEBX "BLACK AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEWX "WHITE AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACETHNX "RACE/ETHNICITY (EDITED/IMPUTED)";
label variable HISPANX "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable HISPCAT "SPECIFIC HISPANIC ETHNICITY GROUP";
label variable MARRY31X "MARITAL STATUS - R3/1 (EDITED/IMPUTED)";
label variable MARRY42X "MARITAL STATUS - R4/2 (EDITED/IMPUTED)";
label variable MARRY53X "MARITAL STATUS - R5/3 (EDITED/IMPUTED)";
label variable MARRY11X "MARITAL STATUS-12/31/11 (EDITED/IMPUTED)";
label variable SPOUID31 "SPOUSE ID - R3/1";
label variable SPOUID42 "SPOUSE ID - R4/2";
label variable SPOUID53 "SPOUSE ID - R5/3";
label variable SPOUID11 "SPOUSE ID - 12/31/11";
label variable SPOUIN31 "MARITAL STATUS W/SPOUSE PRESENT-R3/1";
label variable SPOUIN42 "MARITAL STATUS W/SPOUSE PRESENT-R4/2";
label variable SPOUIN53 "MARITAL STATUS W/SPOUSE PRESENT-R5/3";
label variable SPOUIN11 "MARITAL STATUS W/SPOUSE PRESENT-12/31/11";
label variable EDUCYR "YEARS OF EDUC WHEN FIRST ENTERED MEPS";
label variable EDUYRDEG "YEAR OF EDUCATION OR HIGHEST DEGREE";
label variable HIDEG "HIGHEST DEGREE WHEN FIRST ENTERED MEPS";
label variable EDRECODE "EDUCATION RECODE";
label variable FTSTU31X "STUDENT STATUS IF AGES 17-23 - R3/1";
label variable FTSTU42X "STUDENT STATUS IF AGES 17-23 - R4/2";
label variable FTSTU53X "STUDENT STATUS IF AGES 17-23 - R5/3";
label variable FTSTU11X "STUDENT STATUS IF AGES 17-23 - 12/31/11";
label variable ACTDTY31 "MILITARY FULL-TIME ACTIVE DUTY - R3/1";
label variable ACTDTY42 "MILITARY FULL-TIME ACTIVE DUTY - R4/2";
label variable ACTDTY53 "MILITARY FULL-TIME ACTIVE DUTY - R5/3";
label variable HONRDC31 "HONORABLY DISCHARGED FROM MILITARY";
label variable HONRDC42 "HONORABLY DISCHARGED FROM MILITARY";
label variable HONRDC53 "HONORABLY DISCHARGED FROM MILITARY";
label variable RFREL31X "RELATION TO REF PERS-R3/1 (EDIT/IMP)";
label variable RFREL42X "RELATION TO REF PERS-R4/2 (EDIT/IMP)";
label variable RFREL53X "RELATION TO REF PERS-R5/3 (EDIT/IMP)";
label variable RFREL11X "RELATION TO REF PERS-12/31/11 (EDIT/IMP)";
label variable MOPID31X "PID OF PERSON S MOM - RD 3/1";
label variable MOPID42X "PID OF PERSON S MOM - RD 4/2";
label variable MOPID53X "PID OF PERSON S MOM - RD 5/3";
label variable DAPID31X "PID OF PERSON S DAD - RD 3/1";
label variable DAPID42X "PID OF PERSON S DAD - RD 4/2";
label variable DAPID53X "PID OF PERSON S DAD - RD 5/3";
label variable RTHLTH31 "PERCEIVED HEALTH STATUS - RD 3/1";
label variable RTHLTH42 "PERCEIVED HEALTH STATUS - RD 4/2";
label variable RTHLTH53 "PERCEIVED HEALTH STATUS - RD 5/3";
label variable MNHLTH31 "PERCEIVED MENTAL HEALTH STATUS - RD 3/1";
label variable MNHLTH42 "PERCEIVED MENTAL HEALTH STATUS - RD 4/2";
label variable MNHLTH53 "PERCEIVED MENTAL HEALTH STATUS - RD 5/3";
label variable HIBPDX "HIGH BLOOD PRESSURE DIAG (>17)";
label variable HIBPAGED "AGE OF DIAGNOSIS-HIGH BLOOD PRESSURE";
label variable BPMLDX "MULT DIAG HIGH BLOOD PRESS (>17)";
label variable CHDDX "CORONARY HRT DISEASE DIAG (>17)";
label variable CHDAGED "AGE OF DIAGNOSIS-CORONARY HEART DISEASE";
label variable ANGIDX "ANGINA DIAGNOSIS (>17)";
label variable ANGIAGED "AGE OF DIAGNOSIS-ANGINA";
label variable MIDX "HEART ATTACK (MI) DIAG (>17)";
label variable MIAGED "AGE OF DIAGNOSIS-HEART ATTACK(MI)";
label variable OHRTDX "OTHER HEART DISEASE DIAG (>17)";
label variable OHRTAGED "AGE OF DIAGNOSIS-OTHER HEART DISEASE";
label variable STRKDX "STROKE DIAGNOSIS (>17)";
label variable STRKAGED "AGE OF DIAGNOSIS-STROKE";
label variable EMPHDX "EMPHYSEMA DIAGNOSIS (>17)";
label variable EMPHAGED "AGE OF DIAGNOSIS-EMPHYSEMA";
label variable CHBRON31 "CHRONC BRONCHITS LAST 12 MTHS (>17)-R3/1";
label variable CHBRON53 "CHRONC BRONCHITS LAST 12 MTHS (>17)-R5/3";
label variable CHOLDX "HIGH CHOLESTEROL DIAGNOSIS (>17)";
label variable CHOLAGED "AGE OF DIAGNOSIS-HIGH CHOLESTEROL";
label variable CANCERDX "CANCER DIAGNOSIS (>17)";
label variable CABLADDR "CANCER DIAGNOSED - BLADDER (>17)";
label variable BLDRAGED "AGE OF DIAGNOSIS-BLADDER CANCER";
label variable BLDRREMS "BLADDER CANCER IN REMISSION";
label variable CABLOOD "CANCER DIAGNOSED - BLOOD (>17)";
label variable BLODAGED "AGE OF DIAGNOSIS-BLOOD CANCER";
label variable BLODREMS "BLOOD CANCER IN REMISSION";
label variable CABONE "CANCER DIAGNOSED - BONE (>17)";
label variable BONEAGED "AGE OF DIAGNOSIS-BONE CANCER";
label variable BONEREMS "BONE CANCER IN REMISSION";
label variable CABRAIN "CANCER DIAGNOSED - BRAIN (>17)";
label variable BRAIAGED "AGE OF DIAGNOSIS-BRAIN CANCER";
label variable BRAIREMS "BRAIN CANCER IN REMISSION";
label variable CABREAST "CANCER DIAGNOSED - BREAST (>17)";
label variable BRSTAGED "AGE OF DIAGNOSIS-BREAST CANCER";
label variable BRSTREMS "BREAST CANCER IN REMISSION";
label variable CACERVIX "CANCER DIAGNOSED - CERVIX (>17)";
label variable CERVAGED "AGE OF DIAGNOSIS-CERVICAL CANCER";
label variable CERVREMS "CERVICAL CANCER IN REMISSION";
label variable CACOLON "CANCER DIAGNOSED - COLON (>17)";
label variable COLOAGED "AGE OF DIAGNOSIS-COLON CANCER";
label variable COLOREMS "COLON CANCER IN REMISSION";
label variable CAESOPH "CANCER DIAGNOSED - ESOPHAGUS (>17)";
label variable ESPHAGED "AGE OF DIAGNOSIS-ESOPHAGEAL CANCER";
label variable ESPHREMS "ESOPHAGEAL CANCER IN REMISSION";
label variable CAKIDNEY "CANCER DIAGNOSED - KIDNEY (>17)";
label variable KIDNAGED "AGE OF DIAGNOSIS-RENAL CANCER";
label variable KIDNREMS "RENAL CANCER IN REMISSION";
label variable CALARYNX "CANCER DIAGNOSED - LARYNX (>17)";
label variable LRNXAGED "AGE OF DIAGNOSIS-LARYNGEAL CANCER";
label variable LRNXREMS "LARYNGEAL CANCER IN REMISSION";
label variable CALEUKEM "CANCER DIAGNOSED - LEUKEMIA (>17)";
label variable LEUKAGED "AGE OF DIAGNOSIS-LEUKEMIA";
label variable LEUKREMS "LEUKEMIA IN REMISSION";
label variable CALIVER "CANCER DIAGNOSED - LIVER (>17)";
label variable LIVRAGED "AGE OF DIAGNOSIS-LIVER CANCER";
label variable LIVRREMS "LIVER CANCER IN REMISSION";
label variable CALUNG "CANCER DIAGNOSED - LUNG (>17)";
label variable LUNGAGED "AGE OF DIAGNOSIS-LUNG CANCER";
label variable LUNGREMS "LUNG CANCER IN REMISSION";
label variable CALYMPH "CANCER DIAGNOSED - LYMPHOMA (>17)";
label variable LYMPAGED "AGE OF DIAGNOSIS-LYMPHOMA";
label variable LYMPREMS "LYMPHOMA IN REMISSION";
label variable CAMELANO "CANCER DIAGNOSED - MELANOMA (>17)";
label variable MELAAGED "AGE OF DIAGNOSIS-MELANOMA";
label variable MELAREMS "MELANOMA IN REMISSION";
label variable CAMOUTH "CANCER DIAGNOSED - MOUTH/LIP/TONGE (>17)";
label variable MOUTAGED "AGE OF DIAGNOSIS-MOUTH/LIP/TONGUE CANCER";
label variable MOUTREMS "MOUTH/TONGUE/LIP CANCER IN REMISSION";
label variable CAMUSCLE "CANCER DIAGNSD - SOFTTISS/MUSC/FAT (>17)";
label variable MUSCAGED "AGE OF DIAGNOSIS-SFTTISS/MUSC/FAT CANCER";
label variable MUSCREMS "SFT TISS/MUSC/FAT CANCER IN REMISSION";
label variable CAOTHER "CANCER DIAGNOSED - OTHER (>17)";
label variable OTHRAGED "AGE OF DIAGNOSIS-OTHER CANCER";
label variable OTHRREMS "OTHER CANCER IN REMISSION";
label variable CAOVARY "CANCER DIAGNOSED - OVARY (>17)";
label variable OVRYAGED "AGE OF DIAGNOSIS-OVARIAN CANCER";
label variable OVRYREMS "OVARIAN CANCER IN REMISSION";
label variable CAPANCRS "CANCER DIAGNOSED - PANCREAS (>17)";
label variable PANCAGED "AGE OF DIAGNOSIS-PANCREATIC CANCER";
label variable PANCREMS "PANCREATIC CANCER IN REMISSION";
label variable CAPROSTA "CANCER DIAGNOSED - PROSTATE (>17)";
label variable PRSTAGED "AGE OF DIAGNOSIS-PROSTATE CANCER";
label variable PRSTREMS "PROSTATE CANCER IN REMISSION";
label variable CARECTUM "CANCER DIAGNOSED - RECTUM (>17)";
label variable RECTAGED "AGE OF DIAGNOSIS-RECTAL CANCER";
label variable RECTREMS "RECTAL CANCER IN REMISSION";
label variable CASKINNM "CANCER DIAGNOSED - SKIN-NONMELANO (>17)";
label variable SKNMAGED "AGE OF DIAGNOSIS-SKIN-NONMELANOMA CANCER";
label variable SKNMREMS "SKIN-NONMELANOMA CANCER IN REMISSION";
label variable CASKINDK "CANCER DIAGNOSED-SKIN-UNKNOWN TYPE (>17)";
label variable SKDKAGED "AGE OF DIAGNOSIS-SKIN-UNKNWN TYPE CANCER";
label variable SKDKREMS "SKIN-UNKNOWN TYPE CANCER IN REMISSION";
label variable CASTOMCH "CANCER DIAGNOSED - STOMACH (>17)";
label variable STOMAGED "AGE OF DIAGNOSIS-STOMACH CANCER";
label variable STOMREMS "STOMACH CANCER IN REMISSION";
label variable CATESTIS "CANCER DIAGNOSED - TESTIS (>17)";
label variable TSTSAGED "AGE OF DIAGNOSIS-TESTICULAR CANCER";
label variable TSTSREMS "TESTICULAR CANCER IN REMISSION";
label variable CATHROAT "CANCER DIAGNOSED - THROAT (>17)";
label variable THRTAGED "AGE OF DIAGNOSIS-THROAT CANCER";
label variable THRTREMS "THROAT CANCER IN REMISSION";
label variable CATHYROD "CANCER DIAGNOSED - THYROID (>17)";
label variable THYRAGED "AGE OF DIAGNOSIS-THYROID CANCER";
label variable THYRREMS "THYROID CANCER IN REMISSION";
label variable CAUTERUS "CANCER DIAGNOSED - UTERUS (>17)";
label variable UTERAGED "AGE OF DIAGNOSIS-UTERINE CANCER";
label variable UTERREMS "UTERINE CANCER IN REMISSION";
label variable DIABDX "DIABETES DIAGNOSIS (>17)";
label variable DIABAGED "AGE OF DIAGNOSIS-DIABETES";
label variable JTPAIN31 "JOINT PAIN LAST 12 MONTHS (>17) - RD 3/1";
label variable JTPAIN53 "JOINT PAIN LAST 12 MONTHS (>17) - RD 5/3";
label variable ARTHDX "ARTHRITIS DIAGNOSIS (>17)";
label variable ARTHTYPE "TYPE OF ARTHRITIS DIAGNOSED (>17)";
label variable ARTHAGED "AGE OF DIAGNOSIS-ARTHRITIS";
label variable ASTHDX "ASTHMA DIAGNOSIS";
label variable ASTHAGED "AGE OF DIAGNOSIS-ASTHMA";
label variable ASSTIL31 "DOES PERSON STILL HAVE ASTHMA-RD3/1";
label variable ASSTIL53 "DOES PERSON STILL HAVE ASTHMA - RD 5/3";
label variable ASATAK31 "ASTHMA ATTACK LAST 12 MOS - RD3/1";
label variable ASATAK53 "ASTHMA ATTACK LAST 12 MOS - RD 5/3";
label variable ASTHEP31 "WHEN WAS LAST EPISODE OF ASTHMA - RD 3/1";
label variable ASTHEP53 "WHEN WAS LAST EPISODE OF ASTHMA - RD 5/3";
label variable ASACUT53 "USED ACUTE PRES INHALER LAST 3 MOS-RD5/3";
label variable ASMRCN53 "USED>3ACUTE CN PRES INH LAST 3 MOS-RD5/3";
label variable ASPREV53 "EVER USED PREV DAILY ASTHMA MEDS -RD 5/3";
label variable ASDALY53 "NOW TAKE PREV DAILY ASTHMA MEDS - RD 5/3";
label variable ASPKFL53 "HAVE PEAK FLOW METER AT HOME - RD 5/3";
label variable ASEVFL53 "EVER USED PEAK FLOW METER - RD 5/3";
label variable ASWNFL53 "WHEN LAST USED PEAK FLOW METER - RD 5/3";
label variable ADHDADDX "ADHDADD DIAGNOSIS (5-17)";
label variable ADHDAGED "AGE OF DIAGNOSIS-ADHD/ADD";
label variable PREGNT31 "PREGNANT DURING REF PERIOD - RD 3/1";
label variable PREGNT42 "PREGNANT DURING REF PERIOD - RD 4/2";
label variable PREGNT53 "PREGNANT DURING REF PERIOD - RD 5/3";
label variable IADLHP31 "IADL SCREENER - RD 3/1";
label variable IADLHP42 "IADL SCREENER - RD 4/2";
label variable IADLHP53 "IADL SCREENER - RD 5/3";
label variable IADL3M31 "IADL HELP 3+ MONTHS - RD 3/1";
label variable IADL3M42 "IADL HELP 3+ MONTHS - RD 4/2";
label variable IADL3M53 "IADL HELP 3+ MONTHS - RD 5/3";
label variable ADLHLP31 "ADL SCREENER - RD 3/1";
label variable ADLHLP42 "ADL SCREENER - RD 4/2";
label variable ADLHLP53 "ADL SCREENER - RD 5/3";
label variable ADL3MO31 "ADL HELP 3+ MONTHS - RD 3/1";
label variable ADL3MO42 "ADL HELP 3+ MONTHS - RD 4/2";
label variable ADL3MO53 "ADL HELP 3+ MONTHS - RD 5/3";
label variable AIDHLP31 "USED ASSISTIVE DEVICES - RD 3/1";
label variable AIDHLP53 "USED ASSISTIVE DEVICES - RD 5/3";
label variable WLKLIM31 "LIMITATION IN PHYSICAL FUNCTIONING-RD3/1";
label variable WLKLIM53 "LIMITATION IN PHYSICAL FUNCTIONING-RD5/3";
label variable LFTDIF31 "DIFFICULTY LIFTING 10 POUNDS - RD 3/1";
label variable LFTDIF53 "DIFFICULTY LIFTING 10 POUNDS - RD 5/3";
label variable STPDIF31 "DIFFICULTY WALKING UP 10 STEPS - RD 3/1";
label variable STPDIF53 "DIFFICULTY WALKING UP 10 STEPS - RD 5/3";
label variable WLKDIF31 "DIFFICULTY WALKING 3 BLOCKS - RD 3/1";
label variable WLKDIF53 "DIFFICULTY WALKING 3 BLOCKS - RD 5/3";
label variable MILDIF31 "DIFFICULTY WALKING A MILE - RD 3/1";
label variable MILDIF53 "DIFFICULTY WALKING A MILE - RD 5/3";
label variable STNDIF31 "DIFFICULTY STANDING 20 MINUTES - RD 3/1";
label variable STNDIF53 "DIFFICULTY STANDING 20 MINUTES - RD 5/3";
label variable BENDIF31 "DIFFICULTY BENDING/STOOPING - RD 3/1";
label variable BENDIF53 "DIFFICULTY BENDING/STOOPING - RD 5/3";
label variable RCHDIF31 "DIFFICULTY REACHING OVERHEAD - RD 3/1";
label variable RCHDIF53 "DIFFICULTY REACHING OVERHEAD - RD 5/3";
label variable FNGRDF31 "DIFFICULTY USING FINGERS TO GRASP-RD 3/1";
label variable FNGRDF53 "DIFFICULTY USING FINGERS TO GRASP-RD 5/3";
label variable WLK3MO31 "PHYS FUNCTIONING HELP 3+ MONTHS - RD 3/1";
label variable WLK3MO53 "PHYS FUNCTIONING HELP 3+ MONTHS - RD 5/3";
label variable ACTLIM31 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 3/1";
label variable ACTLIM53 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 5/3";
label variable WRKLIM31 "WORK LIMITATION - RD 3/1";
label variable WRKLIM53 "WORK LIMITATION - RD 5/3";
label variable HSELIM31 "HOUSEWORK LIMITATION - RD 3/1";
label variable HSELIM53 "HOUSEWORK LIMITATION - RD 5/3";
label variable SCHLIM31 "SCHOOL LIMITATION - RD 3/1";
label variable SCHLIM53 "SCHOOL LIMITATION - RD 5/3";
label variable UNABLE31 "COMPLETELY UNABLE TO DO ACTIVITY-RD 3/1";
label variable UNABLE53 "COMPLETELY UNABLE TO DO ACTIVITY-RD 5/3";
label variable SOCLIM31 "SOCIAL LIMITATIONS - RD 3/1";
label variable SOCLIM53 "SOCIAL LIMITATIONS - RD 5/3";
label variable COGLIM31 "COGNITIVE LIMITATIONS - RD 3/1";
label variable COGLIM53 "COGNITIVE LIMITATIONS - RD 5/3";
label variable WRGLAS42 "WEARS EYEGLASSES OR CONTACTS - RD 4/2";
label variable SEEDIF42 "DIFFCLTY SEEING W/GLASSES/CNTCTS-RD 4/2";
label variable BLIND42 "PERSON IS BLIND - RD 4/2";
label variable READNW42 "CAN READ NEWSPRNT W/GLASSES/CNTCTS-RD4/2";
label variable RECPEP42 "CAN RECGNZE PEOPLE W/GLASSES/CNTCTS-R4/2";
label variable VISION42 "VISION IMPAIRMENT (SUMMARY) - RD 4/2";
label variable HEARAD42 "PERSON WEARS HEARING AID - RD 4/2";
label variable HEARDI42 "ANY DIFFCLTY HEARING W/HEARING AID-RD4/2";
label variable DEAF42 "PERSON IS DEAF - RD 4/2";
label variable HEARMO42 "CAN HEAR MOST CONVERSATION - RD 4/2";
label variable HEARSM42 "CAN HEAR SOME CONVERSATION - RD 4/2";
label variable HEARNG42 "HEARING IMPAIRMENT (SUMMARY) - RD 4/2";
label variable ANYLIM11 "ANY LIMITATION IN P15R3,4,5/P16R1,2,3";
label variable LSHLTH42 "LESS HEALTHY THAN OTHR CHILD (0-17)-R4/2";
label variable NEVILL42 "NEVER BEEN SERIOUSLY ILL (0-17)-R4/2";
label variable SICEAS42 "CHILD GETS SICK EASILY (0-17)-R4/2";
label variable HLTHLF42 "CHILD WILL HAVE HEALTHY LIFE (0-17)-R4/2";
label variable WRHLTH42 "WORRY MORE ABOUT HEALTH (0-17)-R4/2";
label variable CHPMED42 "CSHCN:CHILD NEEDS PRESCRB MED(0-17)-R4/2";
label variable CHPMHB42 "CSHCN:PMED FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHPMCN42 "CSHCN:PMED COND LAST 12+ MOS (0-17)-R4/2";
label variable CHSERV42 "CSHCN:CHLD NEEDS MED&OTH SERV(0-17)-R4/2";
label variable CHSRHB42 "CSHCN:SERV FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHSRCN42 "CSHCN:SERV COND LAST 12+ MOS (0-17)-R4/2";
label variable CHLIMI42 "CSHCN:LIMITED IN ANY WAY (0-17)-R4/2";
label variable CHLIHB42 "CSHCN:LIMT FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHLICO42 "CSHCN:LIMIT COND LAST 12+MOS (0-17)-R4/2";
label variable CHTHER42 "CSHCN:CHLD NEEDS SPEC THERAPY(0-17)-R4/2";
label variable CHTHHB42 "CSHCN:SPEC THER FOR HLTH+COND(0-17)-R4/2";
label variable CHTHCO42 "CSHCN:THER COND LAST 12+ MOS (0-17)-R4/2";
label variable CHCOUN42 "CSHCN:CHILD NEEDS COUNSELING (0-17)-R4/2";
label variable CHEMPB42 "CSHCN:COUNS PROB LAST 12+MOS (0-17)-R4/2";
label variable CSHCN42 "CSHCN:CHILD W/SPEC HC NEEDS (0-17)-R4/2";
label variable MOMPRO42 "PROBLEM GETTING ALONG W/MOM (5-17)-R4/2";
label variable DADPRO42 "PROBLEM GETTING ALONG W/DAD (5-17)-R4/2";
label variable UNHAP42 "PROBLEM FEELING UNHAPPY/SAD (5-17)-R4/2";
label variable SCHLBH42 "PROBLEM BEHAVIOR AT SCHOOL (5-17)-R4/2";
label variable HAVFUN42 "PROBLEM HAVING FUN (5-17) - R4/2";
label variable ADUPRO42 "PRBLM GETTING ALONG W/ADULTS (5-17)-R4/2";
label variable NERVAF42 "PRBLM FEELING NERVOUS/AFRAID (5-17)-R4/2";
label variable SIBPRO42 "PRBLM GETTING ALONG W/SIBS (5-17)-R4/2";
label variable KIDPRO42 "PRBLM GETTING ALONG W/KIDS (5-17)-R4/2";
label variable SPRPRO42 "PROBLEM W/SPORTS/HOBBIES (5-17)-R4/2";
label variable SCHPRO42 "PROBLEM WITH SCHOOLWORK (5-17)-R4/2";
label variable HOMEBH42 "PROBLEM W/BEHAVIOR AT HOME (5-17)-R4/2";
label variable TRBLE42 "PRBLM STAY OUT OF TROUBLE (5-17)-R4/2";
label variable CHILCR42 "CAHPS:12MOS:ILL/INJ NEED CARE(0-17)-R4/2";
label variable CHILWW42 "CAHPS:12MOS:ILL CARE WHN WNTD(0-17)-R4/2";
label variable CHRTCR42 "CAHPS:12MOS:MAKE ROUT CARE APT(0-17)R4/2";
label variable CHRTWW42 "CAHPS:12MOS:ROUT APT WHN WNTD(0-17)-R4/2";
label variable CHAPPT42 "CAHPS:12MOS:# OF OFF/CLIN APTS(0-17)R4/2";
label variable CHNDCR42 "CAHPS:12MOS:NEED ANY CARE/TRT(0-17)-R4/2";
label variable CHENEC42 "CAHPS:12MOS:EASY GET NEC CARE (0-17)R4/2";
label variable CHLIST42 "CAHPS:12MOS:CHLD DR LSN TO YOU(0-17)R4/2";
label variable CHEXPL42 "CAHPS:12MOS:CHLD DR EXPL THNG(0-17)R4/2";
label variable CHRESP42 "CAHPS:12MOS:CHLD S DR SHW RESP(0-17)R4/2";
label variable CHPRTM42 "CAHPS:12MOS:CHILD DR ENGH TIME(0-17)R4/2";
label variable CHHECR42 "CAHPS:12MOS:RATE CHLD HLT CARE(0-17)R4/2";
label variable CHSPEC42 "CAHPS:12MOS:CHLD NEEDED SPEC(0-17)R4/2";
label variable CHEYRE42 "CAHPS:12MOS:ESY W/RFR TO SPEC(0-17)-R4/2";
label variable MESHGT42 "DOCTOR EVER MEASURED HEIGHT (0-17)-R4/2";
label variable WHNHGT42 "WHEN DOCTOR MEASURED HEIGHT (0-17)-R4/2";
label variable MESWGT42 "DOCTOR EVER MEASURED WEIGHT (0-17)-R4/2";
label variable WHNWGT42 "WHEN DOCTOR MEASURED WEIGHT (0-17)-R4/2";
label variable CHBMIX42 "CHILD S BODY MASS INDEX (6-17)-R4/2";
label variable MESVIS42 "DOCTOR CHECKED CHILD S VISION (3-6)-R4/2";
label variable MESBPR42 "DR CHECKED BLOOD PRESSURE (2-17)-R4/2";
label variable WHNBPR42 "WHEN DR CHECKED BLOOD PRESS (2-17)-R4/2";
label variable DENTAL42 "DR ADVISE REG DENTAL CHECKUP (2-17)-R4/2";
label variable WHNDEN42 "WHEN DR ADVISE DENT CHECKUP (2-17)-R4/2";
label variable EATHLT42 "DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable WHNEAT42 "WHEN DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable PHYSCL42 "DR ADVISE EXERCISE (2-17)-R4/2";
label variable WHNPHY42 "WHEN DR ADVISE EXERCISE (2-17)-R4/2";
label variable SAFEST42 "DR ADVISE CHLD SAFETY SEAT (WT<=40)-R4/2";
label variable WHNSAF42 "WHEN DR ADVISE SAFETY SEAT (WT<=40)-R4/2";
label variable BOOST42 "DR ADVISE BOOSTER SEAT (40<WT<=80)-R4/2";
label variable WHNBST42 "WHN DR ADVISE BOOST SEAT(40<WT<=80)-R4/2";
label variable LAPBLT42 "DR ADVISE LAP/SHOULDER BELT (80<WT)-R4/2";
label variable WHNLAP42 "WHN DR ADVISE LAP/SHLDR BLT (80<WT)-R4/2";
label variable HELMET42 "DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable WHNHEL42 "WHEN DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable NOSMOK42 "DR ADVISE SMKG IN HOME IS BAD(0-17)-R4/2";
label variable WHNSMK42 "WHN DR ADVIS SMKG IN HOME BAD(0-17)-R4/2";
label variable TIMALN42 "DOCTOR SPEND ANY TIME ALONE (12-17)-R4/2";
label variable DENTCK53 "HOW OFTEN DENTAL CHECK-UP - RD 5/3";
label variable BPCHEK53 "TIME SNCE LST BLOOD PRES CHK (>17)-RD5/3";
label variable BPMONT53 "# MOS SNCE LST BLOOD PRES CHK (>17)-R5/3";
label variable CHOLCK53 "HOW LNG CHOLEST LST CHCK (>17) - RD 5/3";
label variable CHECK53 "HOW LNG LST ROUTNE CHECKUP (>17)-RD 5/3";
label variable NOFAT53 "RESTRICT HGH FAT/CHOLES FOOD (>17)-RD5/3";
label variable EXRCIS53 "ADVISED TO EXERCISE MORE (>17) - RD 5/3";
label variable FLUSHT53 "HOW LNG LAST FLU VACINATION (>17)-RD 5/3";
label variable ASPRIN53 "TKE ASPIRN EVERY (OTHR) DAY (>17)-RD 5/3";
label variable NOASPR53 "TAKING ASPIRIN UNSAFE (>17) - RD 5/3";
label variable STOMCH53 "TKE ASPRN UNSAFE B/C STOMCH (>17)-RD 5/3";
label variable LSTETH53 "LOST ALL UPPR AND LOWR TEETH (>17)-RD5/3";
label variable PSA53 "HOW LONG SINCE LAST PSA (>39) - RD 5/3";
label variable HYSTER53 "HAD A HYSTERECTOMY (>17) - RD 5/3";
label variable PAPSMR53 "HOW LNG LST PAP SMEAR TST (>17) - RD 5/3";
label variable BRSTEX53 "HOW LNG SNCE LST BREAST EXAM (>17)-RD5/3";
label variable MAMOGR53 "HOW LNG SNCE LST MAMMOGRAM (>29) - RD5/3";
label variable BSTST53 "MST RCNT BLD STOOL TST HME KIT(>39)-R5/3";
label variable BSTSRE53 "RSN HAVE BLD STOOL TST (>39)-R5/3";
label variable CLNTST53 "MOST RECENT COLONOSCOPY (>39) - R5/3";
label variable CLNTRE53 "RSN HAVE COLONOSCOPY (>39)-R5/3";
label variable SGMTST53 "MOST RECENT SIGMOIDOSCOPY (>39) - R5/3";
label variable SGMTRE53 "RSN HAVE SIGMOIDOSCOPY (>39)-R5/3";
label variable PHYEXE53 "MOD/VIG PHYS EXEC 5X WK (>17) - RD 5/3";
label variable BMINDX53 "ADULT BODY MASS INDEX (>17) - RD 5/3";
label variable SEATBE53 "WEARS SEAT BELT (>15) - RD 5/3";
label variable SAQELIG "ELIGIBILITY STATUS FOR SAQ";
label variable ADPRX42 "SAQ: RELATIONSHIP OF PROXY TO ADULT";
label variable ADILCR42 "SAQ 12MOS: ILL/INJURY NEEDING IMMED CARE";
label variable ADILWW42 "SAQ 12 MOS: GOT CARE WHEN NEEDED ILL/INJ";
label variable ADRTCR42 "SAQ 12 MOS: MADE APPT ROUTINE MED CARE";
label variable ADRTWW42 "SAQ 12 MOS: GOT MED APPT WHEN WANTED";
label variable ADAPPT42 "SAQ 12 MOS: # VISITS TO MED OFF FOR CARE";
label variable ADNDCR42 "SAQ 12MOS: NEED ANY CARE, TEST, TREATMNT";
label variable ADEGMC42 "SAQ 12MOS: EASY GETTING NEEDED MED CARE";
label variable ADLIST42 "SAQ 12 MOS: DOCTOR LISTENED TO YOU";
label variable ADEXPL42 "SAQ 12 MOS: DOC EXPLAINED SO UNDERSTOOD";
label variable ADRESP42 "SAQ 12 MOS: DR SHOWED RESPECT";
label variable ADPRTM42 "SAQ 12 MOS: DR SPENT ENUF TIME WITH YOU";
label variable ADINST42 "SAQ 12 MOS: DR GAVE SPCIFC INSTRCTNS";
label variable ADEZUN42 "SAQ 12 MOS: DR GIVEN INSTR. EZ UNDRSTD";
label variable ADTLHW42 "SAQ 12 MOS: DR ASKED R DESC HOW FOLLOW";
label variable ADFFRM42 "SAQ 12 MOS: HAD TO FILL OUT/SIGN FORMS";
label variable ADFHLP42 "SAQ 12 MOS: OFFRD HELP FILLING OUT FORMS";
label variable ADHECR42 "SAQ 12 MOS: RATING OF HEALTH CARE";
label variable ADSMOK42 "SAQ: CURRENTLY SMOKE";
label variable ADNSMK42 "SAQ 12MOS: DR ADVISED TO QUIT SMOKING";
label variable ADDRBP42 "SAQ 2 YRS: DR CHECKED BLOOD PRESSURE";
label variable ADSPEC42 "SAQ 12 MOS: NEEDED TO SEE SPECIALIST";
label variable ADSPRF42 "SAQ 12MOS: HOW ESY GETTING SPEC REFERRAL";
label variable ADGENH42 "SAQ: HEALTH IN GENERAL SF-12V2";
label variable ADDAYA42 "SAQ: HLTH LIMITS MOD ACTIVITIES SF-12V2";
label variable ADCLIM42 "SAQ: HLTH LIMITS CLIMBING STAIRS SF-12V2";
label variable ADPALS42 "SAQ 4WKS:ACCMP LESS B/C PHY PRBS SF-12V2";
label variable ADPWLM42 "SAQ 4WKS:WORK LIMT B/C PHY PROBS SF-12V2";
label variable ADMALS42 "SAQ 4WKS:ACCMP LESS B/C MNT PRBS SF-12V2";
label variable ADMWLM42 "SAQ 4WKS:WORK LIMT B/C MNT PROBS SF-12V2";
label variable ADPAIN42 "SAQ 4WKS:PAIN LIMITS NORMAL WORK SF-12V2";
label variable ADCAPE42 "SAQ 4WKS: FELT CALM/PEACEFUL SF-12V2";
label variable ADNRGY42 "SAQ 4WKS: HAD A LOT OF ENERGY SF-12V2";
label variable ADDOWN42 "SAQ 4WKS: FELT DOWNHEARTED/DEPR SF-12V2";
label variable ADSOCA42 "SAQ 4WKS: HLTH STOPPED SOC ACTIV SF-12V2";
label variable PCS42 "SAQ:PHY COMPONENT SUMMRY SF-12V2 IMPUTED";
label variable MCS42 "SAQ:MNT COMPONENT SUMMRY SF-12V2 IMPUTED";
label variable SFFLAG42 "SAQ: PCS/MCS IMPUTATION FLAG SF-12V2";
label variable ADNERV42 "SAQ 30 DAYS: HOW OFTEN FELT NERVOUS";
label variable ADHOPE42 "SAQ 30 DAYS: HOW OFTEN FELT HOPELESS";
label variable ADREST42 "SAQ 30 DAYS: HOW OFTEN FELT RESTLESS";
label variable ADSAD42 "SAQ 30 DAYS: HOW OFTEN FELT SAD";
label variable ADEFRT42 "SAQ 30 DAYS: HOW OFTN EVRYTHNG AN EFFORT";
label variable ADWRTH42 "SAQ 30 DAYS: HOW OFTEN FELT WORTHLESS";
label variable K6SUM42 "SAQ 30 DAYS: OVERALL RATING OF FEELINGS";
label variable ADINTR42 "SAQ 2 WKS: LITTLE INTEREST IN THINGS";
label variable ADDPRS42 "SAQ 2 WKS: FELT DOWN/DEPRESSED/HOPELESS";
label variable PHQ242 "SAQ 2 WKS: OVERALL RATING OF FEELINGS";
label variable ADINSA42 "SAQ: DO NOT NEED HEALTH INSURANCE";
label variable ADINSB42 "SAQ: HEALTH INSURANCE NOT WORTH COST";
label variable ADRISK42 "SAQ: MORE LIKELY TO TAKE RISKS";
label variable ADOVER42 "SAQ: CAN OVERCOME ILLS WITHOUT MED HELP";
label variable ADCMPM42 "SAQ: DATE COMPLETED - MONTH";
label variable ADCMPD42 "SAQ: DATE COMPLETED - DAY";
label variable ADCMPY42 "SAQ: DATE COMPLETED - YEAR";
label variable ADLANG42 "SAQ: LANGUAGE OF SAQ INTERVIEW";
label variable DSDIA53 "DCS: DIABETES DIAGNOSIS BY HEALTH PROF";
label variable DSA1C53 "DCS: TIMES TESTED FOR A-ONE-C IN 2011";
label variable DSFT1253 "DCS: HAD FEET CHECKED DURING 2012";
label variable DSFT1153 "DCS: HAD FEET CHECKED DURING 2011";
label variable DSFT1053 "DCS: HAD FEET CHECKED DURING 2010";
label variable DSFB1053 "DCS: HAD FEET CHECKED BEFORE 2010";
label variable DSFTNV53 "DCS: NEVER HAD FEET CHECKED";
label variable DSEY1253 "DCS: DILATED EYE EXAM IN 2012";
label variable DSEY1153 "DCS: DILATED EYE EXAM IN 2011";
label variable DSEY1053 "DCS: DILATED EYE EXAM IN 2010";
label variable DSEB1053 "DCS: DILATED EYE EXAM BEFORE 2010";
label variable DSEYNV53 "DCS: NEVER HAD DILATED EYE EXAM";
label variable DSCH1253 "DCS: BLOOD CHOLESTEROL CHECKED IN 2012";
label variable DSCH1153 "DCS: BLOOD CHOLESTEROL CHECKED IN 2011";
label variable DSCH1053 "DCS: BLOOD CHOLESTEROL CHECKED IN 2010";
label variable DSCB1053 "DCS: BLOOD CHOLESTEROL CHECKED BEF 2010";
label variable DSCHNV53 "DCS: NEVER HAD BLOOD CHOLESTEROL CHECKED";
label variable DSFL1253 "DCS: GOT FLU VACCINATION IN 2012";
label variable DSFL1153 "DCS: GOT FLU VACCINATION IN 2011";
label variable DSFL1053 "DCS: GOT FLU VACCINATION IN 2010";
label variable DSVB1053 "DCS: GOT FLU VACCINATION BEFORE 2010";
label variable DSFLNV53 "DCS: NEVER GOT FLU VACCINATION";
label variable DSKIDN53 "DCS: HAS DIABETES CAUSED KIDNEY PROBLEMS";
label variable DSEYPR53 "DCS: HAS DIABETES CAUSED EYE PROBS";
label variable DSDIET53 "DCS: TREAT DIABETES W/DIET MODIFICATION";
label variable DSMED53 "DCS: TREAT DIABETES W/MEDS BY MOUTH";
label variable DSINSU53 "DCS: TREAT DIABETES W/INSULIN INJECTIONS";
label variable DSCPCP53 "DCS: LEARNED CARE FROM PRIMARY CARE PROV";
label variable DSCNPC53 "DCS: LEARNED CARE FROM OTHER PROVIDER";
label variable DSCPHN53 "DCS: LEARN CARE FROM PHONE CALL W/PROV";
label variable DSCINT53 "DCS: LEARNED CARE FROM READING INTERNET";
label variable DSCGRP53 "DCS: LEARNED CARE BY TAKING GROUP CLASS";
label variable DSCONF53 "DCS: CONFIDENT TAKING CARE OF DIABETES";
label variable DSPRX53 "DCS: WAS RESPONDENT A PROXY";
label variable CELIGI53 "CSAQ: ELIGIBILITY STATUS FOR CSAQ";
label variable CCNRDI53 "CSAQ: CANCER DIAGNOSIS BY HEALTH PROF";
label variable CDIAG53 "CSAQ: CANCER DIAGNOSIS BEFORE AGE 18";
label variable CTRTMT53 "CSAQ: CURRENTLY TREATED FOR CANCER";
label variable CFREE53 "CSAQ: FREE FROM CANCER";
label variable CLSTRT53 "CSAQ: LAST CANCER TREATMENT";
label variable CBCK53 "CSAQ: CANCER BACK TOLD BY HEALTH PROF";
label variable CBCKYR53 "CSAQ: YEAR TOLD CANCER BACK";
label variable CFTRT53 "CSAQ: FIRST TIME TREATED FOR CANCER";
label variable CWRKP53 "CSAQ: WORK FOR PAY SINCE DIAGNOSED";
label variable CTMOFF53 "CSAQ: TAKE TIME OFF SINCE DIAGNOSED";
label variable CTMSK53 "CSAQ: ASKED FOR EXTND TIM OFF SINCE DIAG";
label variable CWYASK53 "CSAQ: WHY ASK FOR WORK CHANGES";
label variable CWYCNG53 "CSAQ: WHY MAKE WORK CHANGES";
label variable CEXTM53 "CSAQ: TOOK EXTENDED PAID TIME OFF";
label variable CEXTDI53 "CSAQ: PAID TIME OFF AT DIAGNOSIS";
label variable CEXTRT53 "CSAQ: PAID TIME OFF DURING TREATMENT";
label variable CEXTLT53 "CSAQ: PAID TIME OFF < 1 YEAR AFT TRTMNT";
label variable CEXTMT53 "CSAQ: PAID TIME OFF >= 1 YEAR AFT TRTMNT";
label variable CEXTOT53 "CSAQ: TOTAL PAID TIME OFF";
label variable CEXTOG53 "CSAQ: PAID TIME OFF ONGOING";
label variable CNPTOF53 "CSAQ: TAKE UNPAID TIME OFF";
label variable CNPTDI53 "CSAQ: UNPAID TIME OFF AT DIAGNOSIS";
label variable CNPTRT53 "CSAQ: UNPAID TIME OFF DURING TREATMENT";
label variable CNPTLT53 "CSAQ: UNPAID TIM OFF < 1 YEAR AFT TRTMNT";
label variable CNPTMT53 "CSAQ: UNPAID TIM OFF >=1 YEAR AFT TRTMNT";
label variable CNPTOT53 "CSAQ: TOTAL UNPAID TIME OFF";
label variable CNPOG53 "CSAQ: UNPAID TIME OFF ONGOING";
label variable CCNGFT53 "CSAQ: PART-TIME TO FULL-TIME WORKING";
label variable CNGFDI53 "CSAQ: PRT-TIME TO FLL-TIME AT DIAGNOSIS";
label variable CNGFTR53 "CSAQ: PRT-TIME TO FLL-TIME DURING TRTMNT";
label variable CNGFLT53 "CSAQ: PRT-TIM TO FLL-TIM < 1 YR AFT TRT";
label variable CNGFMT53 "CSAQ: PRT-TIM TO FLL-TIM >=1 YR AFT TRT";
label variable CFTTOT53 "CSAQ: TOTAL FULL-TIME WORK";
label variable CNGFOG53 "CSAQ: FULL-TIME WORK ONGOING";
label variable CCNGPT53 "CSAQ: FULL-TIME TO PART-TIME WORK";
label variable CNGPDI53 "CSAQ: FLL-TIME TO PRT-TIME AT DIAGNOSIS";
label variable CNGPTR53 "CSAQ: FLL-TIME TO PRT-TIME DURING TRTMNT";
label variable CNGPLT53 "CSAQ: FLL-TIM TO PRT-TIM < 1 YR AFT TRT";
label variable CNGPMT53 "CSAQ: FLL-TIM TO PRT-TIM >=1 YR AFT TRT";
label variable CPTTOT53 "CSAQ: TOTAL PART-TIME WORK";
label variable CNGPOG53 "CSAQ: PART-TIME WORK ONGOING";
label variable CNGFLX53 "CSAQ: FLEXIBLE WORK SCHEDULE";
label variable CNGFXD53 "CSAQ: FLX WORK SCHEDULE AT DIAGNOSIS";
label variable CNGFXT53 "CSAQ: FLX WORK SCHEDULE DURING TREATMENT";
label variable CNGFXL53 "CSAQ: FLX WRK SCHEDULE < 1 YEAR AFT TRT";
label variable CNGFXM53 "CSAQ: FLX WRK SCHEDULE >= 1 YEAR AFT TRT";
label variable CNGLDJ53 "CSAQ: CHANGE TO LESS DEMANDING JOB (LDJ)";
label variable CNGLDD53 "CSAQ: CHANGE TO LDJ AT DIAGNOSIS";
label variable CNGLDT53 "CSAQ: CHANGE TO LDJ DURING TREATMENT";
label variable CNGLDL53 "CSAQ: CHANGE TO LDJ < 1 YEAR AFT TRTMNT";
label variable CNGLDM53 "CSAQ: CHANGE TO LDJ >= 1 YEAR AFT TRTMNT";
label variable CLDJOB53 "CSAQ: TOTAL TIME AT LDJ";
label variable CNGLOG53 "CSAQ: LDJ ONGOING";
label variable COTARR53 "CSAQ: OTHER ARRANGEMENTS";
label variable CPROM53 "CSAQ: DID NOT PURSUE PROMOTION";
label variable CERET53 "CSAQ: EARLY RETIREMENT";
label variable CDRET53 "CSAQ: DELAYED RETIREMENT";
label variable CPTASK53 "CSAQ: INTERFERE WITH PHYSICAL TASKS";
label variable CMTASK53 "CSAQ: INTERFERE WITH MENTAL TASKS";
label variable CLPROD53 "CSAQ: FEEL LESS PRODUCTIVE";
label variable CFRET53 "CSAQ: MIGHT BE FORCED TO RETIRE";
label variable CLHINS53 "CSAQ: STAY AT JOB - WORRY LOSE HLTH INS";
label variable CCLHIN53 "CSAQ: CONCERNED LOSING HLTH INS TO CNCR";
label variable CWRKEF53 "CSAQ: EFFECTS OF TREATMENT ON WORK";
label variable CSLHIN53 "CSAQ: FMEM STAY AT JOB - WORRY LOSE INS";
label variable CFMEM53 "CSAQ: FMEM PROVIDE CARE";
label variable CFMTOF53 "CSAQ: FMEM TAKE EXTENDED TIME OFF";
label variable CFM2MT53 "CSAQ: FMEM TAKE EXTND TIM OFF >= 2 MNTH";
label variable CFMEXT53 "CSAQ: FMEM TAKE EXTENDED PAID TIME OFF";
label variable CFMETM53 "CSAQ: ESTIMATED FMEM TAKE PAID TIME OFF";
label variable CFMPOG53 "CSAQ: FMEM EXTND PAID TIME OFF ONGOING";
label variable CFMNPT53 "CSAQ: FMEM TAKE UNPAID TIME OFF";
label variable CFMNTM53 "CSAQ: ESTIMATED UNPAID TIME OFF BY FMEM";
label variable CFMUOG53 "CSAQ: FMEM UNPAID TIME ONGOING";
label variable CFMPTF53 "CSAQ: FMEM CHANGE PART-TIME TO FULL-TIME";
label variable CFMFTM53 "CSAQ: ESTIMATED TIME FMEM WORK FULL-TIME";
label variable CFMFOG53 "CSAQ: FMEM FULL-TIME WORK ONGOING";
label variable CFMFTP53 "CSAQ: FMEM CHANGE FULL-TIME TO PART-TIME";
label variable CFMPTM53 "CSAQ: ESTIMATED FMEM WORK PART-TIME";
label variable CFMCOG53 "CSAQ: FMEM PART-TIME WORK ONGOING";
label variable CFMOTH53 "CSAQ: FMEM OTHER ARRANGEMENTS";
label variable CFMLDJ53 "CSAQ: FMEM CHANGE TO LESS DEMANDING JOB";
label variable CFMGRT53 "CSAQ: FMEM EARLY RETIREMENT";
label variable CFMDRT53 "CSAQ: FMEM DELAYED RETIREMENT";
label variable CINCOV53 "CSAQ: COVERED BY HEALTH INSURANCE";
label variable CINREF53 "CSAQ: HLTH INS REFUSED VISIT COVERAGE";
label variable CIN2OP53 "CSAQ: HLTH INS REFUSED 2ND OPINION";
label variable CINDND53 "CSAQ: HEALTH INSURANCE DENIED";
label variable CFNDBT53 "CSAQ: MONEY BORROWED OR IN DEBT";
label variable CFNAMT53 "CSAQ: AMOUNT OF BORROWED OR IN DEBT";
label variable CFNBNK53 "CSAQ: SELF OR FMEM FILE BANKRUPTCY";
label variable CFNSAC53 "CSAQ: FINANCIAL SACRIFICE";
label variable CFNPMT53 "CSAQ: WORRY PAY MEDICAL BILLS";
label variable CFNUNB53 "CSAQ: UNABLE TO COVER MEDICAL BILLS";
label variable CMCFUP53 "CSAQ: DISCUSS REGULAR FOLLOW-UP CARE";
label variable CMCEFF53 "CSAQ: DISCUSS SIDE EFFECTS";
label variable CMCPSY53 "CSAQ: DISCUSS EMO/SOC NEEDS";
label variable CMCSTY53 "CSAQ: DISCUSS LIFESTYLE OR HEALTH";
label variable CMCNEC53 "CSAQ: RECEIVED NECESSARY MEDICAL CARE";
label variable CMNAFF53 "CSAQ: COULD NOT AFFORD CARE";
label variable CMNINS53 "CSAQ: INS COMPANY DIDN T APPROVE OR PAY";
label variable CMNACC53 "CSAQ: DOCTOR DID NOT ACCEPT INSURANCE";
label variable CMNOFF53 "CSAQ: PROBLEMS GETTING TO DOCTOR OFFICE";
label variable CMNTIM53 "CSAQ: NO TIME OFF FROM WORK";
label variable CMNPLC53 "CSAQ: DIDN T KNOW WHERE TO GO";
label variable CMNCRE53 "CSAQ: NO CHILD/ADULT CARE";
label variable CMNLNG53 "CSAQ: NO TIME FOR CARE/TREATMENT";
label variable CMOTHR "CSAQ: OTHER REASON FOR NO TREATMENT/CARE";
label variable CMMAIN53 "CSAQ: MAIN REASON FOR NO TREATMENT/CARE";
label variable CEFACT53 "CSAQ: ACTIVITIES LIMITED DUE TO CANCER";
label variable CEFLCT53 "CSAQ: HOW LONG ACTIVITIES LIMITED";
label variable CEFOG53 "CSAQ: IS LIMITATION ONGOING";
label variable CEFMTL53 "CSAQ: MENTAL TASKS AFFECTED BY CANCER";
label variable CEFASK53 "CSAQ: ASKED FOR HELP GETTING TO DOCTOR";
label variable CEFREC53 "CSAQ: RCVD HELP FROM DOCTOR OR PROVIDER";
label variable CEFAHU53 "CSAQ: ASKED FOR HELP UNDERSTANDING BILLS";
label variable CEFRHU53 "CSAQ: RCVD HELP UNDERSTANDING BILLS";
label variable CEFBCK53 "CSAQ: WORRY CANCER COME BACK/GET WORSE";
label variable CEFRSP53 "CSAQ: WORRY RESPONSIBILITIES AT HOME/WRK";
label variable CEFOPN53 "CSAQ: CHANCES OF CANCER RETURN/GET WORSE";
label variable CEFSTG53 "CSAQ: EXP - MADE A STRONGER PERSON";
label variable CEFCOP53 "CSAQ: EXP - COPE BETTER W/ CHALLENGES";
label variable CEFPOS53 "CSAQ: EXP - REASON FOR POSITIVE CHANGES";
label variable CEFHLT53 "CSAQ: EXP - MADE HEALTHIER HABITS";
label variable DDNWRK31 "# DAYS MISSED WORK DUE TO ILL/INJ (RD31)";
label variable DDNWRK42 "# DAYS MISSED WORK DUE TO ILL/INJ (RD42)";
label variable DDNWRK53 "# DAYS MISSED WORK DUE TO ILL/INJ (RD53)";
label variable WKINBD31 "# DAYS MISSED WORK STAYED IN BED (RD31)";
label variable WKINBD42 "# DAYS MISSED WORK STAYED IN BED (RD42)";
label variable WKINBD53 "# DAYS MISSED WORK STAYED IN BED (RD53)";
label variable DDNSCL31 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD31)";
label variable DDNSCL42 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD42)";
label variable DDNSCL53 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD53)";
label variable SCLNBD31 "# DAYS MISSED SCHOOL STAYD IN BED (RD31)";
label variable SCLNBD42 "# DAYS MISSED SCHOOL STAYD IN BED (RD42)";
label variable SCLNBD53 "# DAYS MISSED SCHOOL STAYD IN BED (RD53)";
label variable DDBDYS31 "# OTH DAY SPENT IN BED SINCE START(RD31)";
label variable DDBDYS42 "# OTH DAY SPENT IN BED SINCE START(RD42)";
label variable DDBDYS53 "# OTH DAY SPENT IN BED SINCE START(RD53)";
label variable OTHDYS31 "MISS ANY WORK DAY TO CARE FOR OTH (RD31)";
label variable OTHDYS42 "MISS ANY WORK DAY TO CARE FOR OTH (RD42)";
label variable OTHDYS53 "MISS ANY WORK DAY TO CARE FOR OTH (RD53)";
label variable OTHNDD31 "# DAY MISSED WORK TO CARE FOR OTH (RD31)";
label variable OTHNDD42 "# DAY MISSED WORK TO CARE FOR OTH (RD42)";
label variable OTHNDD53 "# DAY MISSED WORK TO CARE FOR OTH (RD53)";
label variable ACCELI42 "PERS ELIGIBLE FOR ACCESS SUPPLEMENT-R4/2";
label variable LANGHM42 "AC01 LANGUAGE SPOKEN MOST IN HOME-R4/2";
label variable ENGCMF42 "AC02 WHOLE HH COMFRTBLE SPEAKNG ENG-R4/2";
label variable ENGSPK42 "AC02A NOT COMFRTBLE SPEAKNG ENGLISH-R4/2";
label variable USBORN42 "AC03 WAS PERSON BORN IN US-R4/2";
label variable USLIVE42 "AC04 # YRS PERSON LIVED IN US-R4/2";
label variable HAVEUS42 "AC05 DOES PERSON HAVE USC PROVIDER-R4/2";
label variable YNOUSC42 "AC07 MAIN REAS PERS DOESNT HAVE USC-R4/2";
label variable NOREAS42 "AC08 OTH REAS NO USC:NO OTH REASONS-R4/2";
label variable SELDSI42 "AC08 OTH REAS NO USC:SELDM/NEV SICK-R4/2";
label variable NEWARE42 "AC08 OTH REAS NO USC:RECENTLY MOVED-R4/2";
label variable DKWHRU42 "AC08 OTH REAS NO USC:DK WHERE TO GO-R4/2";
label variable USCNOT42 "AC08 OTH REAS NO USC: USC NOT AVAIL-R4/2";
label variable PERSLA42 "AC08 OTH REAS NO USC: LANGUAGE-R4/2";
label variable DIFFPL42 "AC08 OTH REAS NO USC:DIFFRNT PLACES-R4/2";
label variable INSRPL42 "AC08 OTH REAS NO USC:JUST CHNGD INS-R4/2";
label variable MYSELF42 "AC08 OTH REAS NO USC:NO DOC/TRT SLF-R4/2";
label variable CARECO42 "AC08 OTH REAS NO USC:COST OF MED CR-R4/2";
label variable NOHINS42 "AC08 OTH REAS NO USC:NO HLTH INSRNC-R4/2";
label variable OTHINS42 "AC08 OTH REAS NO USC: INS RELATED-R4/2";
label variable JOBRSN42 "AC08 OTH REAS NO USC: JOB RELATED-R4/2";
label variable NEWDOC42 "AC08 OTH REAS NO USC: LOOKNG FOR DR-R4/2";
label variable DOCELS42 "AC08 OTH REAS NO USC: DR ELSEWHERE-R4/2";
label variable NOLIKE42 "AC08 OTH REAS NO USC: DONT LIKE DRS-R4/2";
label variable HEALTH42 "AC08 OTH REAS NO USC: HLTH RELATED-R4/2";
label variable KNOWDR42 "AC08 OTH REAS NO USC: KNOWS/IS A DR-R4/2";
label variable ONJOB42 "AC08 OTH REAS NO USC: DR AT WORK-R4/2";
label variable NOGODR42 "AC08 OTH REAS NO USC: WONT GO TO DR-R4/2";
label variable TRANS42 "AC08 OTH REAS NO USC: TRANSPRT/TIME-R4/2";
label variable CLINIC42 "AC08 OTH REAS NO USC: HOSP/ER/CLNIC-R4/2";
label variable OTHREA42 "AC08 OTH REAS NO USC: OTHER REASON-R4/2";
label variable PROVTY42 "PROVIDER TYPE-R4/2";
label variable PLCTYP42 "USC TYPE OF PLACE-R4/2";
label variable GOTOUS42 "AC12 HOW DOES PERS GET TO USC PROV-R4/2";
label variable TMTKUS42 "AC13 HOW LONG IT TAKES GET TO USC-R4/2";
label variable DFTOUS42 "AC14 HOW DIFFICULT IS IT GET TO USC-R4/2";
label variable TYPEPE42 "USC TYPE OF PROVIDER-R4/2";
label variable LOCATN42 "USC LOCATION-R4/2";
label variable HSPLAP42 "AC18 IS PROVIDER HISPANIC OR LATINO-R4/2";
label variable WHITPR42 "AC19 IS PROVIDER WHITE-R4/2";
label variable BLCKPR42 "AC19 IS PROVIDER BLACK/AFRICAN AMER-R4/2";
label variable ASIANP42 "AC19 IS PROVIDER ASIAN-R4/2";
label variable NATAMP42 "AC19 IS PROVIDER NATIVE AMERICAN-R4/2";
label variable PACISP42 "AC19 IS PROVIDER OTH PACIFIC ISLNDR-R4/2";
label variable OTHRCP42 "AC19 IS PROVIDER SOME OTHER RACE-R4/2";
label variable GENDRP42 "AC20 IS PROVIDER MALE OR FEMALE-R4/2";
label variable MINORP42 "AC22 GO TO USC FOR NEW HEALTH PROB-R4/2";
label variable PREVEN42 "AC22 GO TO USC FOR PRVNTVE HLT CARE-R4/2";
label variable REFFRL42 "AC22 GO TO USC FOR REFERRALS-R4/2";
label variable ONGONG42 "AC22 GO TO USC FOR ONGOING HLTH PRB-R4/2";
label variable PHNREG42 "AC23 HOW DIFF CONTACT USC BY PHONE-R4/2";
label variable OFFHOU42 "AC24 USC HAS OFFCE HRS NGHTS/WKENDS-R4/2";
label variable AFTHOU42 "AC25 HOW DIFF CONTACT USC AFT HOURS-R4/2";
label variable TREATM42 "AC26 PROV ASK ABOUT OTH TREATMENTS-R4/2";
label variable RESPCT42 "AC27 PROV SHOWS RESPECT FOR TRTMNTS-R4/2";
label variable DECIDE42 "AC28 PROV ASKS PERS TO HELP DECIDE-R4/2";
label variable EXPLOP42 "AC30 PROV EXPLNS OPTIONS TO PERS-R4/2";
label variable LANGPR42 "AC31 PROV SPEAKS PERSON S LANGUAGE-R4/2";
label variable MDUNAB42 "UNABLE TO GET NECESSRY MEDICAL CARE-R4/2";
label variable MDUNRS42 "AC34 RSN UNABLE GET NECSRY MED CARE-R4/2";
label variable MDUNPR42 "AC35 PRB NOT GETTING NCSRY MED CARE-R4/2";
label variable MDDLAY42 "DELAYED IN GETTING NECSRY MED CARE-R4/2";
label variable MDDLRS42 "AC38 RSN DLAYD GETTING NEC MED CARE-R4/2";
label variable MDDLPR42 "AC39 PRB DLAYD GETTING NEC MED CARE-R4/2";
label variable DNUNAB42 "UNABLE TO GET NECESSARY DENTAL CARE-R4/2";
label variable DNUNRS42 "AC42 RSN UNABLE GET NCSRY DENT CARE-R4/2";
label variable DNUNPR42 "AC43 PRB UNABLE GET NCSRY DENT CARE-R4/2";
label variable DNDLAY42 "DELAYED IN GETTING NEC DENTAL CARE-R4/2";
label variable DNDLRS42 "AC46 RSN DLAYD GETTNG NEC DENT CARE-R4/2";
label variable DNDLPR42 "AC47 PRB DLAYD GETTNG NEC DENT CARE-R4/2";
label variable PMUNAB42 "UNABLE TO GET NECESSARY PRES MED-R4/2";
label variable PMUNRS42 "AC50 RSN UNABLE TO GET NEC PRES MED-R4/2";
label variable PMUNPR42 "AC51 PRB UNABLE TO GET NEC PRES MED-R4/2";
label variable PMDLAY42 "DELAYED IN GETTING NECSRY PRES MED-R4/2";
label variable PMDLRS42 "AC54 RSN DLAYD GETTING NEC PRES MED-R4/2";
label variable PMDLPR42 "AC55 PRB DLAYD GETTING NEC PRES MED-R4/2";
label variable EMPST31 "EMPLOYMENT STATUS RD 3/1";
label variable EMPST42 "EMPLOYMENT STATUS RD 4/2";
label variable EMPST53 "EMPLOYMENT STATUS RD 5/3";
label variable RNDFLG31 "DATA COLLECTION ROUND FOR RD 3/1 CMJ";
label variable MORJOB31 "HAS MORE THAN ONE JOB RD 3/1 INT DATE";
label variable MORJOB42 "HAS MORE THAN ONE JOB RD 4/2 INT DATE";
label variable MORJOB53 "HAS MORE THAN ONE JOB RD 5/3 INT DATE";
label variable EVRWRK "EVER WRKD FOR PAY IN LIFE AS OF 12/31/11";
label variable HRWG31X "HOURLY WAGE RD 3/1 CMJ (IMP)";
label variable HRWG42X "HOURLY WAGE RD 4/2 CMJ (IMP)";
label variable HRWG53X "HOURLY WAGE RD 5/3 CMJ (IMP)";
label variable HRWGIM31 "HRWG31X IMPUTATION FLAG";
label variable HRWGIM42 "HRWG42X IMPUTATION FLAG";
label variable HRWGIM53 "HRWG53X IMPUTATION FLAG";
label variable HRHOW31 "HOW HOURLY WAGE WAS CALCULATED RD 3/1";
label variable HRHOW42 "HOW HOURLY WAGE WAS CALCULATED RD 4/2";
label variable HRHOW53 "HOW HOURLY WAGE WAS CALCULATED RD 5/3";
label variable DIFFWG31 "PERSONS WAGES DIFFERENT THIS RD31 AT CMJ";
label variable DIFFWG42 "PERSONS WAGES DIFFERENT THIS RD42 AT CMJ";
label variable DIFFWG53 "PERSONS WAGES DIFFERENT THIS RD53 AT CMJ";
label variable NHRWG31 "UPDATED HRLY WAGE RD 3/1 CMJ (EDITED)";
label variable NHRWG42 "UPDATED HRLY WAGE RD 4/2 CMJ (EDITED)";
label variable NHRWG53 "UPDATED HRLY WAGE RD 5/3 CMJ (EDITED)";
label variable HOUR31 "HOURS PER WEEK AT RD 3/1 CMJ";
label variable HOUR42 "HOURS PER WEEK AT RD 4/2 CMJ";
label variable HOUR53 "HOURS PER WEEK AT RD 5/3 CMJ";
label variable TEMPJB31 "IS CMJ A TEMPORARY JOB RD 3/1";
label variable TEMPJB42 "IS CMJ A TEMPORARY JOB RD 4/2";
label variable TEMPJB53 "IS CMJ A TEMPORARY JOB RD 5/3";
label variable SSNLJB31 "IS CMJ A SEASONAL JOB RD 3/1";
label variable SSNLJB42 "IS CMJ A SEASONAL JOB RD 4/2";
label variable SSNLJB53 "IS CMJ A SEASONAL JOB RD 5/3";
label variable SELFCM31 "SELF-EMPLOYED AT RD 3/1 CMJ";
label variable SELFCM42 "SELF-EMPLOYED AT RD 4/2 CMJ";
label variable SELFCM53 "SELF-EMPLOYED AT RD 5/3 CMJ";
label variable DISVW31X "DISAVOWED HEALTH INS AT RD 3/1 CMJ (ED)";
label variable DISVW42X "DISAVOWED HEALTH INS AT RD 4/2 CMJ (ED)";
label variable DISVW53X "DISAVOWED HEALTH INS AT RD 5/3 CMJ (ED)";
label variable CHOIC31 "CHOICE OF HEALTH PLANS AT RD 3/1 CMJ";
label variable CHOIC42 "CHOICE OF HEALTH PLANS AT RD 4/2 CMJ";
label variable CHOIC53 "CHOICE OF HEALTH PLANS AT RD 5/3 CMJ";
label variable INDCAT31 "INDUSTRY GROUP RD 3/1 CMJ";
label variable INDCAT42 "INDUSTRY GROUP RD 4/2 CMJ";
label variable INDCAT53 "INDUSTRY GROUP RD 5/3 CMJ";
label variable NUMEMP31 "NUMBER OF EMPLOYEES AT RD 3/1 CMJ";
label variable NUMEMP42 "NUMBER OF EMPLOYEES AT RD 4/2 CMJ";
label variable NUMEMP53 "NUMBER OF EMPLOYEES AT RD 5/3 CMJ";
label variable MORE31 "RD 3/1 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE42 "RD 4/2 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE53 "RD 5/3 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable UNION31 "UNION STATUS AT RD 3/1 CMJ";
label variable UNION42 "UNION STATUS AT RD 4/2 CMJ";
label variable UNION53 "UNION STATUS AT RD 5/3 CMJ";
label variable NWK31 "REASON NOT WORKING DURING RD 3/1";
label variable NWK42 "REASON NOT WORKING DURING RD 4/2";
label variable NWK53 "REASON NOT WORKING DURING RD 5/3";
label variable CHGJ3142 "CHANGED JOB BETWEEN RD 3/1 AND RD 4/2";
label variable CHGJ4253 "CHANGED JOB BETWEEN RD 4/2 AND RD 5/3";
label variable YCHJ3142 "WHY CHNGD JOB BETWEEN RD 3/1 AND RD 4/2";
label variable YCHJ4253 "WHY CHNGD JOB BETWEEN RD 4/2 AND RD 5/3";
label variable STJBMM31 "MONTH STARTED RD 3/1 CMJ";
label variable STJBDD31 "DAY STARTED RD 3/1 CMJ";
label variable STJBYY31 "YEAR STARTED RD 3/1 CMJ";
label variable STJBMM42 "MONTH STARTED RD 4/2 CMJ";
label variable STJBDD42 "DAY STARTED RD 4/2 CMJ";
label variable STJBYY42 "YEAR STARTED RD 4/2 CMJ";
label variable STJBMM53 "MONTH STARTED RD 5/3 CMJ";
label variable STJBDD53 "DAY STARTED RD 5/3 CMJ";
label variable STJBYY53 "YEAR STARTED RD 5/3 CMJ";
label variable EVRETIRE "PERSON HAS EVER RETIRED";
label variable OCCCAT31 "OCCUPATION GROUP RD 3/1 CMJ";
label variable OCCCAT42 "OCCUPATION GROUP RD 4/2 CMJ";
label variable OCCCAT53 "OCCUPATION GROUP RD 5/3 CMJ";
label variable PAYVAC31 "PAID VACATION AT RD 3/1 CMJ";
label variable PAYVAC42 "PAID VACATION AT RD 4/2 CMJ";
label variable PAYVAC53 "PAID VACATION AT RD 5/3 CMJ";
label variable SICPAY31 "PAID SICK LEAVE AT RD 3/1 CMJ";
label variable SICPAY42 "PAID SICK LEAVE AT RD 4/2 CMJ";
label variable SICPAY53 "PAID SICK LEAVE AT RD 5/3 CMJ";
label variable PAYDR31 "PAID LEAVE TO VISIT DR RD 3/1 CMJ";
label variable PAYDR42 "PAID LEAVE TO VISIT DR RD 4/2 CMJ";
label variable PAYDR53 "PAID LEAVE TO VISIT DR RD 5/3 CMJ";
label variable RETPLN31 "PENSION PLAN AT RD 3/1 CMJ";
label variable RETPLN42 "PENSION PLAN AT RD 4/2 CMJ";
label variable RETPLN53 "PENSION PLAN AT RD 5/3 CMJ";
label variable BSNTY31 "SOLE PROP, PARTNER, CORP, RD 3/1 CMJ";
label variable BSNTY42 "SOLE PROP, PARTNER, CORP, RD 4/2 CMJ";
label variable BSNTY53 "SOLE PROP, PARTNER, CORP, RD 5/3 CMJ";
label variable JOBORG31 "PRIV (PROFIT,NONPROFIT) GOV RD 3/1 CMJ";
label variable JOBORG42 "PRIV (PROFIT,NONPROFIT) GOV RD 4/2 CMJ";
label variable JOBORG53 "PRIV (PROFIT,NONPROFIT) GOV RD 5/3 CMJ";
label variable HELD31X "HEALTH INSUR HELD FROM RD 3/1 CMJ (ED)";
label variable HELD42X "HEALTH INSUR HELD FROM RD 4/2 CMJ (ED)";
label variable HELD53X "HEALTH INSUR HELD FROM RD 5/3 CMJ (ED)";
label variable OFFER31X "HEALTH INSUR OFFERED BY RD 3/1 CMJ (ED)";
label variable OFFER42X "HEALTH INSUR OFFERED BY RD 4/2 CMJ (ED)";
label variable OFFER53X "HEALTH INSUR OFFERED BY RD 5/3 CMJ (ED)";
label variable OFREMP31 "EMPLOYER OFFERS HEALTH INS RD 3/1 CMJ";
label variable OFREMP42 "EMPLOYER OFFERS HEALTH INS RD 4/2 CMJ";
label variable OFREMP53 "EMPLOYER OFFERS HEALTH INS RD 5/3 CMJ";
label variable YNOINS31 "WHY NOT ELIGIBLE HEALTH INS RD 3/1 CMJ";
label variable YNOINS42 "WHY NOT ELIGIBLE HEALTH INS RD 4/2 CMJ";
label variable YNOINS53 "WHY NOT ELIGIBLE HEALTH INS RD 5/3 CMJ";
label variable SSIDIS11 "SSI RECEIPT DUE TO DISABILITY";
label variable AFDC11 "DID PERSON S CHECK INCLUDE TANF";
label variable FILEDR11 "HAS PERSON FILED A FED INCOME TAX RETURN";
label variable WILFIL11 "WILL PERSON FILE FED INCOME TAX RETURN";
label variable FLSTAT11 "PERSON S FILING STATUS";
label variable FILER11 "PRIMARY OR SECONDARY FILER";
label variable JTINRU11 "JOINT FILER S MEMBERSHIP IN RU";
label variable JNTPID11 "PID OF SECONDARY FILER";
label variable CLMDEP11 "DID/WILL PERS CLAIM DEPENDENTS ON RETURN";
label variable DEPDNT11 "PERSON IS FLAGGED A DEPENDENT";
label variable DPINRU11 "DEPENDENTS IN/OUT OF RU";
label variable DPOTSD11 "HOW MANY DEPENDENTS LIVE OUTSIDE RU";
label variable TAXFRM11 "TAX FORM PERSON WILL FILE";
label variable DEDUCT11 "ITEMIZE OR STANDARD DEDUCTION";
label variable TOTDED11 "TOTAL OF ALL ITEMIZED DEDUCTIONS";
label variable CLMHIP11 "DID/WILL PERS DEDUCT HEALTH INSUR. PREM.";
label variable EICRDT11 "DID/WILL PERS RECEIVE EARNED INC CREDIT";
label variable FOODST11 "DID ANYONE PURCHASE FOOD STAMPS";
label variable FOODMN11 "NUMBER OF MONTHS FOOD STAMPS PURCHASED";
label variable FOODVL11 "MONTHLY VALUE OF FOOD STAMPS";
label variable TTLP11X "PERSON S TOTAL INCOME";
label variable FAMINC11 "FAMILY S TOTAL INCOME";
label variable POVCAT11 "FAMILY INC AS % OF POVERTY LINE - CATEGO";
label variable POVLEV11 "FAMILY INC AS % OF POVERTY LINE - CONTIN";
label variable WAGEP11X "PERSON S WAGE INCOME";
label variable WAGIMP11 "WAGE IMPUTATION FLAG";
label variable BUSNP11X "PERSON S BUSINESS INCOME";
label variable BUSIMP11 "BUSINESS INCOME IMPUTATION FLAG";
label variable UNEMP11X "PERSON S UNEMPLOYMENT COMP INCOME";
label variable UNEIMP11 "UNEMPLOYMENT IMPUTATION FLAG";
label variable WCMPP11X "PERSON S WORKERS  COMPENSATION";
label variable WCPIMP11 "WORKERS  COMP IMPUTATION FLAG";
label variable INTRP11X "PERSON S INTEREST INCOME";
label variable INTIMP11 "INTEREST INCOME IMPUTATION FLAG";
label variable DIVDP11X "PERSON S DIVIDEND INCOME";
label variable DIVIMP11 "DIVIDEND INCOME IMPUTATION FLAG";
label variable SALEP11X "PERSON S SALES INCOME";
label variable SALIMP11 "SALES INCOME IMPUTATION FLAG";
label variable PENSP11X "PERSON S PENSION INCOME";
label variable PENIMP11 "PENSION INCOME IMPUTATION FLAG";
label variable SSECP11X "PERSON S SOCIAL SECURITY INCOME";
label variable SSCIMP11 "SOCIAL SECURITY INCOME IMPUTATION FLAG";
label variable TRSTP11X "PERSON S TRUST/RENT INCOME";
label variable TRTIMP11 "TRUST INCOME IMPUTATION FLAG";
label variable VETSP11X "PERSON S VETERAN S INCOME";
label variable VETIMP11 "VETERAN S INCOME IMPUTATION FLAG";
label variable IRASP11X "PERSON S IRA INCOME";
label variable IRAIMP11 "IRA INCOME IMPUTATION FLAG";
label variable REFDP11X "PERSON S REFUND INCOME";
label variable REFIMP11 "REFUND INCOME IMPUTATION FLAG";
label variable ALIMP11X "PERSON S ALIMONY INCOME";
label variable ALIIMP11 "ALIMONY INCOME IMPUTATION FLAG";
label variable CHLDP11X "PERSON S CHILD SUPPORT";
label variable CHLIMP11 "CHILD SUPPORT IMPUTATION FLAG";
label variable CASHP11X "PERSON S OTHER REGULAR CASH CONTRIBUTION";
label variable CSHIMP11 "CASH CONTRIBUTION IMPUTATION FLAG";
label variable SSIP11X "PERSON S SSI";
label variable SSIIMP11 "SSI IMPUTATION FLAG";
label variable PUBP11X "PERSON S PUBLIC ASSISTANCE";
label variable PUBIMP11 "PUBLIC ASSISTANCE IMPUTATION FLAG";
label variable OTHRP11X "PERSON S OTHER INCOME";
label variable OTHIMP11 "OTHER INCOME IMPUTATION FLAG";
label variable HIEUIDX "HIEU IDENTIFIER";
label variable TRIJA11X "COVERED BY TRICARE/CHAMPVA IN JAN11 (ED)";
label variable TRIFE11X "COVERED BY TRICARE/CHAMPVA IN FEB11 (ED)";
label variable TRIMA11X "COVERED BY TRICARE/CHAMPVA IN MAR11 (ED)";
label variable TRIAP11X "COVERED BY TRICARE/CHAMPVA IN APR11(ED)";
label variable TRIMY11X "COVERED BY TRICARE/CHAMPVA IN MAY11 (ED)";
label variable TRIJU11X "COVERED BY TRICARE/CHAMPVA IN JUN11 (ED)";
label variable TRIJL11X "COVERED BY TRICARE/CHAMPVA IN JUL11 (ED)";
label variable TRIAU11X "COVERED BY TRICARE/CHAMPVA IN AUG11 (ED)";
label variable TRISE11X "COVERED BY TRICARE/CHAMPVA IN SEP11 (ED)";
label variable TRIOC11X "COVERED BY TRICARE/CHAMPVA IN OCT11 (ED)";
label variable TRINO11X "COVERED BY TRICARE/CHAMPVA IN NOV11 (ED)";
label variable TRIDE11X "COVERED BY TRICARE/CHAMPVA IN DEC11 (ED)";
label variable MCRJA11 "COVERED BY MEDICARE IN JAN11";
label variable MCRFE11 "COVERED BY MEDICARE IN FEB11";
label variable MCRMA11 "COVERED BY MEDICARE IN MAR11";
label variable MCRAP11 "COVERED BY MEDICARE IN APR11";
label variable MCRMY11 "COVERED BY MEDICARE IN MAY11";
label variable MCRJU11 "COVERED BY MEDICARE IN JUN11";
label variable MCRJL11 "COVERED BY MEDICARE IN JUL11";
label variable MCRAU11 "COVERED BY MEDICARE IN AUG11";
label variable MCRSE11 "COVERED BY MEDICARE IN SEP11";
label variable MCROC11 "COVERED BY MEDICARE IN OCT11";
label variable MCRNO11 "COVERED BY MEDICARE IN NOV11";
label variable MCRDE11 "COVERED BY MEDICARE IN DEC11";
label variable MCRJA11X "COVERED BY MEDICARE IN JAN11 (ED)";
label variable MCRFE11X "COVERED BY MEDICARE IN FEB11 (ED)";
label variable MCRMA11X "COVERED BY MEDICARE IN MAR11 (ED)";
label variable MCRAP11X "COVERED BY MEDICARE IN APR11 (ED)";
label variable MCRMY11X "COVERED BY MEDICARE IN MAY11 (ED)";
label variable MCRJU11X "COVERED BY MEDICARE IN JUN11 (ED)";
label variable MCRJL11X "COVERED BY MEDICARE IN JUL11 (ED)";
label variable MCRAU11X "COVERED BY MEDICARE IN AUG11 (ED)";
label variable MCRSE11X "COVERED BY MEDICARE IN SEP11 (ED)";
label variable MCROC11X "COVERED BY MEDICARE IN OCT11 (ED)";
label variable MCRNO11X "COVERED BY MEDICARE IN NOV11 (ED)";
label variable MCRDE11X "COVERED BY MEDICARE IN DEC11 (ED)";
label variable MCDJA11 "COV BY MEDICAID OR SCHIP IN JAN11";
label variable MCDFE11 "COV BY MEDICAID OR SCHIP IN FEB11";
label variable MCDMA11 "COV BY MEDICAID OR SCHIP IN MAR11";
label variable MCDAP11 "COV BY MEDICAID OR SCHIP IN APR11";
label variable MCDMY11 "COV BY MEDICAID OR SCHIP IN MAY11";
label variable MCDJU11 "COV BY MEDICAID OR SCHIP IN JUN11";
label variable MCDJL11 "COV BY MEDICAID OR SCHIP IN JUL11";
label variable MCDAU11 "COV BY MEDICAID OR SCHIP IN AUG11";
label variable MCDSE11 "COV BY MEDICAID OR SCHIP IN SEP11";
label variable MCDOC11 "COV BY MEDICAID OR SCHIP IN OCT11";
label variable MCDNO11 "COV BY MEDICAID OR SCHIP IN NOV11";
label variable MCDDE11 "COV BY MEDICAID OR SCHIP IN DEC11";
label variable MCDJA11X "COV BY MEDICAID OR SCHIP IN JAN11 (ED)";
label variable MCDFE11X "COV BY MEDICAID OR SCHIP IN FEB11 (ED)";
label variable MCDMA11X "COV BY MEDICAID OR SCHIP IN MAR11 (ED)";
label variable MCDAP11X "COV BY MEDICAID OR SCHIP IN APR11 (ED)";
label variable MCDMY11X "COV BY MEDICAID OR SCHIP IN MAY11 (ED)";
label variable MCDJU11X "COV BY MEDICAID OR SCHIP IN JUN11 (ED)";
label variable MCDJL11X "COV BY MEDICAID OR SCHIP IN JUL11 (ED)";
label variable MCDAU11X "COV BY MEDICAID OR SCHIP IN AUG11 (ED)";
label variable MCDSE11X "COV BY MEDICAID OR SCHIP IN SEP11 (ED)";
label variable MCDOC11X "COV BY MEDICAID OR SCHIP IN OCT11 (ED)";
label variable MCDNO11X "COV BY MEDICAID OR SCHIP IN NOV11 (ED)";
label variable MCDDE11X "COV BY MEDICAID OR SCHIP IN DEC11 (ED)";
label variable OPAJA11 "COV BY OTHER PUBLIC A INS IN JAN11";
label variable OPAFE11 "COV BY OTHER PUBLIC A INS IN FEB11";
label variable OPAMA11 "COV BY OTHER PUBLIC A INS IN MAR11";
label variable OPAAP11 "COV BY OTHER PUBLIC A INS IN APR11";
label variable OPAMY11 "COV BY OTHER PUBLIC A INS IN MAY11";
label variable OPAJU11 "COV BY OTHER PUBLIC A INS IN JUN11";
label variable OPAJL11 "COV BY OTHER PUBLIC A INS IN JUL11";
label variable OPAAU11 "COV BY OTHER PUBLIC A INS IN AUG11";
label variable OPASE11 "COV BY OTHER PUBLIC A INS IN SEP11";
label variable OPAOC11 "COV BY OTHER PUBLIC A INS IN OCT11";
label variable OPANO11 "COV BY OTHER PUBLIC A INS IN NOV11";
label variable OPADE11 "COV BY OTHER PUBLIC A INS IN DEC11";
label variable OPBJA11 "COV BY OTHER PUBLIC B INS IN JAN11";
label variable OPBFE11 "COV BY OTHER PUBLIC B INS IN FEB11";
label variable OPBMA11 "COV BY OTHER PUBLIC B INS IN MAR11";
label variable OPBAP11 "COV BY OTHER PUBLIC B INS IN APR11";
label variable OPBMY11 "COV BY OTHER PUBLIC B INS IN MAY11";
label variable OPBJU11 "COV BY OTHER PUBLIC B INS IN JUN11";
label variable OPBJL11 "COV BY OTHER PUBLIC B INS IN JUL11";
label variable OPBAU11 "COV BY OTHER PUBLIC B INS IN AUG11";
label variable OPBSE11 "COV BY OTHER PUBLIC B INS IN SEP11";
label variable OPBOC11 "COV BY OTHER PUBLIC B INS IN OCT11";
label variable OPBNO11 "COV BY OTHER PUBLIC B INS IN NOV11";
label variable OPBDE11 "COV BY OTHER PUBLIC B INS IN DEC11";
label variable STAJA11 "COVERED BY OTHER STATE PROG IN JAN11";
label variable STAFE11 "COVERED BY OTHER STATE PROG IN FEB11";
label variable STAMA11 "COVERED BY OTHER STATE PROG IN MAR11";
label variable STAAP11 "COVERED BY OTHER STATE PROG IN APR11";
label variable STAMY11 "COVERED BY OTHER STATE PROG IN MAY11";
label variable STAJU11 "COVERED BY OTHER STATE PROG IN JUN11";
label variable STAJL11 "COVERED BY OTHER STATE PROG IN JUL11";
label variable STAAU11 "COVERED BY OTHER STATE PROG IN AUG11";
label variable STASE11 "COVERED BY OTHER STATE PROG IN SEP11";
label variable STAOC11 "COVERED BY OTHER STATE PROG IN OCT11";
label variable STANO11 "COVERED BY OTHER STATE PROG IN NOV11";
label variable STADE11 "COVERED BY OTHER STATE PROG IN DEC11";
label variable PUBJA11X "COVR BY ANY PUBLIC INS IN JAN11 (ED)";
label variable PUBFE11X "COVR BY ANY PUBLIC INS IN FEB11 (ED)";
label variable PUBMA11X "COVR BY ANY PUBLIC INS IN MAR11 (ED)";
label variable PUBAP11X "COVR BY ANY PUBLIC INS IN APR11 (ED)";
label variable PUBMY11X "COVR BY ANY PUBLIC INS IN MAY11 (ED)";
label variable PUBJU11X "COVR BY ANY PUBLIC INS IN JUN11 (ED)";
label variable PUBJL11X "COVR BY ANY PUBLIC INS IN JUL11 (ED)";
label variable PUBAU11X "COVR BY ANY PUBLIC INS IN AUG11 (ED)";
label variable PUBSE11X "COVR BY ANY PUBLIC INS IN SEP11 (ED)";
label variable PUBOC11X "COVR BY ANY PUBLIC INS IN OCT11 (ED)";
label variable PUBNO11X "COVR BY ANY PUBLIC INS IN NOV11 (ED)";
label variable PUBDE11X "COVR BY ANY PUBLIC INS IN DEC11 (ED)";
label variable PEGJA11 "COVERED BY EMPL UNION INS IN JAN11";
label variable PEGFE11 "COVERED BY EMPL UNION INS IN FEB11";
label variable PEGMA11 "COVERED BY EMPL UNION INS IN MAR11";
label variable PEGAP11 "COVERED BY EMPL UNION INS IN APR11";
label variable PEGMY11 "COVERED BY EMPL UNION INS IN MAY11";
label variable PEGJU11 "COVERED BY EMPL UNION INS IN JUN11";
label variable PEGJL11 "COVERED BY EMPL UNION INS IN JUL11";
label variable PEGAU11 "COVERED BY EMPL UNION INS IN AUG11";
label variable PEGSE11 "COVERED BY EMPL UNION INS IN SEP11";
label variable PEGOC11 "COVERED BY EMPL UNION INS IN OCT11";
label variable PEGNO11 "COVERED BY EMPL UNION INS IN NOV11";
label variable PEGDE11 "COVERED BY EMPL UNION INS IN DEC11";
label variable PDKJA11 "COVR BY PRIV INS (SOURCE UNKNWN) JAN11";
label variable PDKFE11 "COVR BY PRIV INS (SOURCE UNKNWN) FEB11";
label variable PDKMA11 "COVR BY PRIV INS (SOURCE UNKNWN) MAR11";
label variable PDKAP11 "COVR BY PRIV INS (SOURCE UNKNWN) APR11";
label variable PDKMY11 "COVR BY PRIV INS (SOURCE UNKNWN) MAY11";
label variable PDKJU11 "COVR BY PRIV INS (SOURCE UNKNWN) JUN11";
label variable PDKJL11 "COVR BY PRIV INS (SOURCE UNKNWN) JUL11";
label variable PDKAU11 "COVR BY PRIV INS (SOURCE UNKNWN) AUG11";
label variable PDKSE11 "COVR BY PRIV INS (SOURCE UNKNWN) SEP11";
label variable PDKOC11 "COVR BY PRIV INS (SOURCE UNKNWN) OCT11";
label variable PDKNO11 "COVR BY PRIV INS (SOURCE UNKNWN) NOV11";
label variable PDKDE11 "COVR BY PRIV INS (SOURCE UNKNWN) DEC11";
label variable PNGJA11 "COVERED BY NONGROUP INS IN JAN11";
label variable PNGFE11 "COVERED BY NONGROUP INS IN FEB11";
label variable PNGMA11 "COVERED BY NONGROUP INS IN MAR11";
label variable PNGAP11 "COVERED BY NONGROUP INS IN APR11";
label variable PNGMY11 "COVERED BY NONGROUP INS IN MAY11";
label variable PNGJU11 "COVERED BY NONGROUP INS IN JUN11";
label variable PNGJL11 "COVERED BY NONGROUP INS IN JUL11";
label variable PNGAU11 "COVERED BY NONGROUP INS IN AUG11";
label variable PNGSE11 "COVERED BY NONGROUP INS IN SEP11";
label variable PNGOC11 "COVERED BY NONGROUP INS IN OCT11";
label variable PNGNO11 "COVERED BY NONGROUP INS IN NOV11";
label variable PNGDE11 "COVERED BY NONGROUP INS IN DEC11";
label variable POGJA11 "COVERED BY OTHER GROUP INS IN JAN11";
label variable POGFE11 "COVERED BY OTHER GROUP INS IN FEB11";
label variable POGMA11 "COVERED BY OTHER GROUP INS IN MAR11";
label variable POGAP11 "COVERED BY OTHER GROUP INS IN APR11";
label variable POGMY11 "COVERED BY OTHER GROUP INS IN MAY11";
label variable POGJU11 "COVERED BY OTHER GROUP INS IN JUN11";
label variable POGJL11 "COVERED BY OTHER GROUP INS IN JUL11";
label variable POGAU11 "COVERED BY OTHER GROUP INS IN AUG11";
label variable POGSE11 "COVERED BY OTHER GROUP INS IN SEP11";
label variable POGOC11 "COVERED BY OTHER GROUP INS IN OCT11";
label variable POGNO11 "COVERED BY OTHER GROUP INS IN NOV11";
label variable POGDE11 "COVERED BY OTHER GROUP INS IN DEC11";
label variable PRSJA11 "COVERED BY SELF-EMP-1 INS IN JAN11";
label variable PRSFE11 "COVERED BY SELF-EMP-1 INS IN FEB11";
label variable PRSMA11 "COVERED BY SELF-EMP-1 INS IN MAR11";
label variable PRSAP11 "COVERED BY SELF-EMP-1 INS IN APR11";
label variable PRSMY11 "COVERED BY SELF-EMP-1 INS IN MAY11";
label variable PRSJU11 "COVERED BY SELF-EMP-1 INS IN JUN11";
label variable PRSJL11 "COVERED BY SELF-EMP-1 INS IN JUL11";
label variable PRSAU11 "COVERED BY SELF-EMP-1 INS IN AUG11";
label variable PRSSE11 "COVERED BY SELF-EMP-1 INS IN SEP11";
label variable PRSOC11 "COVERED BY SELF-EMP-1 INS IN OCT11";
label variable PRSNO11 "COVERED BY SELF-EMP-1 INS IN NOV11";
label variable PRSDE11 "COVERED BY SELF-EMP-1 INS IN DEC11";
label variable POUJA11 "COVERED BY HOLDER OUTSIDE OF RU IN JAN11";
label variable POUFE11 "COVERED BY HOLDER OUTSIDE OF RU IN FEB11";
label variable POUMA11 "COVERED BY HOLDER OUTSIDE OF RU IN MAR11";
label variable POUAP11 "COVERED BY HOLDER OUTSIDE OF RU IN APR11";
label variable POUMY11 "COVERED BY HOLDER OUTSIDE OF RU IN MAY11";
label variable POUJU11 "COVERED BY HOLDER OUTSIDE OF RU IN JUN11";
label variable POUJL11 "COVERED BY HOLDER OUTSIDE OF RU IN JUL11";
label variable POUAU11 "COVERED BY HOLDER OUTSIDE OF RU IN AUG11";
label variable POUSE11 "COVERED BY HOLDER OUTSIDE OF RU IN SEP11";
label variable POUOC11 "COVERED BY HOLDER OUTSIDE OF RU IN OCT11";
label variable POUNO11 "COVERED BY HOLDER OUTSIDE OF RU IN NOV11";
label variable POUDE11 "COVERED BY HOLDER OUTSIDE OF RU IN DEC11";
label variable PRIJA11 "COVERED BY PRIVATE INS IN JAN11";
label variable PRIFE11 "COVERED BY PRIVATE INS IN FEB11";
label variable PRIMA11 "COVERED BY PRIVATE INS IN MAR11";
label variable PRIAP11 "COVERED BY PRIVATE INS IN APR11";
label variable PRIMY11 "COVERED BY PRIVATE INS IN MAY11";
label variable PRIJU11 "COVERED BY PRIVATE INS IN JUN11";
label variable PRIJL11 "COVERED BY PRIVATE INS IN JUL11";
label variable PRIAU11 "COVERED BY PRIVATE INS IN AUG11";
label variable PRISE11 "COVERED BY PRIVATE INS IN SEP11";
label variable PRIOC11 "COVERED BY PRIVATE INS IN OCT11";
label variable PRINO11 "COVERED BY PRIVATE INS IN NOV11";
label variable PRIDE11 "COVERED BY PRIVATE INS IN DEC11";
label variable HPEJA11 "HOLDER OF EMPL UNION INS IN JAN11";
label variable HPEFE11 "HOLDER OF EMPL UNION INS IN FEB11";
label variable HPEMA11 "HOLDER OF EMPL UNION INS IN MAR11";
label variable HPEAP11 "HOLDER OF EMPL UNION INS IN APR11";
label variable HPEMY11 "HOLDER OF EMPL UNION INS IN MAY11";
label variable HPEJU11 "HOLDER OF EMPL UNION INS IN JUN11";
label variable HPEJL11 "HOLDER OF EMPL UNION INS IN JUL11";
label variable HPEAU11 "HOLDER OF EMPL UNION INS IN AUG11";
label variable HPESE11 "HOLDER OF EMPL UNION INS IN SEP11";
label variable HPEOC11 "HOLDER OF EMPL UNION INS IN OCT11";
label variable HPENO11 "HOLDER OF EMPL UNION INS IN NOV11";
label variable HPEDE11 "HOLDER OF EMPL UNION INS IN DEC11";
label variable HPDJA11 "HOLDER OF PRIV INS (SOURCE UNKNWN) JAN11";
label variable HPDFE11 "HOLDER OF PRIV INS (SOURCE UNKNWN) FEB11";
label variable HPDMA11 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAR11";
label variable HPDAP11 "HOLDER OF PRIV INS (SOURCE UNKNWN) APR11";
label variable HPDMY11 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAY11";
label variable HPDJU11 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUN11";
label variable HPDJL11 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUL11";
label variable HPDAU11 "HOLDER OF PRIV INS (SOURCE UNKNWN) AUG11";
label variable HPDSE11 "HOLDER OF PRIV INS (SOURCE UNKNWN) SEP11";
label variable HPDOC11 "HOLDER OF PRIV INS (SOURCE UNKNWN) OCT11";
label variable HPDNO11 "HOLDER OF PRIV INS (SOURCE UNKNWN) NOV11";
label variable HPDDE11 "HOLDER OF PRIV INS (SOURCE UNKNWN) DEC11";
label variable HPNJA11 "HOLDER OF NONGROUP INS IN JAN11";
label variable HPNFE11 "HOLDER OF NONGROUP INS IN FEB11";
label variable HPNMA11 "HOLDER OF NONGROUP INS IN MAR11";
label variable HPNAP11 "HOLDER OF NONGROUP INS IN APR11";
label variable HPNMY11 "HOLDER OF NONGROUP INS IN MAY11";
label variable HPNJU11 "HOLDER OF NONGROUP INS IN JUN11";
label variable HPNJL11 "HOLDER OF NONGROUP INS IN JUL11";
label variable HPNAU11 "HOLDER OF NONGROUP INS IN AUG11";
label variable HPNSE11 "HOLDER OF NONGROUP INS IN SEP11";
label variable HPNOC11 "HOLDER OF NONGROUP INS IN OCT11";
label variable HPNNO11 "HOLDER OF NONGROUP INS IN NOV11";
label variable HPNDE11 "HOLDER OF NONGROUP INS IN DEC11";
label variable HPOJA11 "HOLDER OF OTHER GROUP INS IN JAN11";
label variable HPOFE11 "HOLDER OF OTHER GROUP INS IN FEB11";
label variable HPOMA11 "HOLDER OF OTHER GROUP INS IN MAR11";
label variable HPOAP11 "HOLDER OF OTHER GROUP INS IN APR11";
label variable HPOMY11 "HOLDER OF OTHER GROUP INS IN MAY11";
label variable HPOJU11 "HOLDER OF OTHER GROUP INS IN JUN11";
label variable HPOJL11 "HOLDER OF OTHER GROUP INS IN JUL11";
label variable HPOAU11 "HOLDER OF OTHER GROUP INS IN AUG11";
label variable HPOSE11 "HOLDER OF OTHER GROUP INS IN SEP11";
label variable HPOOC11 "HOLDER OF OTHER GROUP INS IN OCT11";
label variable HPONO11 "HOLDER OF OTHER GROUP INS IN NOV11";
label variable HPODE11 "HOLDER OF OTHER GROUP INS IN DEC11";
label variable HPSJA11 "HOLDER OF SELF-EMP-1 INS IN JAN11";
label variable HPSFE11 "HOLDER OF SELF-EMP-1 INS IN FEB11";
label variable HPSMA11 "HOLDER OF SELF-EMP-1 INS IN MAR11";
label variable HPSAP11 "HOLDER OF SELF-EMP-1 INS IN APR11";
label variable HPSMY11 "HOLDER OF SELF-EMP-1 INS IN MAY11";
label variable HPSJU11 "HOLDER OF SELF-EMP-1 INS IN JUN11";
label variable HPSJL11 "HOLDER OF SELF-EMP-1 INS IN JUL11";
label variable HPSAU11 "HOLDER OF SELF-EMP-1 INS IN AUG11";
label variable HPSSE11 "HOLDER OF SELF-EMP-1 INS IN SEP11";
label variable HPSOC11 "HOLDER OF SELF-EMP-1 INS IN OCT11";
label variable HPSNO11 "HOLDER OF SELF-EMP-1 INS IN NOV11";
label variable HPSDE11 "HOLDER OF SELF-EMP-1 INS IN DEC11";
label variable HPRJA11 "HOLDER OF PRIVATE INSURANCE IN JAN11";
label variable HPRFE11 "HOLDER OF PRIVATE INSURANCE IN FEB11";
label variable HPRMA11 "HOLDER OF PRIVATE INSURANCE IN MAR11";
label variable HPRAP11 "HOLDER OF PRIVATE INSURANCE IN APR11";
label variable HPRMY11 "HOLDER OF PRIVATE INSURANCE IN MAY11";
label variable HPRJU11 "HOLDER OF PRIVATE INSURANCE IN JUN11";
label variable HPRJL11 "HOLDER OF PRIVATE INSURANCE IN JUL11";
label variable HPRAU11 "HOLDER OF PRIVATE INSURANCE IN AUG11";
label variable HPRSE11 "HOLDER OF PRIVATE INSURANCE IN SEP11";
label variable HPROC11 "HOLDER OF PRIVATE INSURANCE IN OCT11";
label variable HPRNO11 "HOLDER OF PRIVATE INSURANCE IN NOV11";
label variable HPRDE11 "HOLDER OF PRIVATE INSURANCE IN DEC11";
label variable INSJA11X "COVR BY HOSP/MED INS IN JAN11 (ED)";
label variable INSFE11X "COVR BY HOSP/MED INS IN FEB11 (ED)";
label variable INSMA11X "COVR BY HOSP/MED INS IN MAR11 (ED)";
label variable INSAP11X "COVR BY HOSP/MED INS IN APR11 (ED)";
label variable INSMY11X "COVR BY HOSP/MED INS IN MAY11 (ED)";
label variable INSJU11X "COVR BY HOSP/MED INS IN JUN11 (ED)";
label variable INSJL11X "COVR BY HOSP/MED INS IN JUL11 (ED)";
label variable INSAU11X "COVR BY HOSP/MED INS IN AUG11 (ED)";
label variable INSSE11X "COVR BY HOSP/MED INS IN SEP11 (ED)";
label variable INSOC11X "COVR BY HOSP/MED INS IN OCT11 (ED)";
label variable INSNO11X "COVR BY HOSP/MED INS IN NOV11 (ED)";
label variable INSDE11X "COVR BY HOSP/MED INS IN DEC11 (ED)";
label variable PRVEV11 "EVER HAVE PRIVATE INSURANCE DURING 11";
label variable TRIEV11 "EVER HAVE TRICARE/CHAMPVA DURING 11";
label variable MCREV11 "EVER HAVE MEDICARE DURING 11 (ED)";
label variable MCDEV11 "EVER HAVE MEDICAID/SCHIP DURING 11 (ED)";
label variable OPAEV11 "EVER HAVE OTHER PUBLIC A INS DURING 11";
label variable OPBEV11 "EVER HAVE OTHER PUBLIC B INS DURING 11";
label variable UNINS11 "UNINSURED ALL OF 11";
label variable INSCOV11 "HEALTH INSURANCE COVERAGE INDICATOR 11";
label variable INSURC11 "FULL YEAR INSURANCE COVERAGE STATUS 2011";
label variable TRIST31X "COVERED BY TRICARE STANDARD - R3/1";
label variable TRIST42X "COVERED BY TRICARE STANDARD - R4/2";
label variable TRIST11X "COVERED BY TRICARE STANDARD - 12/31/11";
label variable TRIPR31X "COVERED BY TRICARE PRIME - R3/1";
label variable TRIPR42X "COVERED BY TRICARE PRIME - R4/2";
label variable TRIPR11X "COVERED BY TRICARE PRIME - 12/31/11";
label variable TRIEX31X "COVERED BY TRICARE EXTRA - R3/1";
label variable TRIEX42X "COVERED BY TRICARE EXTRA - R4/2";
label variable TRIEX11X "COVERED BY TRICARE EXTRA - 12/31/11";
label variable TRILI31X "COVERED BY TRICARE FOR LIFE - R3/1";
label variable TRILI42X "COVERED BY TRICARE FOR LIFE - R4/2";
label variable TRILI11X "COVERED BY TRICARE FOR LIFE - 12/31/11";
label variable TRICH31X "COVERED BY TRICARE CHAMPVA - R3/1";
label variable TRICH42X "COVERED BY TRICARE CHAMPVA - R4/2";
label variable TRICH11X "COVERED BY TRICARE CHAMPVA - 12/31/11";
label variable MCRPD31 "COV BY MEDICARE PMED BENEFIT - R3/1";
label variable MCRPD42 "COV BY MEDICARE PMED BENEFIT - R4/2";
label variable MCRPD11 "COV BY MEDICARE PMED BENEFIT - 12/31/11";
label variable MCRPD31X "COV BY MEDICARE PMED BENEFIT - R3/1 (ED)";
label variable MCRPD42X "COV BY MEDICARE PMED BENEFIT - R4/2 (ED)";
label variable MCRPD11X "COV BY MCARE PMED BENEFIT-12/31/11 (ED)";
label variable MCRPB31 "COV BY MEDICARE PART B - R3/1";
label variable MCRPB42 "COV BY MEDICARE PART B - R4/2";
label variable MCRPB11 "COV BY MEDICARE PART B - 12/31/11";
label variable MCRPHO31 "COV BY MEDICARE MANAGED CARE - R3/1";
label variable MCRPHO42 "COV BY MEDICARE MANAGED CARE - R4/2";
label variable MCRPHO11 "COV BY MEDICARE MANAGED CARE - 12/31/11";
label variable MCDHMO31 "COVERED BY MEDICAID OR SCHIP HMO - R3/1";
label variable MCDHMO42 "COVERED BY MEDICAID OR SCHIP HMO - R4/2";
label variable MCDHMO11 "COVRED BY MEDICAID OR SCHIP HMO-12/31/11";
label variable MCDMC31 "COV BY MCAID/SCHIP GATEKEEPER PLAN-R3/1";
label variable MCDMC42 "COV BY MCAID/SCHIP GATEKEEPER PLAN-R4/2";
label variable MCDMC11 "COV BY MCAID/SCHIP GTKEEPR PLAN-12/31/11";
label variable PRVHMO31 "COVERED BY PRIVATE HMO - R3/1";
label variable PRVHMO42 "COVERED BY PRIVATE HMO - R4/2";
label variable PRVHMO11 "COVERED BY PRIVATE HMO - 12/31/11";
label variable PRVMNC31 "COVERED BY PRIVATE GATEKEEPER PLAN-R3/1";
label variable PRVMNC42 "COVERED BY PRIVATE GATEKEEPER PLAN-R4/2";
label variable PRVMNC11 "COVERED BY PRIV GATEKEEPER PLAN-12/31/11";
label variable PRVDRL31 "COV BY PRIV PLAN W/DOCTOR LIST - R3/1";
label variable PRVDRL42 "COV BY PRIV PLAN W/DOCTOR LIST - R4/2";
label variable PRVDRL11 "COV BY PRIV PLAN W/DOCTOR LIST-12/31/11";
label variable PHMONP31 "COV BY HMO-PAYS NON-PLAN DR VISITS-R3/1";
label variable PHMONP42 "COV BY HMO-PAYS NON-PLAN DR VISITS-R4/2";
label variable PHMONP11 "COV BY HMO-PAYS NON-PLAN DRS - 12/31/11";
label variable PMNCNP31 "COV BY GATEKPR-PAYS NON-PLAN DRS-R3/1";
label variable PMNCNP42 "COV BY GATEKPR-PAYS NON-PLAN DRS-R4/2";
label variable PMNCNP11 "COV BY GATEKP-PAYS NON-PLAN DRS-12/31/11";
label variable PRDRNP31 "COV BY DR LIST-PAYS NON-PLAN DRS-R3/1";
label variable PRDRNP42 "COV BY DR LIST-PAYS NON-PLAN DRS-R4/2";
label variable PRDRNP11 "COV BY DR LIST-PAYS NON-PLAN DR-12/31/11";
label variable FSAGT31 "ANYONE IN RU HAVE FSA - R3/1";
label variable HASFSA31 "PERSON IS FSA HOLDER - R3/1";
label variable FSAAMT31 "FSA TOTAL AMOUNT FOR RU - R3/1";
label variable PREVCOVR "PER COV BY INS IN PREV 2 YRS-PNL 16 ONLY";
label variable COVRMM "MONTH MOST RECENTLY COVERED-PNL 16 ONLY";
label variable COVRYY "YEAR MOST RECENTLY COVERED-PANEL 16 ONLY";
label variable WASESTB "WAS PREV INS BY EMPL OR UNION-PN 16 ONLY";
label variable WASMCARE "WAS PREV INS BY MEDICARE-PANEL 16 ONLY";
label variable WASMCAID "WAS PREV INS BY MCAID/SCHIP-PNL 16 ONLY";
label variable WASCHAMP "WAS PREV INS TRICARE/CHAMPVA-PNL 16 ONLY";
label variable WASVA "WAS PREV INS VA/MILITAR CARE-PNL 16 ONLY";
label variable WASPRIV "WAS PREV INS GRP/ASSOC/INS CO-PN 16 ONLY";
label variable WASOTGOV "WAS PREV INS BY OTH GOV PRG-PNL 16 ONLY";
label variable WASAFDC "WAS PREV INS BY PUBLIC AFDC-PNL 16 ONLY";
label variable WASSSI "WAS PREV INS BY SSI PROGRAM-PNL 16 ONLY";
label variable WASSTAT1 "WAS PREV INS BY STAT PROG 1-PNL 16 ONLY";
label variable WASSTAT2 "WAS PREV INS BY STAT PROG 2-PNL 16 ONLY";
label variable WASSTAT3 "WAS PREV INS BY STAT PROG 3-PNL 16 ONLY";
label variable WASSTAT4 "WAS PREV INS BY STAT PROG 4-PNL 16 ONLY";
label variable WASOTHER "WAS PREV INS BY OTH SOURCE-PANEL 16 ONLY";
label variable NOINSBEF "EVR WOUT HLTH INSR PREV YR-PANEL 16 ONLY";
label variable NOINSTM "# WKS/MON WOUT HLTH INS PRV YR-PN 16 ONL";
label variable NOINUNIT "UNIT OF TIME WOUT HLTH INS-PANEL 16 ONLY";
label variable MORECOVR "COV BY MOR COMPR PL PREV 2 YR-PN 16 ONLY";
label variable INSENDMM "MONTH MOST RECENTLY COVD-PANEL 16 ONLY";
label variable INSENDYY "YEAR MOST RECENTLY COVD-PANEL 16 ONLY";
label variable TRICR31X "COV BY TRICR/CHAMV - R3/1 INT DT (ED)";
label variable TRICR42X "COV BY TRICR/CHAMV - R4/2 INT DT (ED)";
label variable TRICR53X "COV BY TRICR/CHAMV 12-31/R3 INT DT (ED)";
label variable TRICR11X "COV BY TRICR/CHAMV - 12/31/11 (ED)";
label variable TRIAT31X "ANY TIME COV TRICARE/CHAMPVA - R3/1";
label variable TRIAT42X "ANY TIME COV TRICARE/CHAMPVA - R4/2";
label variable TRIAT53X "ANY TIME COV TRICARE/CHAMPVA - R5/3";
label variable TRIAT11X "ANY TIME COV TRICARE/CHAMPVA - 12/31/11";
label variable MCAID31 "COV BY MEDICAID OR SCHIP - R3/1 INT DT";
label variable MCAID42 "COV BY MEDICAID OR SCHIP - R4/2 INT DT";
label variable MCAID53 "COV BY MEDICAID OR SCHIP 12-31/R3 INT DT";
label variable MCAID11 "COV BY MEDICAID OR SCHIP - 12/31/11";
label variable MCAID31X "COV BY MEDICAID/SCHIP - R3/1 INT DT (ED)";
label variable MCAID42X "COV BY MEDICAID/SCHIP - R4/2 INT DT (ED)";
label variable MCAID53X "COV MEDICAID/SCHIP 12-31/R3 INT DT(ED)";
label variable MCAID11X "COV BY MEDICAID OR SCHIP - 12/31/11 (ED)";
label variable MCARE31 "COV BY MEDICARE - R3/1 INT DT";
label variable MCARE42 "COV BY MEDICARE - R4/2 INT DT";
label variable MCARE53 "COV BY MEDICARE 12-31/R3 INT DT";
label variable MCARE11 "COV BY MEDICARE - 12/31/11";
label variable MCARE31X "COV BY MEDICARE - R3/1 INT DT (ED)";
label variable MCARE42X "COV BY MEDICARE - R4/2 INT DT (ED)";
label variable MCARE53X "COV BY MEDICARE 12-31/R3 INT DT (ED)";
label variable MCARE11X "COV BY MEDICARE - 12/31/11 (ED)";
label variable MCDAT31X "ANY TIME COV MEDICAID OR SCHIP - R3/1";
label variable MCDAT42X "ANY TIME COV MEDICAID OR SCHIP - R4/2";
label variable MCDAT53X "ANY TIME COV MEDICAID OR SCHIP - R5/3";
label variable MCDAT11X "ANY TIME COV MEDICAID OR SCHIP-12/31/11";
label variable OTPAAT31 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R3/1";
label variable OTPAAT42 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R4/2";
label variable OTPAAT53 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R5/3";
label variable OTPAAT11 "ANY COV OT GOV MCAID/SCHIP HMO-12/31/11";
label variable OTPBAT31 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R3/1";
label variable OTPBAT42 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R4/2";
label variable OTPBAT53 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R5/3";
label variable OTPBAT11 "ANY CV OT GV NT MCAID/SCHIP HMO-12/31/11";
label variable OTPUBA31 "COV/PAY OTH GOV MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBA42 "COV/PAY OTH GOV MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBA53 "COV/PAY OTH GOV MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBA11 "COV/PAY OTH GOV MCAID/SCHIP HMO-12/31/11";
label variable OTPUBB31 "COV OTH GOV NOT MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBB42 "COV OTH GOV NOT MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBB53 "COV OTH GOV NOT MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBB11 "COV OTH GOV NOT MCAID/SCHIP HMO-12/31/11";
label variable PRIDK31 "COV BY PRIV INS (DK PLAN) - R3/1 INT";
label variable PRIDK42 "COV BY PRIV INS (DK PLAN) - R4/2 INT";
label variable PRIDK53 "COV BY PRIV INS (DK PLAN) 12-31/R3 INT";
label variable PRIDK11 "COV BY PRIV INS (DK PLAN) - 12/31/11";
label variable PRIEU31 "COV BY EMPL/UNION GRP INS - R3/1 INT DT";
label variable PRIEU42 "COV BY EMPL/UNION GRP INS - R4/2 INT DT";
label variable PRIEU53 "COV BY EMPL/UNION GRP INS 12-31/R3 INT";
label variable PRIEU11 "COV BY EMPL/UNION GRP INS - 12/31/11";
label variable PRING31 "COV BY NON-GROUP INS - R3/1 INT DT";
label variable PRING42 "COV BY NON-GROUP INS - R4/2 INT DT";
label variable PRING53 "COV BY NON-GROUP INS 12-31/R3 INT DT";
label variable PRING11 "COV BY NON-GROUP INS - 12/31/11";
label variable PRIOG31 "COV BY OTHER GROUP INS - R3/1 INT DT";
label variable PRIOG42 "COV BY OTHER GROUP INS - R4/2 INT DT";
label variable PRIOG53 "COV BY OTHER GROUP INS 12-31/R3 INT DT";
label variable PRIOG11 "COV BY OTHER GROUP INS - 12/31/11";
label variable PRIS31 "COV BY SELF-EMP-1 INS - R3/1 INT DT";
label variable PRIS42 "COV BY SELF-EMP-1 INS - R4/2 INT DT";
label variable PRIS53 "COV BY SELF-EMP-1 INS 12-31/R3 INT DT";
label variable PRIS11 "COV BY SELF-EMP-1 INS - 12/31/11";
label variable PRIV31 "COV BY PRIV HLTH INS - R3/1 INT DATE";
label variable PRIV42 "COV BY PRIV HLTH INS - R4/2 INT DATE";
label variable PRIV53 "COV BY PRIV HLTH INS 12-31/R3 INT DATE";
label variable PRIV11 "COV BY PRIV HLTH INS - 12/31/11";
label variable PRIVAT31 "ANY TIME COV PRIVATE INS - R3/1";
label variable PRIVAT42 "ANY TIME COV PRIVATE INS - R4/2";
label variable PRIVAT53 "ANY TIME COV PRIVATE INS - R5/3";
label variable PRIVAT11 "ANY TIME COV PRIVATE INS - 12/31/11";
label variable PROUT31 "COV BY SOMEONE OUT OF RU - R3/1 INT";
label variable PROUT42 "COV BY SOMEONE OUT OF RU - R4/2 INT";
label variable PROUT53 "COV BY SOMEONE OUT OF RU 12-31/R3 INT DT";
label variable PROUT11 "COV BY SOMEONE OUT OF RU - 12/31/11";
label variable PUB31X "COV BY PUBLIC INS - R3/1 INT DT (ED)";
label variable PUB42X "COV BY PUBLIC INS - R4/2 INT DT (ED)";
label variable PUB53X "COV BY PUBLIC INS 12-31/R3 INT DT (ED)";
label variable PUB11X "COV BY PUBLIC INS - 12/31/11 (ED)";
label variable PUBAT31X "ANY TIME COV BY PUBLIC - R3/1";
label variable PUBAT42X "ANY TIME COV BY PUBLIC - R4/2";
label variable PUBAT53X "ANY TIME COV BY PUBLIC - R5/3";
label variable PUBAT11X "ANY TIME COV BY PUBLIC - 12/31/11";
label variable INS31X "INSURED - R3/1 INT DATE (ED)";
label variable INS42X "INSURED - R4/2 INT DATE (ED)";
label variable INS53X "INSURED 12-31/R3 INT DATE (ED)";
label variable INS11X "INSURED - 12/31/11 (ED)";
label variable INSAT31X "INSURED ANY TIME IN R3/1";
label variable INSAT42X "INSURED ANY TIME IN R4/2";
label variable INSAT53X "INSURED ANY TIME IN R5/3";
label variable INSAT11X "INSURED ANY TIME IN R5/R3 UNTIL 12/31/11";
label variable STAPR31 "COV BY STATE-SPEC PROG - R3/1 INT DT";
label variable STAPR42 "COV BY STATE-SPEC PROG - R4/2 INT DT";
label variable STAPR53 "COV BY STATE-SPEC PROG 12-31/R3 INT DT";
label variable STAPR11 "COV BY STATE-SPEC PROG - 12/31/11";
label variable STPRAT31 "ANY TIME COVERAGE BY STATE INS - R3/1";
label variable STPRAT42 "ANY TIME COVERAGE BY STATE INS - R4/2";
label variable STPRAT53 "ANY TIME COVERAGE BY STATE INS - R5/3";
label variable STPRAT11 "ANY TIME COV BY STATE INS - 12/31/11";
label variable EVRUNINS "EVER UNINSURED IN 11 USING PRIV/PUBX";
label variable EVRUNAT "EVER UNINSURED IN 11 USING PRIVAT/PUBATX";
label variable DENTIN31 "DENTAL INSURANCE - RD 3/1";
label variable DENTIN42 "DENTAL INSURANCE - RD 4/2";
label variable DENTIN53 "DENTAL INSURANCE - RD 5/3";
label variable DNTINS31 "DENTAL INS - RD 3/1 IN 11";
label variable DNTINS11 "DENTAL INS - R5/R3 UNTIL 12/31/11";
label variable PMEDIN31 "PRESCRIPTION DRUG INSURANCE - RD 3/1";
label variable PMEDIN42 "PRESCRIPTION DRUG INSURANCE - RD 4/2";
label variable PMEDIN53 "PRESCRIPTION DRUG INSURANCE - RD 5/3";
label variable PMDINS31 "PMED INS - RD 3/1 IN 11";
label variable PMDINS11 "PMED INS - R5/R3 UNTIL 12/31/11";
label variable PMEDUP31 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R3/1";
label variable PMEDUP42 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R4/2";
label variable PMEDUP53 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R5/3";
label variable PMEDPY31 "USUAL 3RD PARTY PAYER FOR PMEDS - R3/1";
label variable PMEDPY42 "USUAL 3RD PARTY PAYER FOR PMEDS - R4/2";
label variable PMEDPY53 "USUAL 3RD PARTY PAYER FOR PMEDS - R5/3";
label variable PMEDPP31 "OUT-OF-POCKET PAYMENT FOR LAST PMED-R3/1";
label variable PMEDPP42 "OUT-OF-POCKET PAYMENT FOR LAST PMED-R4/2";
label variable PMEDPP53 "OUT-OF-POCKET PAYMENT FOR LAST PMED-R5/3";
label variable GDCPBM42 "MCAID/SCHIP/O PUB: PRB GET PERS DOC-R4/2";
label variable APRTRM42 "MCAID/SCHIP/O PUB: NEED APPRV 4 TRT-R4/2";
label variable APRDLM42 "MCAID/SCHIP/O PUB: DLY WAIT 4 APPRV-R4/2";
label variable LKINFM42 "MCAID/SCHIP/O PUB: LOOK 4 PLAN INFO-R4/2";
label variable PBINFM42 "MCAID/SCHIP/O PUB: PROB FINDNG INFO-R4/2";
label variable CSTSVM42 "MCAID/SCHIP/O PUB: CALL CUSTMR SERV-R4/2";
label variable PBSVCM42 "MCAID/SCHIP/O PUB: PRB W CUSRVC HLP-R4/2";
label variable PPRWKM42 "MCAID/SCHIP/O PUB: COMP PLAN PPRWRK-R4/2";
label variable PBPWKM42 "MCAID/SCHIP/O PUB: PRB W PLN PPRWRK-R4/2";
label variable RTPLNM42 "MCAID/SCHIP/O PUB: RATE EXP W PLAN-R4/2";
label variable GDCPBT42 "TRICR/CHAMV: PROB GETTING PERS DOC-R4/2";
label variable APRTRT42 "TRICR/CHAMV: NEED APPRVL 4 TREATMNT-R4/2";
label variable APRDLT42 "TRICR/CHAMV: DELAY WAITING 4 APPRVL-R4/2";
label variable LKINFT42 "TRICR/CHAMV: INFO ON HOW PLAN WORKS-R4/2";
label variable PBINFT42 "TRICR/CHAMV: PROBLEM FINDING INFO-R4/2";
label variable CSTSVT42 "TRICR/CHAMV: CALL CUSTOMER SERVICE-R4/2";
label variable PBSVCT42 "TRICR/CHAMV: PROB GET HELP FR CSRVC-R4/2";
label variable PPRWKT42 "TRICR/CHAMV:FILL OUT PAPERWRK 4 PLN-R4/2";
label variable PBPWKT42 "TRICR/CHAMV: PROB W PLAN PAPERWORK-R4/2";
label variable RTPLNT42 "TRICR/CHAMV: RATE EXPERIENCE W PLAN-R4/2";
label variable TOTTCH11 "TOTAL HEALTH CARE CHARGES 11, EXCL RX";
label variable TOTEXP11 "TOTAL HEALTH CARE EXP 11";
label variable TOTSLF11 "TOTAL AMT PAID BY SELF/FAMILY 11";
label variable TOTMCR11 "TOTAL AMT PAID BY MEDICARE 11";
label variable TOTMCD11 "TOTAL AMT PAID BY MEDICAID 11";
label variable TOTPRV11 "TOTAL AMT PAID BY PRIVATE INS 11";
label variable TOTVA11 "TOTAL AMT PAID BY VA/CHAMPVA 11";
label variable TOTTRI11 "TOTAL AMT PAID BY TRICARE 11";
label variable TOTOFD11 "TOTAL AMT PAID BY OTHER FEDERAL 11";
label variable TOTSTL11 "TOTAL AMT PAID BY OTH ST/LOCAL 11";
label variable TOTWCP11 "TOTAL AMT PAID BY WORKERS COMP 11";
label variable TOTOPR11 "TOTAL AMT PAID BY OTHER PRIVATE 11";
label variable TOTOPU11 "TOTAL AMT PAID BY OTHER PUBLIC 11";
label variable TOTOSR11 "TOTAL AMT PAID BY OTHER SOURCES 11";
label variable TOTPTR11 "TOTAL AMT PAID BY PRV & TRI 11";
label variable TOTOTH11 "TOTAL AMT PAID BY OTH COMBINED 11";
label variable OBTOTV11 "# OFFICE-BASED PROVIDER VISITS 11";
label variable OBVTCH11 "OFFICE-BASED PROVIDER VISIT CHARGES 11";
label variable OBVEXP11 "TOTAL OFFICE-BASED EXP 11";
label variable OBVSLF11 "ALL OFFICE VISITS - SELF/FAMILY AMT 11";
label variable OBVMCR11 "ALL OFFICE VISITS - MEDICARE AMT 11";
label variable OBVMCD11 "ALL OFFICE VISITS - MEDICAID AMT 11";
label variable OBVPRV11 "ALL OFFICE VISITS - PRIVATE INS AMT 11";
label variable OBVVA11 "ALL OFFICE VISITS-VA/CHAMPVA AMT 11";
label variable OBVTRI11 "ALL OFFICE VISITS-TRICARE AMT 11";
label variable OBVOFD11 "ALL OFFICE VISITS-OTHER FEDERAL AMT 11";
label variable OBVSTL11 "ALL OFFICE VISITS-OTH ST/LOCAL AMT 11";
label variable OBVWCP11 "ALL OFFICE VISITS - WORKERS COMP AMT 11";
label variable OBVOPR11 "ALL OFFICE VISITS - OTH PRIVATE AMT 11";
label variable OBVOPU11 "ALL OFFICE VISITS - OTH PUBLIC AMT 11";
label variable OBVOSR11 "ALL OFF VSTS - OTH UNCLASS SRCE AMT 11";
label variable OBVPTR11 "ALL OFFICE VISITS - PRV & TRI AMT 11";
label variable OBVOTH11 "ALL OFFICE VISITS - OTH COMBINED AMT 11";
label variable OBDRV11 "# OFFICE-BASED PHYSICIAN VISITS 11";
label variable OBDTCH11 "OFFICE-BASED PHYSICIAN VISIT CHARGES 11";
label variable OBDEXP11 "TOTAL OFF-BASED DR EXP 11";
label variable OBDSLF11 "DR OFFICE VISITS - SELF/FAMILY AMT 11";
label variable OBDMCR11 "DR OFFICE VISITS - MEDICARE AMT 11";
label variable OBDMCD11 "DR OFFICE VISITS - MEDICAID AMT 11";
label variable OBDPRV11 "DR OFFICE VISITS - PRIVATE INS AMT 11";
label variable OBDVA11 "DR OFFICE VISITS - VA/CHAMPVA AMT 11";
label variable OBDTRI11 "DR OFFICE VISITS - TRICARE AMT 11";
label variable OBDOFD11 "DR OFFICE VISITS - OTHER FEDERAL AMT 11";
label variable OBDSTL11 "DR OFFICE VISITS - OTH ST/LOCAL AMT 11";
label variable OBDWCP11 "DR OFFICE VISITS - WORKERS COMP AMT 11";
label variable OBDOPR11 "DR OFFICE VISITS - OTH PRIVATE AMT 11";
label variable OBDOPU11 "DR OFFICE VISITS - OTH PUBLIC AMT 11";
label variable OBDOSR11 "DR OFF VSTS - OTH UNCLASS SRCE AMT 11";
label variable OBDPTR11 "DR OFFICE VISITS - PRV & TRI AMT 11";
label variable OBDOTH11 "DR OFFICE VISITS - OTH COMBINED AMT 11";
label variable OBOTHV11 "# OFFICE-BASED NON-PHYSICAN VISITS 11";
label variable OBOTCH11 "OFFICE-BASED NON-DR VISIT CHARGES 11";
label variable OBOEXP11 "TOTAL OFF-BASED NON-DR EXP 11";
label variable OBOSLF11 "NON-DR OFF VISTS - SELF/FAMILY AMT 11";
label variable OBOMCR11 "NON-DR OFF VISTS - MEDICARE AMT 11";
label variable OBOMCD11 "NON-DR OFF VISTS - MEDICAID AMT 11";
label variable OBOPRV11 "NON-DR OFF VISTS - PRIVATE INS AMT 11";
label variable OBOVA11 "NON-DR OFF VISTS - VA/CHAMPVA AMT 11";
label variable OBOTRI11 "NON-DR OFF VISTS - TRICARE AMT 11";
label variable OBOOFD11 "NON-DR OFF VISTS - OTHER FEDERAL AMT 11";
label variable OBOSTL11 "NON-DR OFF VISTS - OTH ST/LOCAL AMT 11";
label variable OBOWCP11 "NON-DR OFF VISTS - WORKERS COMP AMT 11";
label variable OBOOPR11 "NON-DR OFF VISTS - OTH PRIVATE AMT 11";
label variable OBOOPU11 "NON-DR OFF VISTS - OTH PUBLIC AMT 11";
label variable OBOOSR11 "NON-DR OF VSTS - OTH UNCLASS SRCE AMT 11";
label variable OBOPTR11 "NON-DR OFF VISTS - PRV & TRI AMT 11";
label variable OBOOTH11 "NON-DR OFF VISTS - OTH COMBINED AMT 11";
label variable OBCHIR11 "# OFFICE-BASED CHIROPRACTOR VISITS 11";
label variable OBCTCH11 "OFFICE-BASED CHIRO VISIT CHARGES 11";
label variable OBCEXP11 "TOTAL OFF-BASED CHIRO EXP 11";
label variable OBCSLF11 "CHIRO OFF VISITS - SELF/FAMILY AMT 11";
label variable OBCMCR11 "CHIRO OFF VISITS - MEDICARE AMT 11";
label variable OBCMCD11 "CHIRO OFF VISITS - MEDICAID AMT 11";
label variable OBCPRV11 "CHIRO OFF VISITS - PRIVATE INS AMT 11";
label variable OBCVA11 "CHIRO OFF VISITS - VA/CHAMPVA AMT 11";
label variable OBCTRI11 "CHIRO OFF VISITS - TRICARE AMT 11";
label variable OBCOFD11 "CHIRO OFF VISITS - OTHER FEDERAL AMT 11";
label variable OBCSTL11 "CHIRO OFF VISITS - OTH ST/LOCAL AMT 11";
label variable OBCWCP11 "CHIRO OFF VISITS - WORKERS COMP AMT 11";
label variable OBCOPR11 "CHIRO OFF VISTS - OTHR PRIVATE AMT 11";
label variable OBCOPU11 "CHIRO OFF VISTS - OTHR PUBLIC AMT 11";
label variable OBCOSR11 "CHIRO OFF VSTS-OTHR UNCLASS SRCE AMT 11";
label variable OBCPTR11 "CHIRO OFF VISITS - PRV & TRI AMT 11";
label variable OBCOTH11 "CHIRO OFF VISITS -OTH COMBINED AMT 11";
label variable OBNURS11 "# OFF-BASED NURSE/PRACTITIONER VISITS 11";
label variable OBNTCH11 "OFFICE-BASED NURSE/PRAC VISIT CHARGES 11";
label variable OBNEXP11 "TOTAL OFF-BASED NURSE/PRAC 11";
label variable OBNSLF11 "NURSE/PRAC OFF VISITS-SELF/FAMILY AMT 11";
label variable OBNMCR11 "NURSE/PRAC OFF VISITS - MEDICARE AMT 11";
label variable OBNMCD11 "NURSE/PRAC OFF VSTS - MEDICAID AMT 11";
label variable OBNPRV11 "NURSE/PRAC OFF VSTS-PRIVATE INS AMT 11";
label variable OBNVA11 "NURSE/PRAC OFF VSTS - VA/CHAMPVA AMT 11";
label variable OBNTRI11 "NURSE/PRAC OFF VSTS - TRICARE AMT 11";
label variable OBNOFD11 "NURSE/PRAC OFF VSTS-OTHER FEDERAL AMT 11";
label variable OBNSTL11 "NURSE/PRAC OFF VSTS-OTH ST/LOCAL AMT 11";
label variable OBNWCP11 "NURSE/PRAC OFF VSTS-WORKERS COMP AMT 11";
label variable OBNOPR11 "NURSE/PRAC OFF VSTS - OTH PRIVATE AMT 11";
label variable OBNOPU11 "NURSE/PRAC OFF VSTS - OTH PUBLIC AMT 11";
label variable OBNOSR11 "NRS/PR OFF VSTS-OTH UNCLASS SRCE AMT 11";
label variable OBNPTR11 "NURSE/PRAC OFF VSTS - PRV & TRI AMT 11";
label variable OBNOTH11 "NURSE/PRAC OFF VSTS-OTH COMBINED AMT 11";
label variable OBOPTO11 "# OFF-BASED OPTOMETRIST VISITS 11";
label variable OBETCH11 "OFFICE-BASED OPTOMTRIST VISIT CHARGES 11";
label variable OBEEXP11 "TOTAL OFF-BASED OPTOMETRIST EXP 11";
label variable OBESLF11 "OPTOMETRIST OFF VSTS-SELF/FAMILY AMT 11";
label variable OBEMCR11 "OPTOMETRIST OFF VSTS - MEDICARE AMT 11";
label variable OBEMCD11 "OPTOMETRIST OFF VSTS - MEDICAID AMT 11";
label variable OBEPRV11 "OPTOMETRIST OFF VSTS-PRIVATE INS AMT 11";
label variable OBEVA11 "OPTOMETRIST OFF VSTS - VA/CHAMPVA AMT 11";
label variable OBETRI11 "OPTOMETRIST OFF VSTS - TRICARE AMT 11";
label variable OBEOFD11 "OPTOMETRIST OFF VSTS-OTH FEDERAL AMT 11";
label variable OBESTL11 "OPTOMETRIST OFF VSTS-OTH ST/LOCL AMT 11";
label variable OBEWCP11 "OPTOMETRIST OFF VSTS-WORKERS COMP AMT 11";
label variable OBEOPR11 "OPTOMETRIST OFF VSTS-OTH PRIVATE AMT 11";
label variable OBEOPU11 "OPTOMETRIST OFF VSTS - OTH PUBLIC AMT 11";
label variable OBEOSR11 "OPTOM OFF VSTS-OTH UNCLASS SRCE AMT 11";
label variable OBEPTR11 "OPTOMETRIST OFF VSTS - PRV & TRI AMT 11";
label variable OBEOTH11 "OPTOMETRIST OFF VSTS-OTH COMBINED AMT 11";
label variable OBASST11 "# OFF-BASED PHYSICIAN ASSIST VISITS 11";
label variable OBATCH11 "OFFICE-BASED PHYS ASST VISIT CHARGES 11";
label variable OBAEXP11 "TOTAL OFF-BASED PHYS ASS T EXP 11";
label variable OBASLF11 "PHYS ASS T OFF VSTS - SELF/FAMILY AMT 11";
label variable OBAMCR11 "PHYS ASS T OFF VSTS - MEDICARE AMT 11";
label variable OBAMCD11 "PHYS ASS T OFF VSTS - MEDICAID AMT 11";
label variable OBAPRV11 "PHYS ASS T OFF VSTS - PRIVATE INS AMT 11";
label variable OBAVA11 "PHYS ASS T OFF VSTS - VA/CHAMPVA AMT 11";
label variable OBATRI11 "PHYS ASS T OFF VSTS - TRICARE AMT 11";
label variable OBAOFD11 "PHYS ASS T OFF VSTS - OTHER FED AMT 11";
label variable OBASTL11 "PHYS ASS T OFF VSTS - OTH ST/LOCL AMT 11";
label variable OBAWCP11 "PHYS ASS T OFF VSTS-WORKERS COMP AMT 11";
label variable OBAOPR11 "PHYS ASS T OFF VSTS - OTH PRIVATE AMT 11";
label variable OBAOPU11 "PHYS ASS T OFF VSTS - OTH PUBLIC AMT 11";
label variable OBAOSR11 "P A OFF VSTS - OTH UNCLASS SRCE AMT 11";
label variable OBAPTR11 "PHYS ASST OFF VSTS - PRV & TRI AMT 11";
label variable OBAOTH11 "PHYS ASST OFF VSTS - OTH COMBINED AMT 11";
label variable OBTHER11 "# OFF-BASED PT/OT VISITS 11";
label variable OBTTCH11 "OFFICE-BASED PT/OC VISIT CHARGES 11";
label variable OBTEXP11 "TOT OFF-BASED PT EXP 11";
label variable OBTSLF11 "PT/OT OFF VISITS - SELF/FAMILY AMT 11";
label variable OBTMCR11 "PT/OT OFF VISITS - MEDICARE AMT 11";
label variable OBTMCD11 "PT/OT OFF VISITS - MEDICAID AMT 11";
label variable OBTPRV11 "PT/OT OFF VISITS - PRIVATE INS AMT 11";
label variable OBTVA11 "PT/OT OFF VISITS - VA/CHAMPVA AMT 11";
label variable OBTTRI11 "PT/OT OFF VISITS - TRICARE AMT 11";
label variable OBTOFD11 "PT/OT OFF VISITS - OTHER FED AMT 11";
label variable OBTSTL11 "PT/OT OFF VISITS - OTH ST/LOCL AMT 11";
label variable OBTWCP11 "PT/OT OFF VISITS - WORKERS COMP AMT 11";
label variable OBTOPR11 "PT/OT OFF VISITS - OTH PRIVATE AMT 11";
label variable OBTOPU11 "PT/OT OFF VISITS - OTH PUBLIC AMT 11";
label variable OBTOSR11 "PT/OT OFF VSTS-OTH UNCLASS SRCE AMT 11";
label variable OBTPTR11 "PT/OT OFF VISITS - PRV & TRI AMT 11";
label variable OBTOTH11 "PT/OT OFF VISITS - OTH COMBINED AMT 11";
label variable OPTOTV11 "# OUTPATIENT DEPT PROVIDER VISITS 11";
label variable OPTTCH11 "OPD FACILITY + DR VISIT CHARGES - 11";
label variable OPTEXP11 "TOTAL OUTPATIENT FAC + DR EXP 11";
label variable OPTSLF11 "ALL OPD VSTS-SELF/FAMILY AMT-(FAC+DR) 11";
label variable OPTMCR11 "ALL OPD VSTS-MEDICARE AMT-(FAC+DR) 11";
label variable OPTMCD11 "ALL OPD VSTS-MEDICAID AMT-(FAC+DR) 11";
label variable OPTPRV11 "ALL OPD VSTS-PRIV INS AMT-(FAC+DR) 11";
label variable OPTVA11 "ALL OPD VSTS-VA/CHAMPVA AMT-(FAC+DR) 11";
label variable OPTTRI11 "ALL OPD VSTS-TRICARE AMT-(FAC+DR) 11";
label variable OPTOFD11 "ALL OPD VSTS-OTHER FED AMT-(FAC+DR) 11";
label variable OPTSTL11 "ALL OPD VST-OTH ST/LOCAL AMT(FAC+DR) 11";
label variable OPTWCP11 "ALL OPD VST-WORKRS COMP AMT-(FAC+DR) 11";
label variable OPTOPR11 "ALL OPD VSTS-OTH PRIVATE AMT-(FAC+DR) 11";
label variable OPTOPU11 "ALL OPD VSTS-OTH PUBLIC AMT-(FAC+DR) 11";
label variable OPTOSR11 "ALL OPD VST-OTH UNCLS SRC AMT(FAC+DR) 11";
label variable OPTPTR11 "ALL OPD VISITS-PRV & TRI AMT (FAC+DR) 11";
label variable OPTOTH11 "ALL OPD VSTS-OTH COMBINED AMT(FAC+DR) 11";
label variable OPFTCH11 "OPD PROVIDER VISIT CHARGES - FAC 11";
label variable OPFEXP11 "TOTAL OUTPATIENT FACILITY EXP 11";
label variable OPFSLF11 "ALL OPD VISITS-SELF/FAMILY AMT-FAC 11";
label variable OPFMCR11 "ALL OPD VISITS-MEDICARE AMT-FAC 11";
label variable OPFMCD11 "ALL OPD VISITS-MEDICAID AMT-FAC 11";
label variable OPFPRV11 "ALL OPD VISITS-PRIV INS AMT-FAC 11";
label variable OPFVA11 "ALL OPD VISITS-VA/CHAMPVA AMT-FAC 11";
label variable OPFTRI11 "ALL OPD VISITS-TRICARE AMT-FAC 11";
label variable OPFOFD11 "ALL OPD VISITS-OTHER FED AMT-FAC 11";
label variable OPFSTL11 "ALL OPD VISITS-OTH ST/LOCAL AMT-FAC 11";
label variable OPFWCP11 "ALL OPD VISITS-WORKERS COMP AMT-FAC 11";
label variable OPFOPR11 "ALL OPD VISITS - OTH PRIVATE AMT-FAC 11";
label variable OPFOPU11 "ALL OPD VISITS - OTH PUBLIC AMT-FAC 11";
label variable OPFOSR11 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-FAC 11";
label variable OPFPTR11 "ALL OPD VISITS - PRV & TRI AMT-FAC 11";
label variable OPFOTH11 "ALL OPD VISITS - OTH COMBINED AMT-FAC 11";
label variable OPDEXP11 "TOTAL OUTPATIENT PROVIDER EXP 11";
label variable OPDTCH11 "OPD PROVIDER VISIT CHARGES - DR 11";
label variable OPDSLF11 "ALL OPD VISITS-SELF/FAMILY AMT-DR 11";
label variable OPDMCR11 "ALL OPD VISITS-MEDICARE AMT-DR 11";
label variable OPDMCD11 "ALL OPD VISITS-MEDICAID AMT-DR 11";
label variable OPDPRV11 "ALL OPD VISITS-PRIV INS AMT-DR 11";
label variable OPDVA11 "ALL OPD VISITS-VA/CHAMPVA AMT-DR 11";
label variable OPDTRI11 "ALL OPD VISITS-TRICARE AMT-DR 11";
label variable OPDOFD11 "ALL OPD VISITS-OTHER FED AMT-DR 11";
label variable OPDSTL11 "ALL OPD VISITS-OTH ST/LOCAL AMT-DR 11";
label variable OPDWCP11 "ALL OPD VISITS-WORKERS COMP AMT-DR 11";
label variable OPDOPR11 "ALL OPD VISITS - OTH PRIVATE AMT-DR 11";
label variable OPDOPU11 "ALL OPD VISITS-OTH PUBLIC AMT-DR 11";
label variable OPDOSR11 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-DR 11";
label variable OPDPTR11 "ALL OPD VISITS-PRV & TRI AMT -DR 11";
label variable OPDOTH11 "ALL OPD VISITS-OTH COMBINED AMT-DR 11";
label variable OPDRV11 "# OUTPATIENT DEPT PHYSICIAN VISITS 11";
label variable OPVTCH11 "OPD PHYSICIAN VISIT CHARGES - FAC 11";
label variable OPVEXP11 "TOTAL OUTPATIENT PHYSICIAN - FAC EXP 11";
label variable OPVSLF11 "OPD DR VISITS-SELF/FAMILY AMT-FAC 11";
label variable OPVMCR11 "OPD DR VISITS-MEDICARE AMT-FAC 11";
label variable OPVMCD11 "OPD DR VISITS-MEDICAID AMT-FAC 11";
label variable OPVPRV11 "OPD DR VISITS-PRIV INS AMT-FAC 11";
label variable OPVVA11 "OPD DR VISITS-VA/CHAMPVA AMT-FAC 11";
label variable OPVTRI11 "OPD DR VISITS-TRICARE AMT-FAC 11";
label variable OPVOFD11 "OPD DR VISITS-OTHER FED AMT-FAC 11";
label variable OPVSTL11 "OPD DR VISITS-OTH ST/LOCAL AMT-FAC 11";
label variable OPVWCP11 "OPD DR VISITS-WORKERS COMP AMT-FAC 11";
label variable OPVOPR11 "OPD DR VISITS - OTH PRIVATE AMT-FAC 11";
label variable OPVOPU11 "OPD DR VISITS-OTH PUBLIC AMT-FAC 11";
label variable OPVOSR11 "OPD DR VSTS-OTH UNCLASS SRCE AMT-FAC 11";
label variable OPVPTR11 "OPD DR VISITS - PRV & TRI AMT-FAC 11";
label variable OPVOTH11 "OPD DR VISITS - OTH COMBINED AMT-FAC 11";
label variable OPSEXP11 "TOTAL OUTPATIENT PHYSICIAN - DR EXP 11";
label variable OPSTCH11 "OPD PHYSICIAN VISIT CHARGES - DR 11";
label variable OPSSLF11 "OPD DR VISITS-SELF/FAMILY AMT-DR 11";
label variable OPSMCR11 "OPD DR VISITS-MEDICARE AMT-DR 11";
label variable OPSMCD11 "OPD DR VISITS-MEDICAID AMT-DR 11";
label variable OPSPRV11 "OPD DR VISITS-PRIV INS AMT-DR 11";
label variable OPSVA11 "OPD DR VISITS-VA/CHAMPVA AMT-DR 11";
label variable OPSTRI11 "OPD DR VISITS-TRICARE AMT-DR 11";
label variable OPSOFD11 "OPD DR VISITS-OTHER FED AMT-DR 11";
label variable OPSSTL11 "OPD DR VISITS-OTH ST/LOCAL AMT-DR 11";
label variable OPSWCP11 "OPD DR VISITS-WORKERS COMP AMT-DR 11";
label variable OPSOPR11 "OPD DR VISITS - OTH PRIVATE AMT-DR 11";
label variable OPSOPU11 "OPD DR VISITS-OTH PUBLIC AMT-DR 11";
label variable OPSOSR11 "OPD DR VSTS-OTH UNCLASS SRCE AMT-DR 11";
label variable OPSPTR11 "OPD DR VISITS - PRV & TRI AMT-DR 11";
label variable OPSOTH11 "OPD DR VISITS -OTH COMBINED AMT-DR 11";
label variable OPOTHV11 "# OUTPATIENT DEPT NON-DR VISITS 11";
label variable OPOTCH11 "OPD NON-PHYS VISIT CHARGES - FAC 11";
label variable OPOEXP11 "TOTAL OUTPATIENT NON-DR - FAC EXP 11";
label variable OPOSLF11 "OPD NON-DR VISITS-SELF/FAM AMT-FAC 11";
label variable OPOMCR11 "OPD NON-DR VISITS-MEDICARE AMT-FAC 11";
label variable OPOMCD11 "OPD NON-DR VISITS-MEDICAID AMT-FAC 11";
label variable OPOPRV11 "OPD NON-DR VISITS-PRIV INS AMT-FAC 11";
label variable OPOVA11 "OPD NON-DR VISITS-VA/CHAMPVA AMT-FAC 11";
label variable OPOTRI11 "OPD NON-DR VISITS-TRICARE AMT-FAC 11";
label variable OPOOFD11 "OPD NON-DR VISITS-OTHER FED AMT-FAC 11";
label variable OPOSTL11 "OPD NON-DR VISITS-OTH ST/LOC AMT-FAC 11";
label variable OPOWCP11 "OPD NON-DR VISITS-WRKRS COMP AMT-FAC 11";
label variable OPOOPR11 "OPD NON-DR VISITS-OTH PRIVATE AMT-FAC 11";
label variable OPOOPU11 "OPD NON-DR VISITS-OTH PUBLIC AMT-FAC 11";
label variable OPOOSR11 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-FAC 11";
label variable OPOPTR11 "OPD NON-DR VISITS - PRV & TRI AMT-FAC 11";
label variable OPOOTH11 "OPD NON-DR VISITS-OTH COMBINED AM-FAC 11";
label variable OPPEXP11 "TOTAL OUTPATIENT NON-DR - DR EXP 11";
label variable OPPTCH11 "OPD NON-PHYS VISIT CHARGES - DR 11";
label variable OPPSLF11 "OPD NON-DR VISITS-SELF/FAM AMT-DR 11";
label variable OPPMCR11 "OPD NON-DR VISITS-MEDICARE AMT-DR 11";
label variable OPPMCD11 "OPD NON-DR VISITS-MEDICAID AMT-DR 11";
label variable OPPPRV11 "OPD NON-DR VISITS-PRIV INS AMT-DR 11";
label variable OPPVA11 "OPD NON-DR VISITS-VA/CHAMPVA AMT-DR 11";
label variable OPPTRI11 "OPD NON-DR VISITS-TRICARE AMT-DR 11";
label variable OPPOFD11 "OPD NON-DR VISITS-OTHER FED AMT-DR 11";
label variable OPPSTL11 "OPD NON-DR VISITS-OTH ST/LOC AMT-DR 11";
label variable OPPWCP11 "OPD NON-DR VISITS-WRKRS COMP AMT-DR 11";
label variable OPPOPR11 "OPD NON-DR VISITS-OTH PRIVATE AMT-DR 11";
label variable OPPOPU11 "OPD NON-DR VISITS-OTH PUBLIC AMT-DR 11";
label variable OPPOSR11 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-DR 11";
label variable OPPPTR11 "OPD NON-DR VISITS - PRV & TRI AMT-DR 11";
label variable OPPOTH11 "OPD NON-DR VISITS-OTH COMBINED AMT-DR 11";
label variable AMCHIR11 "# CHIROPRACTR VSTS (OFF+OUTPAT), 2011";
label variable AMCTCH11 "CHIRO AMBULATORY VISIT CHARGES 11";
label variable AMCEXP11 "TOTL AMBULTRY (OB+OP) CHIRO EXP 11";
label variable AMCSLF11 "CHIRO AMB VISITS - SELF/FAMILY AMT 11";
label variable AMCMCR11 "CHIRO AMB VISITS - MEDICARE AMT 11";
label variable AMCMCD11 "CHIRO AMB VISITS - MEDICAID AMT 11";
label variable AMCPRV11 "CHIRO AMB VISITS - PRIVATE INS AMT 11";
label variable AMCVA11 "CHIRO AMB VISITS - VA/CHAMPVA AMT 11";
label variable AMCTRI11 "CHIRO AMB VISITS-TRICARE AMT 11";
label variable AMCOFD11 "CHIRO AMB VISITS - OTHER FEDERAL AMT 11";
label variable AMCSTL11 "CHIRO AMB VISITS - OTH ST/LOCAL AMT 11";
label variable AMCWCP11 "CHIRO AMB VISITS-WORKERS COMP AMT 11";
label variable AMCOPR11 "CHIRO AMB VISITS - OTH PRIVATE AMT 11";
label variable AMCOPU11 "CHIRO AMB VISITS - OTH PUBLIC AMT 11";
label variable AMCOSR11 "CHIR AMB VSTS - OTH UNCLASS SRCE AMT 11";
label variable AMCPTR11 "CHIRO AMB VISITS -PRV & TRI AMT 11";
label variable AMCOTH11 "CHIRO AMB VISITS - OTH COMBINED AMT 11";
label variable AMNURS11 "# AMB NURSE/PRCTITIONR VSTS(OB+OP) 11";
label variable AMNTCH11 "NRS/PRAC AMBULATORY VISIT CHARGES 11";
label variable AMNEXP11 "TOTL AMBULTRY (OB+OP) NURSE/PRAC EXP 11";
label variable AMNSLF11 "NRS/PRAC AMB VSTS - SELF/FAMILY AMT 11";
label variable AMNMCR11 "NRS/PRAC AMB VSTS - MEDICARE AMT 11";
label variable AMNMCD11 "NRS/PRAC AMB VSTS - MEDICAID AMT 11";
label variable AMNPRV11 "NRS/PRAC AMB VSTS - PRIV INS AMT 11";
label variable AMNVA11 "NRS/PRAC AMB VSTS-VA/CHAMPVA AMT 11";
label variable AMNTRI11 "NRS/PRAC AMB VSTS-TRICARE AMT 11";
label variable AMNOFD11 "NRS/PRAC AMB VSTS-OTHER FEDERAL AMT 11";
label variable AMNSTL11 "NRS/PRAC AMB VSTS-OTH ST/LOCAL AMT 11";
label variable AMNWCP11 "NRS/PRAC AMB VSTS-WORKERS COMP AMT 11";
label variable AMNOPR11 "NRS/PRAC AMB VSTS - OTH PRIVATE AMT 11";
label variable AMNOPU11 "NRS/PRAC AMB VSTS - OTH PUBLIC AMT 11";
label variable AMNOSR11 "NRS/PR AMB VSTS - OTH UNCLAS SRCE AMT 11";
label variable AMNPTR11 "NRS/PRAC AMB VSTS - PRV & TRI AMT 11";
label variable AMNOTH11 "NRS/PRAC AMB VSTS - OTH COMBINED AMT 11";
label variable AMOPTO11 "# AMB OPTOMETRIST VSTS (OB+OP) 11";
label variable AMETCH11 "OPTOMETRIST AMBULATORY VISIT CHARGES 11";
label variable AMEEXP11 "TOTL AMBULTRY (OB+OP) OPTOMETRIST EXP 11";
label variable AMESLF11 "OPTMTRIST AMB VSTS - SELF/FAMILY AMT 11";
label variable AMEMCR11 "OPTMTRIST AMB VSTS - MEDICARE AMT 11";
label variable AMEMCD11 "OPTMTRIST AMB VSTS - MEDICAID AMT 11";
label variable AMEPRV11 "OPTMTRIST AMB VSTS - PRIVATE INS AMT 11";
label variable AMEVA11 "OPTMTRIST AMB VSTS-VA/CHAMPVA AMT 11";
label variable AMETRI11 "OPTMTRIST AMB VSTS-TRICARE AMT 11";
label variable AMEOFD11 "OPTMTRIST AMB VSTS-OTHER FED AMT 11";
label variable AMESTL11 "OPTMTRIST AMB VSTS-OTH ST/LOCAL AMT 11";
label variable AMEWCP11 "OPTMTRIST AMB VSTS-WORKERS COMP AMT 11";
label variable AMEOPR11 "OPTMTRIST AMB VSTS - OTH PRIVATE AMT 11";
label variable AMEOPU11 "OPTMTRIST AMB VSTS - OTH PUBLIC AMT 11";
label variable AMEOSR11 "OPTOM AMB VSTS - OTH UNCLAS SRCE AMT 11";
label variable AMEPTR11 "OPTMTRIST AMB VSTS - PRV & TRI AMT 11";
label variable AMEOTH11 "OPTMTRIST AMB VSTS - OTH COMBINED AMT 11";
label variable AMASST11 "# PHYSICIAN ASS T VSTS (OFF+OUPAT), 2011";
label variable AMATCH11 "PHYS ASS T AMBULATORY VISIT CHARGES 11";
label variable AMAEXP11 "TOTL AMBULTRY (OB+OP) PHYS ASS T EXP 11";
label variable AMASLF11 "PHYS ASS T AMB VSTS-SELF/FAMILY AMT 11";
label variable AMAMCR11 "PHYS ASS T AMB VSTS-MEDICARE AMT 11";
label variable AMAMCD11 "PHYS ASS T AMB VSTS-MEDICAID AMT 11";
label variable AMAPRV11 "PHYS ASS T AMB VSTS-PRIVATE INS AMT 11";
label variable AMAVA11 "PHYS ASS T AMB VSTS-VA/CHAMPVA AMT 11";
label variable AMATRI11 "PHYS ASS T AMB VSTS-TRICARE AMT 11";
label variable AMAOFD11 "PHYS ASS T AMB VSTS - OTHER FED AMT 11";
label variable AMASTL11 "PHYS ASS T AMB VSTS-OTH ST/LOCL AMT 11";
label variable AMAWCP11 "PHYS ASS T AMB VSTS-WRKERS COMP AMT 11";
label variable AMAOPR11 "PHYS ASS T AMB VSTS - OTH PRIVATE AMT 11";
label variable AMAOPU11 "PHYS ASS T AMB VSTS - OTH PUBLIC AMT 11";
label variable AMAOSR11 "P A AMB VSTS - OTH UNCLASS SRCE AMT 11";
label variable AMAPTR11 "PHYS ASS T AMB VSTS - PRV & TRI AMT 11";
label variable AMAOTH11 "PHYS ASS T AMB VSTS-OTH COMBINED AMT 11";
label variable AMTHER11 "# AMB PT/OT THRPY VISITS (OB+OP) 11";
label variable AMTTCH11 "PT/OC AMBULATORY VISIT CHARGES 11";
label variable AMTEXP11 "TOTL AMBULTRY (OB+OP) PT/OT EXP 11";
label variable AMTSLF11 "PT/OT AMB VISITS-SELF/FAMILY AMT 11";
label variable AMTMCR11 "PT/OT AMB VISITS-MEDICARE AMT 11";
label variable AMTMCD11 "PT/OT AMB VISITS-MEDICAID AMT 11";
label variable AMTPRV11 "PT/OT AMB VISITS-PRIVATE INS AMT 11";
label variable AMTVA11 "PT/OT AMB VISITS-VA/CHAMPVA AMT 11";
label variable AMTTRI11 "PT/OT AMB VISITS-TRICARE AMT 11";
label variable AMTOFD11 "PT/OT AMB VISITS - OTHER FED AMT 11";
label variable AMTSTL11 "PT/OT AMB VISITS-OTH ST/LOCL AMT 11";
label variable AMTWCP11 "PT/OT AMB VISITS-WORKERS COMP AMT 11";
label variable AMTOPR11 "PT/OT AMB VISITS - OTH PRIVATE AMT 11";
label variable AMTOPU11 "PT/OT AMB VISITS-OTH PUBLIC AMT 11";
label variable AMTOSR11 "PT/OT AMB VSTS-OTH UNCLAS SRCE AMT 11";
label variable AMTPTR11 "PT/OT AMB VISITS -PRV & TRI AMT 11";
label variable AMTOTH11 "PT/OT AMB VISITS - OTH COMBINED AMT 11";
label variable AMTOTC11 "# CALLS W/OFFICE & OUPAT DEPTS, 2011";
label variable AMDRC11 "# CALLS W/OFF & OUTPAT PHYSICIANS, 2011";
label variable ERTOT11 "# EMERGENCY ROOM VISITS 11";
label variable ERTTCH11 "ER FACILITY + DR VISIT CHARGES 11";
label variable ERTEXP11 "TOTAL ER FACILITY + DR EXP 11";
label variable ERTSLF11 "ER-SELF/FAMILY AMT-(FAC+DR) 11";
label variable ERTMCR11 "ER-MEDICARE AMT-(FAC+DR) 11";
label variable ERTMCD11 "ER-MEDICAID AMT-(FAC+DR) 11";
label variable ERTPRV11 "ER-PRIV INS AMT-(FAC+DR) 11";
label variable ERTVA11 "ER-VA/CHAMPVA AMT-(FAC+DR) 11";
label variable ERTTRI11 "ER-TRICARE AMT-(FAC+DR) 11";
label variable ERTOFD11 "ER-OTHER FED AMT-(FAC+DR) 11";
label variable ERTSTL11 "ER-OTH ST/LOCAL AMT-(FAC+DR) 11";
label variable ERTWCP11 "ER-WORKERS COMP AMT-(FAC+DR) 11";
label variable ERTOPR11 "ER-OTH PRIVATE AMT-(FAC+DR) 11";
label variable ERTOPU11 "ER-OTH PUBLIC AMT-(FAC+DR) 11";
label variable ERTOSR11 "ER-OTH UNCLASS SRCE AMT-(FAC+DR) 11";
label variable ERTPTR11 "ER-PRV & TRI AMT (FAC+DR) 11";
label variable ERTOTH11 "ER -OTH COMBINED AMT (FAC+DR) 11";
label variable ERFTCH11 "ER FACILITY VISIT CHARGES 11";
label variable ERFEXP11 "TOTAL ER FACILITY EXP 11";
label variable ERFSLF11 "ER-SELF/FAMILY AMT - FAC 11";
label variable ERFMCR11 "ER-MEDICARE AMT - FAC 11";
label variable ERFMCD11 "ER-MEDICAID AMT - FAC 11";
label variable ERFPRV11 "ER-PRIVATE INS AMT - FAC 11";
label variable ERFVA11 "ER-VA/CHAMPVA AMT - FAC 11";
label variable ERFTRI11 "ER-TRICARE AMT - FAC 11";
label variable ERFOFD11 "ER-OTHER FEDERAL AMT - FAC 11";
label variable ERFSTL11 "ER-OTH ST/LOCAL AMT - FAC 11";
label variable ERFWCP11 "ER-WORKERS COMP AMT - FAC 11";
label variable ERFOPR11 "ER-OTHER PRIVATE AMT - FAC 11";
label variable ERFOPU11 "ER-OTHER PUBLIC AMT - FAC 11";
label variable ERFOSR11 "ER-OTH UNCLASS SRCE AMT - FAC 11";
label variable ERFPTR11 "ER-PRV & TRI AMT - FAC 11";
label variable ERFOTH11 "ER-OTH COMBINED AMT - FAC 11";
label variable ERDEXP11 "TOTAL EMERGENCY ROOM DR EXP 11";
label variable ERDTCH11 "ER DOCTOR VISIT CHARGES 11";
label variable ERDSLF11 "ER-SELF/FAMILY AMT - DR 11";
label variable ERDMCR11 "ER-MEDICARE AMT - DR 11";
label variable ERDMCD11 "ER-MEDICAID AMT - DR 11";
label variable ERDPRV11 "ER-PRIVATE INS AMT - DR 11";
label variable ERDVA11 "ER-VA/CHAMPVA AMT - DR 11";
label variable ERDTRI11 "ER-TRICARE AMT - DR 11";
label variable ERDOFD11 "ER-OTHER FED AMT - DR 11";
label variable ERDSTL11 "ER-OTH ST/LOCAL AMT - DR 11";
label variable ERDWCP11 "ER-WORKERS COMP AMT - DR 11";
label variable ERDOPR11 "ER - OTHER PRIVATE AMT - DR 11";
label variable ERDOPU11 "ER - OTHER PUBLIC AMT - DR 11";
label variable ERDOSR11 "ER-OTH UNCLASS SRCE AMT - DR 11";
label variable ERDPTR11 "ER-PRV & TRI AMT - DR 11";
label variable ERDOTH11 "ER-OTH COMBINED AMT - DR 11";
label variable IPZERO11 "# ZERO-NIGHT HOSPITAL STAYS 11";
label variable ZIFTCH11 "ZERO-NITE IP STAY CHARGES - FAC 11";
label variable ZIFEXP11 "TOTAL ZERO-NITE STAYS FAC EXP 11";
label variable ZIFSLF11 "ZERO-NITE IP STAZ-SELF/FAM AMT-FAC 11";
label variable ZIFMCR11 "ZERO-NITE IP STAZ-MEDICARE AMT-FAC 11";
label variable ZIFMCD11 "ZERO-NITE IP STAZ-MEDICAID AMT-FAC 11";
label variable ZIFPRV11 "ZERO-NITE IP STAZ-PRIV INS AMT-FAC 11";
label variable ZIFVA11 "ZERO-NITE IP STAZ-VA/CHAMPVA AMT-FAC 11";
label variable ZIFTRI11 "ZERO-NITE IP STAZ-TRICARE AMT-FAC 11";
label variable ZIFOFD11 "ZERO-NITE IP STAZ-OTHER FED AMT-FAC 11";
label variable ZIFSTL11 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-FAC 11";
label variable ZIFWCP11 "ZERO-NITE IP STAZ-WRKERS COMP AMT-FAC 11";
label variable ZIFOPR11 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-FAC 11";
label variable ZIFOPU11 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-FAC 11";
label variable ZIFOSR11 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-FAC 11";
label variable ZIFPTR11 "ZERO-NITE IP STAZ-PRV & TRI AMT-FAC 11";
label variable ZIFOTH11 "ZERO-NITE IP STAZ-OTH COMBINE AMT-FAC 11";
label variable ZIDEXP11 "TOTAL ZERO-NITE STAZ DR 11";
label variable ZIDTCH11 "ZERO-NITE IP STAY CHARGES - DR 11";
label variable ZIDSLF11 "ZERO-NITE IP STAZ-SELF/FAM AMT-DR 11";
label variable ZIDMCR11 "ZERO-NITE IP STAZ-MEDICARE AMT-DR 11";
label variable ZIDMCD11 "ZERO-NITE IP STAZ-MEDICAID AMT-DR 11";
label variable ZIDPRV11 "ZERO-NITE IP STAZ-PRIV INS AMT-DR 11";
label variable ZIDVA11 "ZERO-NITE IP STAZ-VA/CHAMPVA AMT-DR 11";
label variable ZIDTRI11 "ZERO-NITE IP STAZ-TRICARE AMT-DR 11";
label variable ZIDOFD11 "ZERO-NITE IP STAZ-OTHER FED AMT-DR 11";
label variable ZIDSTL11 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-DR 11";
label variable ZIDWCP11 "ZERO-NITE IP STAZ-WRKERS COMP AMT-DR 11";
label variable ZIDOPR11 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-DR 11";
label variable ZIDOPU11 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-DR 11";
label variable ZIDOSR11 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-DR 11";
label variable ZIDPTR11 "ZERO-NITE IP STAZ-PRV & TRI AMT-DR 11";
label variable ZIDOTH11 "ZERO-NITE IP STAZ-OTH COMBINED AMT-DR 11";
label variable IPDIS11 "# HOSPITAL DISCHARGES, 2011";
label variable IPTEXP11 "TOT HOSP IP FACILITY + DR EXP 11";
label variable IPTTCH11 "IP HOSP STAY CHARGES (FAC+DR) 11";
label variable IPTSLF11 "IP HOSP STAZ-SELF/FAMILY AMT-(FAC+DR) 11";
label variable IPTMCR11 "IP HOSP STAZ-MEDICARE AMT-(FAC+DR) 11";
label variable IPTMCD11 "IP HOSP STAZ-MEDICAID AMT-(FAC+DR) 11";
label variable IPTPRV11 "IP HOSP STAZ-PRIV INS AMT-(FAC+DR) 11";
label variable IPTVA11 "IP HOSP STAZ-VA/CHAMPVA AMT-(FAC+DR) 11";
label variable IPTTRI11 "IP HOSP STAZ-TRICARE AMT-(FAC+DR) 11";
label variable IPTOFD11 "IP HOSP STAZ-OTHER FED AMT-(FAC+DR) 11";
label variable IPTSTL11 "IP HSP STAZ-OTH ST/LOCAL AMT-(FAC+DR) 11";
label variable IPTWCP11 "IP HOSP STAZ-WRKRS COMP AMT-(FAC+DR) 11";
label variable IPTOPR11 "IP HOSP STAZ-OTH PRIVATE AMT-(FAC+DR) 11";
label variable IPTOPU11 "IP HOSP STAZ-OTH PUBLIC AMT-(FAC+DR) 11";
label variable IPTOSR11 "IP HSP STAZ-OTH UNCLS SRC AMT(FAC+DR) 11";
label variable IPTPTR11 "IP HOSP STAZ-PRV & TRI AMT-(FAC+DR) 11";
label variable IPTOTH11 "IP HOSP STAZ-OTH COMBINED AMT(FAC+DR) 11";
label variable IPFEXP11 "TOT HOSP IP FACILITY EXP-INC 0 NITES 11";
label variable IPFTCH11 "IP HOSP STAY CHARGES - FAC 11";
label variable IPFSLF11 "IP HOSP STAZ-SELF/FAMILY AMT-FAC 11";
label variable IPFMCR11 "IP HOSP STAZ-MEDICARE AMT-FAC 11";
label variable IPFMCD11 "IP HOSP STAZ-MEDICAID AMT-FAC 11";
label variable IPFPRV11 "IP HOSP STAZ-PRIV INS AMT-FAC 11";
label variable IPFVA11 "IP HOSP STAZ-VA/CHAMPVA AMT-FAC 11";
label variable IPFTRI11 "IP HOSP STAZ-TRICARE AMT-FAC 11";
label variable IPFOFD11 "IP HOSP STAZ-OTHER FED AMT-FAC 11";
label variable IPFSTL11 "IP HOSP STAZ-OTH ST/LOCAL AMT-FAC 11";
label variable IPFWCP11 "IP HOSP STAZ-WORKERS COMP AMT-FAC 11";
label variable IPFOPR11 "IP HOSP STAZ - OTH PRIVATE AMT-FAC 11";
label variable IPFOPU11 "IP HOSP STAZ - OTH PUBLIC AMT-FAC 11";
label variable IPFOSR11 "IP HOSP STAZ-OT UNCLASS SRCE AMT-FAC 11";
label variable IPFPTR11 "IP HOSP STAZ-PRV & TRI AMT-FAC 11";
label variable IPFOTH11 "IP HOSP STAZ-OTH COMBINED AMT-FAC 11";
label variable IPDEXP11 "TOTL HOSP STAZ DR EXP 11";
label variable IPDTCH11 "IP HOSP STAY CHARGES - DR 11";
label variable IPDSLF11 "IP HOSP STAZ-SELF/FAMILY AMT-DR 11";
label variable IPDMCR11 "IP HOSP STAZ-MEDICARE AMT- DR 11";
label variable IPDMCD11 "IP HOSP STAZ-MEDICAID AMT-DR 11";
label variable IPDPRV11 "IP HOSP STAZ-PRIV INS AMT-DR 11";
label variable IPDVA11 "IP HOSP STAZ-VA/CHAMPVA AMT-DR 11";
label variable IPDTRI11 "IP HOSP STAZ-TRICARE AMT-DR 11";
label variable IPDOFD11 "IP HOSP STAZ-OTHER FED AMT-DR 11";
label variable IPDSTL11 "IP HOSP STAZ-OTH ST/LOCAL AMT-DR 11";
label variable IPDWCP11 "IP HOSP STAZ-WORKERS COMP AMT-DR 11";
label variable IPDOPR11 "IP HOSP STAZ - OTH PRIVATE AMT-DR 11";
label variable IPDOPU11 "IP HOSP STAZ - OTH PUBLIC AMT-DR 11";
label variable IPDOSR11 "IP HOSP STAZ-OT UNCLASS SORCE AMT-DR 11";
label variable IPDPTR11 "IP HOSP STAZ-PRV & TRI AMT-DR 11";
label variable IPDOTH11 "IP HOSP STAZ-OTH COMBINED AMT-DR 11";
label variable IPNGTD11 "# NIGHTS IN HOSP FOR DISCHARGES, 2011";
label variable DVTOT11 "# DENTAL CARE VISITS 11";
label variable DVTTCH11 "TOTAL DENTAL CARE VISIT CHARGES 11";
label variable DVTEXP11 "TOTAL DENTAL CARE EXP 11";
label variable DVTSLF11 "ALL DENTAL CARE - SELF/FAMILY AMT 11";
label variable DVTMCR11 "ALL DENTAL CARE - MEDICARE AMT 11";
label variable DVTMCD11 "ALL DENTAL CARE - MEDICAID AMT 11";
label variable DVTPRV11 "ALL DENTAL CARE - PRIVATE INS AMT 11";
label variable DVTVA11 "ALL DENTAL CARE - VA/CHAMPVA AMT 11";
label variable DVTTRI11 "ALL DENTAL CARE - TRICARE AMT 11";
label variable DVTOFD11 "ALL DENTAL CARE - OTHER FEDRL AMT 11";
label variable DVTSTL11 "ALL DENTAL CARE - OTH ST/LOCAL AMT 11";
label variable DVTWCP11 "ALL DENTAL CARE - WORKERS COMP AMT 11";
label variable DVTOPR11 "ALL DENTAL CARE - OTH PRIVATE AMT 11";
label variable DVTOPU11 "ALL DENTAL CARE - OTH PUBLIC AMT 11";
label variable DVTOSR11 "ALL DENT CARE-OT UNCLASS SRCE AMT 11";
label variable DVTPTR11 "ALL DENTAL CARE - PRV & TRI AMT 11";
label variable DVTOTH11 "ALL DENTAL CARE - OTH COMBINED AMT 11";
label variable DVGEN11 "# GENERAL DENTIST VISITS 11";
label variable DVGTCH11 "GENERAL DENTAL CARE VISIT CHARGES 11";
label variable DVGEXP11 "TOTAL GENERAL DENTIST EXP 11";
label variable DVGSLF11 "GNRL DENTAL VISITS - SELF/FAM AMT 11";
label variable DVGMCR11 "GNRL DENTAL VISITS - MEDICARE AMT 11";
label variable DVGMCD11 "GNRL DENTAL VISITS - MEDICAID AMT 11";
label variable DVGPRV11 "GNRL DENTAL VISITS - PRIVATE INS AMT 11";
label variable DVGVA11 "GNRL DENTAL VISITS - VA/CHAMPVA AMT 11";
label variable DVGTRI11 "GNRL DENTAL VISITS-TRICARE AMT 11";
label variable DVGOFD11 "GNRL DENTAL VISITS - OTHER FED AMT 11";
label variable DVGSTL11 "GNRL DENTAL VISITS - OTH ST/LOCAL AMT 11";
label variable DVGWCP11 "GNRL DENTAL VISITS - WORKERS COMP AMT 11";
label variable DVGOPR11 "GNRL DENTAL VISITS - OTH PRIVATE AMT 11";
label variable DVGOPU11 "GNRL DENTAL VISITS - OTH PUBLIC AMT 11";
label variable DVGOSR11 "GNRL DENT VSTS - OT UNCLASS SRCE AMT 11";
label variable DVGPTR11 "GNRL DENTAL VISITS - PRV & TRI AMT 11";
label variable DVGOTH11 "GNRL DENTAL VISITS - OTH COMBINED AMT 11";
label variable DVORTH11 "# ORTHODONTIST VISITS 11";
label variable DVOTCH11 "ORTHODONTIST VISIT CHARGES 11";
label variable DVOEXP11 "TOTAL ORTHODONTIST EXP 11";
label variable DVOSLF11 "ORTHODONTIST VISITS - SELF/FAMILY AMT 11";
label variable DVOMCR11 "ORTHODONTIST VISITS - MEDICARE AMT 11";
label variable DVOMCD11 "ORTHODONTIST VISITS - MEDICAID AMT 11";
label variable DVOPRV11 "ORTHODONTIST VISITS - PRIVATE INS AMT 11";
label variable DVOVA11 "ORTHODONTIST VISITS-VA/CHAMPVA AMT 11";
label variable DVOTRI11 "ORTHODONTIST VISITS-TRICARE AMT 11";
label variable DVOOFD11 "ORTHODONTIST VISITS-OTHR FED AMT 11";
label variable DVOSTL11 "ORTHODONTIST VISITS-OTHR ST/LOCAL AMT 11";
label variable DVOWCP11 "ORTHODONTIST VISITS-WORKERS COMP AMT 11";
label variable DVOOPR11 "ORTHODONTIST VISITS-OTHR PRIVATE AMT 11";
label variable DVOOPU11 "ORTHODONTIST VISITS-OTHR PUBLIC AMT 11";
label variable DVOOSR11 "ORTHODONT VSTS - OT UNCLASS SRCE AMT 11";
label variable DVOPTR11 "ORTHODONTIST VISITS - PRV & TRI AMT 11";
label variable DVOOTH11 "ORTHODONTIST VISITS-OTH COMBINED AMT 11";
label variable HHTOTD11 "# HOME HEALTH PROVIDER DAYS, 2011";
label variable HHAGD11 "# AGENCY HOME HEALTH PROVIDER DAYS 11";
label variable HHATCH11 "HOME HEALTH AGENCY VISIT CHARGES 11";
label variable HHAEXP11 "TOTAL HOME HEALTH AGENCY EXP 11";
label variable HHASLF11 "HOME HLTH AGENCY - SELF/FAMILY AMT 11";
label variable HHAMCR11 "HOME HLTH AGENCY - MEDICARE AMT 11";
label variable HHAMCD11 "HOME HLTH AGENCY - MEDICAID AMT 11";
label variable HHAPRV11 "HOME HLTH AGENCY - PRIVATE INS AMT 11";
label variable HHAVA11 "HOME HLTH AGENCY-VA/CHAMPVA AMT 11";
label variable HHATRI11 "HOME HLTH AGENCY-TRICARE AMT 11";
label variable HHAOFD11 "HOME HLTH AGENCY - OTHER FED AMT 11";
label variable HHASTL11 "HOME HLTH AGENCY-OTHR ST/LOCAL AMT 11";
label variable HHAWCP11 "HOME HLTH AGENCY - WORKERS COMP AMT 11";
label variable HHAOPR11 "HOME HLTH AGENCY - OTH PRIVATE AMT 11";
label variable HHAOPU11 "HOME HLTH AGENCY - OTH PUBLIC AMT 11";
label variable HHAOSR11 "H HLTH AGENCY - OT UNCLASS SRCE AMT 11";
label variable HHAPTR11 "HOME HLTH AGENCY - PRV & TRI AMT 11";
label variable HHAOTH11 "HOME HLTH AGENCY - OTH COMBINED AMT 11";
label variable HHINDD11 "# NON-AGENCY HOME HEALTH PROVIDR DAYS 11";
label variable HHNTCH11 "HOME HEALTH NON-AGENCY VISIT CHARGES 11";
label variable HHNEXP11 "TOTAL HOME HEALTH NON-AGNCY EXP 11";
label variable HHNSLF11 "HOME HLTH NON-AGNCY - SELF/FAM AMT 11";
label variable HHNMCD11 "HOME HLTH NON-AGNCY - MEDICAID AMT 11";
label variable HHNMCR11 "HOME HLTH NON-AGNCY - MEDICARE AMT 11";
label variable HHNPRV11 "HOME HLTH NON-AGNCY - PRIV INS AMT 11";
label variable HHNVA11 "HOME HLTH NON-AGNCY-VA/CHAMPVA AMT 11";
label variable HHNTRI11 "HOME HLTH NON-AGNCY-TRICARE AMT 11";
label variable HHNOFD11 "HOME HLTH NON-AGNCY-OTHR FED AMT 11";
label variable HHNSTL11 "HOME HLTH NON-AGNCY-OTHR ST/LOCL AMT 11";
label variable HHNWCP11 "HOME HLTH NON-AGNCY-WORKERS COMP AMT 11";
label variable HHNOPR11 "HOME HLTH NON-AGNCY-OTH PRIVATE AMT 11";
label variable HHNOPU11 "HOME HLTH NON-AGNCY-OTH PUBLIC AMT 11";
label variable HHNOSR11 "H HLTH NON-AGNCY-OT UNCLASS SRCE AMT 11";
label variable HHNPTR11 "HOME HLTH NON-AGNCY - PRV & TRI AMT 11";
label variable HHNOTH11 "HOME HLTH NON-AGNCY-OTH COMBINED AMT 11";
label variable HHINFD11 "# INFORMAL HOME HEALTH PROVIDER DAYS 11";
label variable VISEXP11 "TOTAL GLASSES/CONTACT LENS EXP 11";
label variable VISTCH11 "GLASSES/CONTACT LENSES CHARGES 11";
label variable VISSLF11 "GLASSES/CNTCT LENSES -SELF/FAM AMT 11";
label variable VISMCR11 "GLASSES/CNTCT LENSES-MEDICARE AMT 11";
label variable VISMCD11 "GLASSES/CNTCT LENSES-MEDICAID AMT 11";
label variable VISPRV11 "GLASSES/CNTCT LENSES-PRIV INS AMT 11";
label variable VISVA11 "GLASSES/CNTCT LENSES-VA/CHAMPVA AMT 11";
label variable VISTRI11 "GLASSES/LENSES-TRICARE AMT 11";
label variable VISOFD11 "GLASSES/CNTCT LENSES-OTHR FED AMT 11";
label variable VISSTL11 "GLASSES/CNTCT LENSES-OTH ST/LOCL AMT 11";
label variable VISWCP11 "GLASSES/CNTCT LENSES-WORKERS COMP AMT 11";
label variable VISOPR11 "GLASSES/CNTCT LENSES-OTH PRIVATE AMT 11";
label variable VISOPU11 "GLASSES/CNTCT LENSES-OTH PUBLIC AMT 11";
label variable VISOSR11 "GLASES/CNTCT LENSE-OT UNCLAS SRCE AMT 11";
label variable VISPTR11 "GLASSES/CNTCT LENSES-PRV & TRI AMT 11";
label variable VISOTH11 "GLASSES/CNTCT LENSES-OTH COMBINED AMT 11";
label variable OTHTCH11 "OTHER EQUP/SUPPLIES CHARGES 11";
label variable OTHEXP11 "TOT OTHER EQUIP/SPLY (EXCL DIAB) EXP 11";
label variable OTHSLF11 "OTHER EQUP/SUPPLIES-SELF/FAM AMT 11";
label variable OTHMCR11 "OTHER EQUP/SUPPLIES-MEDICARE AMT 11";
label variable OTHMCD11 "OTHER EQUP/SUPPLIES-MEDICAID AMT 11";
label variable OTHPRV11 "OTHER EQUP/SUPPLIES-PRIV INS AMT 11";
label variable OTHVA11 "OTHER EQUP/SUPPLY-VA/CHAMPVA AMT 11";
label variable OTHTRI11 "OTHER EQUP/SUPPLY-TRICARE AMT 11";
label variable OTHOFD11 "OTHER EQUP/SUPPLIES-OTHR FEDRL AMT 11";
label variable OTHSTL11 "OTHER EQUP/SUPPLY-OTHR ST/LOCAL AMT 11";
label variable OTHWCP11 "OTHER EQUP/SUPPLY - WORKERS COMP AMT 11";
label variable OTHOPR11 "OTHER EQUP/SUPPLY-OTH PRIVATE AMT 11";
label variable OTHOPU11 "OTHER EQUP/SUPPLY - OTH PUBLIC AMT 11";
label variable OTHOSR11 "OTH EQUP/SUPLY - OT UNCLASS SRCE AMT 11";
label variable OTHPTR11 "OTHER EQUP/SUPPLY - PRV & TRI AMT 11";
label variable OTHOTH11 "OTHER EQUP/SUPPLY - OTH COMBINED AMT 11";
label variable RXTOT11 "# PRESC MEDS INCL REFILLS 11";
label variable RXEXP11 "TOTAL RX-EXP 11";
label variable RXSLF11 "TOTAL RX-SELF/FAMILY AMT 11";
label variable RXMCR11 "TOTAL RX-MEDICARE AMT 11";
label variable RXMCD11 "TOTAL RX-MEDICAID AMT 11";
label variable RXPRV11 "TOTAL RX-PRIVATE INS AMT 11";
label variable RXVA11 "TOTAL RX-VA/CHAMPVA AMT 11";
label variable RXTRI11 "TOTAL RX-TRICARE AMT 11";
label variable RXOFD11 "TOTAL RX-OTHER FED AMT 11";
label variable RXSTL11 "TOTAL RX-OTHER ST/LOCAL AMT 11";
label variable RXWCP11 "TOTAL RX-WORKERS COMP AMT 11";
label variable RXOPR11 "TOTAL RX-OTH PRIVATE AMT 11";
label variable RXOPU11 "TOTAL RX-OTH PUBLIC AMT 11";
label variable RXOSR11 "TOT RX-OTH UNCLASS SRCE AMT 11";
label variable RXPTR11 "TOTAL RX-PRV & TRI AMT 11";
label variable RXOTH11 "TOTAL RX-OTH COMBINED AMT 11";
label variable PERWT11F "FINAL PERSON WEIGHT, 2011";
label variable FAMWT11F "FINAL FAMILY WEIGHT, 2011";
label variable FAMWT11C "POV ADJ FAMILY WGT-CPS FAM ON 12/31/11";
label variable SAQWT11F "FINAL SAQ PERSON WEIGHT, 2011";
label variable DIABW11F "FINAL DIABETES CARE SUPPLEMENT WEIGHT";
label variable CSAQW11F "FINAL CANCER SAQ PERSON WEIGHT - 2011";
label variable VARSTR "VARIANCE ESTIMATION STRATUM - 2011";
label variable VARPSU "VARIANCE ESTIMATION PSU - 2011";


*DEFINE VALUE LABELS FOR REPORTS;
label define H1470001X
         -1 "-1 INAPPLICABLE"
         1 "1 YES" ;

label define H1470002X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1470003X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1470004X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1470005X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470006X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470007X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H1470008X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1470009X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H1470010X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470011X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470012X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470013X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H1470014X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1470015X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H1470016X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470017X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1470018X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1470019X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1470020X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1470021X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470022X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1470023X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1470024X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470025X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470026X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H1470027X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1470028X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470029X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1470030X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1470031X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1470032X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470033X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H1470034X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470035X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470036X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470037X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH VERSION SAQ WAS ADMINISTERED"
         2 "2 SPANISH VERSION SAQ WAS ADMINISTERED" ;

label define H1470038X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470039X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470040X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470041X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1470042X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1470043X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1470044X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470045X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1470046X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1470047X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 HAD NO VISITS IN THE LAST 12 MONTHS" ;

label define H1470048X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1470049X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT AT ALL"
         2 "2 A LITTLE BIT"
         3 "3 MODERATELY"
         4 "4 QUITE A BIT"
         5 "5 EXTREMELY" ;

label define H1470050X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1470051X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1470052X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF-ADMINISTERED"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         100 "100 INTERVIEWER ADMINISTERED"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP - /HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 PARTNER'S DAUGHTER"
         33 "33 PARTNER'S SON"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP - /HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 PARENT"
         48 "48 GRANDPARENT"
         49 "49 NOT PERSON ON SAQ LABEL,RELATIONSHIP UNK"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1470053X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1470054X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1470055X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1470056X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1470057X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470058X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1470059X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1470060X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470061X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1470062X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470063X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1470064X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1470065X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1470066X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1470067X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AFDC"
         2 "2 NOT AFDC" ;

label define H1470068X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1470069X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470070X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470071X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1470072X
         0 "0.00"
         393 "$1 - $393" ;

label define H1470073X
         0 "0.00"
         273 "$1 - $273" ;

label define H1470074X
         0 "0.00"
         8239 "$1 - $8,239" ;

label define H1470075X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470076X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470077X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470078X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 NO VISITS IN LAST 12 MONTHS" ;

label define H1470079X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 NO VISITS IN LAST 12 MONTHS" ;

label define H1470080X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470081X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470082X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470083X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470084X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 RHEUMATOID ARTHRITIS"
         2 "2 OSTEOARTHRITIS"
         3 "3 NOT SPECIFIED" ;

label define H1470085X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470086X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470087X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470088X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470089X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470090X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470091X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470092X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470093X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470094X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470095X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470096X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470097X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470098X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470099X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST 2 YEARS"
         2 "2 WITHIN PAST 3 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H1470100X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9  NOT ASCERTAINED"
         1 "1 WITHIN PAST 2 YEARS"
         2 "2 WITHIN PAST 3 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H1470101X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN LAST 7 DAYS"
         2 "2 MORE THAN 7, BUT WITHIN LAST 30 DAYS"
         3 "3 MORE THAN 30 DAYS AGO" ;

label define H1470102X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470103X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470104X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470105X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1470106X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1470107X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1470108X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2010 "2010 YEAR"
         2011 "2011 YEAR" ;

label define H1470109X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2011 "2011 YEAR" ;

label define H1470110X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2011 "2011 YEAR"
         2012 "2012 YEAR" ;

label define H1470111X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1470112X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1470113X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470114X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470115X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470116X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470117X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470118X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470119X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470120X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470121X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470122X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470123X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1470124X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470125X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470126X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470127X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470128X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470129X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1470130X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470131X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1470132X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1470133X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1470134X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PART OF A ROUTINE EXAM"
         2 "2 BECAUSE OF A PROBLEM"
         3 "3 SOME OTHER REASON" ;

label define H1470135X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 WITHIN PAST 10 YEARS"
         6 "6 MORE THAN 10 YEARS"
         7 "7 NEVER" ;

label define H1470136X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1470137X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470138X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470139X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470140X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470141X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470142X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470143X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470144X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470145X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470146X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470147X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470148X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470149X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470150X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470151X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470152X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470153X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470154X
         -1 "-1  INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470155X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470156X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470157X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470158X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470159X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470160X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470161X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470162X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470163X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470164X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470165X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470166X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470167X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470168X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470169X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470170X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470171X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470172X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470173X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470174X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470175X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470176X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470177X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470178X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470179X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 RARELY"
         3 "3 SOMETIMES"
         4 "4 OFTEN"
         5 "5 ALL THE TIME" ;

label define H1470180X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470181X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470182X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 6 MONTHS"
         2 "2 6 MONTHS TO LESS THAN 1 YEAR"
         3 "3 1 YEAR TO LESS THAN 3 YEARS"
         4 "4 3 YEARS TO LESS THAN 5 YEARS"
         5 "5 5 YEARS TO LESS THAN 10 YEARS"
         6 "6 MORE THAN 10 YEARS" ;

label define H1470183X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470184X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470185X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY LOW"
         2 "2 FAIRLY LOW"
         3 "3 MODERATE"
         4 "4 FAIRLY HIGH"
         5 "5 VERY HIGH"
         6 "6 DON'T KNOW" ;

label define H1470186X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470187X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470188X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470189X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 RARELY"
         3 "3 SOMETIMES"
         4 "4 OFTEN"
         5 "5 ALL THE TIME" ;

label define H1470190X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470191X
         0 "0 NOT ELIGIBLE FOR CSAQ"
         1 "1 ELIGIBLE FOR CSAQ AND HAS CSAQ DATA"
         2 "2 ELIGIBLE FOR CSAQ, BUT NO CSAQ DATA" ;

label define H1470192X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470193X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470194X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470195X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470196X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470197X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470198X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470199X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470200X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 2 MONTHS"
         2 "2 2 MONTHS TO LESS THAN 6 MONTHS"
         3 "3 6 MONTHS TO LESS THAN 1 YEAR"
         4 "4 1 YEAR TO 3 YEARS"
         5 "5 MORE THAN 3 YEARS" ;

label define H1470201X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470202X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470203X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470204X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 DON'T KNOW" ;

label define H1470205X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470206X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 2 MONTHS TO LESS THAN 6 MONTHS"
         2 "2 6 MONTHS TO LESS THAN 1 YEAR"
         3 "3 1 YEAR TO 3 YEARS"
         4 "4 MORE THAN 3 YEARS" ;

label define H1470207X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470208X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470209X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 2 MONTHS TO LESS THAN 6 MONTHS"
         2 "2 6 MONTHS TO LESS THAN 1 YEAR"
         3 "3 1 YEAR TO 3 YEARS"
         4 "4 MORE THAN 3 YEARS" ;

label define H1470210X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470211X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 DON'T KNOW" ;

label define H1470212X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 DON'T KNOW" ;

label define H1470213X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470214X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 2 MONTHS TO LESS THAN 6 MONTHS"
         2 "2 6 MONTHS TO LESS THAN 1 YEAR"
         3 "3 1 YEAR TO 3 YEARS"
         4 "4 MORE THAN 3 YEARS" ;

label define H1470215X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 DON'T KNOW" ;

label define H1470216X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470217X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470218X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 2 MONTHS TO LESS THAN 6 MONTHS"
         2 "2 6 MONTHS TO LESS THAN 1 YEAR"
         3 "3 1 YEAR TO 3 YEARS"
         4 "4 MORE THAN 3 YEARS" ;

label define H1470219X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NO CAREGIVERS EMPLOYED WHILE PROV CARE"
         4 "4 DON'T KNOW" ;

label define H1470220X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470221X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN $10,000"
         2 "2 $10,000 TO $24,999"
         3 "3 $25,000 TO $49,999"
         4 "4 $50,000 TO $74,999"
         5 "5 $75,000 TO $99,999"
         6 "6 $100,000 OR MORE" ;

label define H1470222X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470223X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470224X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470225X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470226X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470227X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 DON'T KNOW" ;

label define H1470228X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470229X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470230X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 2 MONTHS"
         2 "2 2 MONTHS TO LESS THAN 6 MONTHS"
         3 "3 6 MONTHS TO LESS THAN 1 YEAR"
         4 "4 1 YEAR TO 3 YEARS"
         5 "5 MORE THAN 3 YEARS" ;

label define H1470231X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H1470232X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470233X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470234X
         -1 "-1  INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470235X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470236X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470237X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470238X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1470239X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470240X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1470241X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1470242X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1470243X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H1470244X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H1470245X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H1470246X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470247X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1470248X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470249X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470250X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470251X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1470252X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1470253X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470254X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470255X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470256X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470257X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470258X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1470259X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470260X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470261X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470262X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470263X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1470264X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1470265X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470266X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1470267X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470268X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470269X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470270X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470271X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470272X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470273X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470274X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NEVER ASKED FOR A SECOND OPINION" ;

label define H1470275X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 DON'T KNOW" ;

label define H1470276X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NEVER APPLIED FOR HEALTH INSURANCE" ;

label define H1470277X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 DOES NOT APPLY" ;

label define H1470278X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 2 MONTHS"
         2 "2 2 MONTHS TO LESS THAN 6 MONTHS"
         3 "3 6 MONTHS TO LESS THAN 1 YEAR"
         4 "4 1 YEAR TO 3 YEARS"
         5 "5 MORE THAN 3 YEARS" ;

label define H1470279X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470280X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470281X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470282X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H1470283X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PART OF A ROUTINE EXAM"
         2 "2 BECAUSE OF A PROBLEM"
         3 "3 SOME OTHER REASON" ;

label define H1470284X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 WITHIN PAST 10 YEARS"
         6 "6 MORE THAN 10 YEARS"
         7 "7 NEVER" ;

label define H1470285X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470286X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 1 YEAR AGO"
         2 "2 1 YEAR AGO TO LESS THAN 3 YEARS AGO"
         3 "3 3 YEARS AGO TO LESS THAN 5 YEARS AGO"
         4 "4 5 YEARS AGO TO LESS THAN 10 YEARS AGO"
         5 "5 10 YEARS AGO TO 20 YEARS AGO"
         6 "6 MORE THAN 20 YEARS AGO"
         7 "7 NO, HAVE NOT BEEN TREATED FOR CANCER" ;

label define H1470287X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISCUSSED IN DETAIL"
         2 "2 BRIEFLY DISCUSSED"
         3 "3 DID NOT DISCUSS"
         4 "4 DON'T REMEMBER" ;

label define H1470288X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISCUSSED IN DETAIL"
         2 "2 BRIEFLY DISCUSSED"
         3 "3 DID NOT DISCUSS"
         4 "4 DON'T REMEMBER" ;

label define H1470289X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470290X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISCUSSED IN DETAIL"
         2 "2 BRIEFLY DISCUSSED"
         3 "3 DID NOT DISCUSS"
         4 "4 DON'T REMEMBER" ;

label define H1470291X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISCUSSED IN DETAIL"
         2 "2 BRIEFLY DISCUSSED"
         3 "3 DID NOT DISCUSS"
         4 "4 DON'T REMEMBER" ;

label define H1470292X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULDN'T AFFORD CARE"
         2 "2 INS CO WOULDN'T APPROVE OR PAY FOR CARE"
         3 "3 DOCTOR DIDN'T ACCEPT INSURANCE"
         4 "4 HAD PROBLEMS GETTING TO THE DR'S OFFICE"
         5 "5 COULDN'T GET TIME OFF FROM WORK"
         6 "6 DIDN'T KNOW WHERE TO GO TO GET CARE"
         7 "7 COULDN'T GET CHILD CARE/ADULT CARE"
         8 "8 NO TIME, CARE/TEST/TRTMNT TOOK TOO LONG"
         9 "9 SOME OTHER REASON" ;

label define H1470293X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, A REASON"
         2 "2 NO, NOT A REASON" ;

label define H1470294X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, A REASON"
         2 "2 NO, NOT A REASON" ;

label define H1470295X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, A REASON"
         2 "2 NO, NOT A REASON" ;

label define H1470296X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, A REASON"
         2 "2 NO, NOT A REASON" ;

label define H1470297X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, A REASON"
         2 "2 NO, NOT A REASON" ;

label define H1470298X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, A REASON"
         2 "2 NO, NOT A REASON" ;

label define H1470299X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, A REASON"
         2 "2 NO, NOT A REASON" ;

label define H1470300X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, A REASON"
         2 "2 NO, NOT A REASON" ;

label define H1470301X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, A REASON"
         2 "2 NO, NOT A REASON" ;

label define H1470302X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470303X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470304X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470305X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470306X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470307X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470308X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470309X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470310X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470311X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470312X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470313X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470314X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470315X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470316X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470317X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470318X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470319X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470320X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470321X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470322X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470323X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470324X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470325X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470326X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470327X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470328X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470329X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 2 MONTHS"
         2 "2 2 MONTHS TO LESS THAN 6 MONTHS"
         3 "3 6 MONTHS TO LESS THAN 1 YEAR"
         4 "4 1 YEAR TO 3 YEARS"
         5 "5 MORE THAN 3 YEARS" ;

label define H1470330X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470331X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H1470332X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H1470333X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470334X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470335X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470336X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470337X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470338X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470339X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT REQUIRED TO PERFORM PHYS TASK AT JOB" ;

label define H1470340X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 2 MONTHS"
         2 "2 2 MONTHS TO LESS THAN 6 MONTHS"
         3 "3 6 MONTHS TO LESS THAN 1 YEAR"
         4 "4 1 YEAR TO 3 YEARS"
         5 "5 MORE THAN 3 YEARS" ;

label define H1470341X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNKNOWN" ;

label define H1470342X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1470343X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 DOES NOT APPLY" ;

label define H1470344X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470345X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470346X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470347X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470348X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470349X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MOSTLY POSITIVE EFFECT"
         2 "2 MOSTLY NEGATIVE EFFECT"
         3 "3 EQUALLY POSITIVE AND NEGATIVE EFFECT"
         4 "4 NEITHER POSITIVE NOR NEGATIVE EFFECT" ;

label define H1470350X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470351X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DUE TO CANCER, TREATMENT, EFFECTS"
         2 "2 SOME OTHER REASON" ;

label define H1470352X
         -1 "-1 INAPPLICABLE"
         -6 "-6 VALUE NOT COLLECTED, BUT ASSIGNED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DUE TO CANCER, TREATMENT, EFFECTS"
         2 "2 SOME OTHER REASON" ;

label define H1470353X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1470354X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470355X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470356X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470357X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470358X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470359X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470360X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470361X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470362X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470363X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470364X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1470365X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ITEMIZED DEDUCTIONS"
         2 "2 STANDARD DEDUCTIONS" ;

label define H1470366X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470367X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 TWICE A YEAR OR MORE"
         2 "2 ONCE A YEAR"
         3 "3 LESS THAN ONCE A YEAR"
         4 "4 NEVER GO TO DENTIST" ;

label define H1470368X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470369X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470370X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470371X
         -1 "-1 INAPPLICABLE"
         1 "1 YES" ;

label define H1470372X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1470373X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470374X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470375X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470376X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H1470377X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H1470378X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H1470379X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1470380X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1470381X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1470382X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1470383X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470384X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470385X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1470386X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1470387X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470388X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470389X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470390X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1470391X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1470392X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1470393X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470394X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470395X
         -1 "-1 INAPPLICABLE"
         1 "1 DEPS IN RU"
         2 "2 DEPS IN AND OUT OF RU"
         3 "3 DEPS OUT OF RU" ;

label define H1470396X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO DEPENDENTS OUTSIDE RU"
         1 "1 ONE DEPENDENT OUTSIDE RU"
         2 "2 TWO DEPENDENTS OUTSIDE RU"
         3 "3 THREE DEPENDENTS OUTSIDE RU" ;

label define H1470397X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NUMBER OF TIMES"
         95 "95 95 TIMES OR MORE"
         96 "96 DID NOT HAVE A1C BLOOD TEST" ;

label define H1470398X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470399X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470400X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470401X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470402X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470403X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470404X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470405X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470406X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT CONFIDENT AT ALL"
         2 "2 SOMEWHAT CONFIDENT"
         3 "3 CONFIDENT"
         4 "4 VERY CONFIDENT" ;

label define H1470407X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470408X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470409X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470410X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470411X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470412X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470413X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470414X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470415X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470416X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470417X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470418X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470419X
         -1 "-1  INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8  DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470420X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470421X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470422X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470423X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470424X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470425X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470426X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470427X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470428X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470429X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470430X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470431X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470432X
         0 "0.00"
         193 "$1 - $193" ;

label define H1470433X
         0 "0.00"
         30 "$1 - $30" ;

label define H1470434X
         0 "0.00"
         455 "$1 - $455" ;

label define H1470435X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470436X
         0 "0.00"
         178 "$1 - $178" ;

label define H1470437X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470438X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470439X
         -1 "-1 INAPPLICABLE OR UNDER 5"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 LESS THAN 1ST GRADE"
         1 "1 1ST GRADE"
         10 "10 10TH GRADE"
         11 "11 11TH GRADE"
         12 "12 12TH GRADE, NO HS DIPLOMA OR GED"
         13 "13 GED OR HS GRAD"
         14 "14 BEYOND HS,COLLEGE(NO 4YR DEG),ASSOC DEG"
         15 "15 4-YEAR COLLEGE DEGREE, BACHELOR'S DEGREE"
         16 "16 MASTER'S, DOCTORATE, OR PROFESSIONAL DEG"
         2 "2 2ND GRADE"
         3 "3 3RD GRADE"
         4 "4 4TH GRADE"
         5 "5 5TH GRADE"
         6 "6 6TH GRADE"
         7 "7 7TH GRADE"
         8 "8 8TH GRADE"
         9 "9 9TH GRADE" ;

label define H1470440X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO SCHOOL/KINDERGARTEN ONLY"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H1470441X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 LESS THAN 1ST GRADE"
         1 "1 1ST GRADE"
         10 "10 10TH GRADE"
         11 "11 11TH GRADE"
         12 "12 12TH GRADE, NO DIPLOMA"
         13 "13 GED OR EQUIVALENT"
         14 "14 HIGH SCHOOL DIPLOMA"
         15 "15 SOME COLLEGE, NO DEGREE"
         16 "16 ASSOC DEG: OCCUPATIONAL,TECH,VOCATIONAL"
         17 "17 ASSOCIATE DEGREE: ACADEMIC PROGRAM"
         18 "18 BACHELOR'S DEGREE (BA,AB,BS,BBA)"
         19 "19 MASTER'S DEGREE (MA,MS,MENG,MED,MBA)"
         2 "2 2ND GRADE"
         20 "20 PROFESSIONAL SCHOOL"
         21 "21 DOCTORATE DEGREE (EXAMPLE: PHD,EDD)"
         22 "22 CHILD UNDER 5 YEARS OLD"
         3 "3 3RD GRADE"
         4 "4 4TH GRADE"
         5 "5 5TH GRADE"
         6 "6 6TH GRADE"
         7 "7 7TH GRADE"
         8 "8 8TH GRADE"
         9 "9 9TH GRADE" ;

label define H1470442X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H1470443X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1470444X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1470445X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1470446X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1470447X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470448X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470449X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         3 "3 JOB DURING RD 3/1 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 3/1" ;

label define H1470450X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 4/2 INT DATE"
         3 "3 JOB DURING RD 4/2 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 4/2" ;

label define H1470451X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         3 "3 JOB DURING RD 5/3 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 5/3" ;

label define H1470452X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470453X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470454X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470455X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470456X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1470457X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1470458X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1470459X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1470460X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2011 "2011 YEAR" ;

label define H1470461X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2011 "2011 YEAR" ;

label define H1470462X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2011 "2011 YEAR" ;

label define H1470463X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2011 "2011 YEAR"
         2012 "2012 YEAR" ;

label define H1470464X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470465X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470466X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470467X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470468X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470469X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470470X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470471X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470472X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470473X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470474X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470475X
         -1 "-1 INAPPLICABLE"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H1470476X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1470477X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1470478X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1470479X
         -1 "-1 INAPP, NOT MEM OF 12/31 FAMILY"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H1470480X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470481X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIMARY FILER"
         2 "2 SECONDARY FILER" ;

label define H1470482X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SINGLE"
         2 "2 MARRIED FILING JOINT RETURN"
         3 "3 MARRIED FILING SEPARATELY"
         4 "4 HEAD OF HOUSEHOLD W/ QUALIFYING PERSON"
         5 "5 QUALIFYING WIDOWER W/ DEPENDENT" ;

label define H1470483X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1470484X
         -1 "-1 INAPPLICABLE"
         0 "0 NONRESPONDING 12/31 FAMILY"
         1 "1 RESPONDING 12/31 FAMILY" ;

label define H1470485X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1470486X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1470487X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470488X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470489X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0.00" ;

label define H1470490X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470491X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470492X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1470493X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1470494X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1470495X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1470496X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 DO NOT HAVE PERSONAL DOCTOR OR NURSE" ;

label define H1470497X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 DO NOT HAVE PERSONAL DOCTOR OR NURSE" ;

label define H1470498X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H1470499X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DRIVE"
         2 "2 IS DRIVEN"
         3 "3 TAXI, BUS, TRAIN, OTHER PUBLIC TRANSPO"
         4 "4 WALKS"
         5 "5 SOME OTHER WAY" ;

label define H1470500X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470501X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470502X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1470503X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470504X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470505X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470506X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470507X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 MODERATE IMPAIRMENT"
         4 "4 MAJOR IMPAIRMENT"
         5 "5 DEAF" ;

label define H1470508X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470509X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470510X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470511X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470512X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470513X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470514X
         0 "0.00"
         851 "$1 - $851" ;

label define H1470515X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470516X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470517X
         0 "0.00"
         75 "$1 - $75" ;

label define H1470518X
         0 "0.00"
         2848 "$1 - $2,848" ;

label define H1470519X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470520X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470521X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470522X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16-INAPPLICABLE" ;

label define H1470523X
         1 "1 HISPANIC"
         2 "2 NOT HISPANIC" ;

label define H1470524X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PUERTO RICAN"
         2 "2 CUBAN/CUBAN AMERICAN"
         3 "3 DOMINICAN"
         4 "4 MEXICAN/MEXICAN AMERICAN"
         5 "5 CENTRAL OR SOUTH AMERICAN"
         6 "6 NON-HISPANIC"
         91 "91 OTHER LATIN AMERICAN"
         92 "92 OTHER HISPANIC/LATINO" ;

label define H1470525X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1470526X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1470527X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1470528X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1470529X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1470530X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470531X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470532X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470533X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470534X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470535X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470536X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470537X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470538X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470539X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470540X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470541X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470542X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470543X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470544X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470545X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470546X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470547X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470548X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470549X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470550X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470551X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470552X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470553X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470554X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470555X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470556X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470557X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470558X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470559X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470560X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470561X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470562X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470563X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470564X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470565X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470566X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470567X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470568X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470569X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470570X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470571X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470572X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470573X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470574X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470575X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470576X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470577X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470578X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470579X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470580X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470581X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470582X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470583X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470584X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470585X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470586X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470587X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470588X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470589X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470590X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470591X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470592X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470593X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470594X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470595X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470596X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470597X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470598X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470599X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470600X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470601X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470602X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470603X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470604X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470605X
         -1 "-1 INAPPLICABLE"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1470606X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1470607X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1470608X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $75.00"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470609X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $75.00"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470610X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $75.00"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470611X
         0 "0 NO"
         1 "1 YES" ;

label define H1470612X
         0 "0 NO"
         1 "1 YES" ;

label define H1470613X
         0 "0 NO"
         1 "1 YES" ;

label define H1470614X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470615X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470616X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470617X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470618X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470619X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470620X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470621X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470622X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470623X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470624X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1470625X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1470626X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1470627X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470628X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470629X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470630X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470631X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470632X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470633X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470634X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470635X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470636X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470637X
         1 "1 IN-SCOPE ON 12/31/2011"
         2 "2 NOT IN-SCOPE ON 12/31/2011" ;

label define H1470638X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/11"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1470639X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/11"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1470640X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/11"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1470641X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/11"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1470642X
         0 "0 NOT RECORDED AS BEING INSCOPE"
         1 "1 INSCOPE AT SOME TIME DURING 2011"
         2 "2 OUT-OF-SCOPE FOR ALL OF 2011" ;

label define H1470643X
         1 "1 ANY PRIVATE"
         2 "2 PUBLIC ONLY"
         3 "3 UNINSURED" ;

label define H1470644X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470645X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470646X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470647X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470648X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470649X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470650X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470651X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470652X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470653X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470654X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470655X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470656X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470657X
         1 "1 <65 ANY PRIVATE"
         2 "2 <65 ANY PUBLIC"
         3 "3 <65 UNINSURED"
         4 "4 65+ MEDICARE ONLY"
         5 "5 65+ MEDICARE AND PRIVATE"
         6 "6 65+ MEDICARE AND OTHER PUBLIC"
         7 "7 65+ NO MEDICARE" ;

label define H1470658X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1470659X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ENGLISH & SPANISH"
         91 "91 OTHER" ;

label define H1470660X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470661X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470662X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1470663X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470664X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1470665X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1470666X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1470667X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470668X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470669X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470670X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470671X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470672X
         -1 "-1 INAPPLICABLE"
         1 "1 KEY"
         2 "2 NOT KEY" ;

label define H1470673X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470674X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470675X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1470676X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470677X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ANOTHER LANGUAGE" ;

label define H1470678X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470679X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470680X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470681X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470682X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT" ;

label define H1470683X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT" ;

label define H1470684X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470685X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470686X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470687X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470688X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 OFFICE"
         2 "2 HOSPITAL, NOT ER"
         3 "3 HOSPITAL, ER" ;

label define H1470689X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470690X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470691X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1470692X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470693X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470694X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470695X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470696X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470697X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1470698X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE" ;

label define H1470699X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1470700X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1470701X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1470702X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470703X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470704X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470705X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470706X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470707X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470708X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470709X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470710X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470711X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470712X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470713X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470714X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470715X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470716X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470717X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470718X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470719X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470720X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470721X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470722X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470723X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470724X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470725X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470726X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470727X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470728X
         1 "1 YES"
         2 "2 NO" ;

label define H1470729X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470730X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470731X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1470732X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1470733X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1470734X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470735X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470736X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470737X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470738X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470739X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470740X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470741X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470742X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1470743X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1470744X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1470745X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470746X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470747X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470748X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470749X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470750X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470751X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470752X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470753X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470754X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470755X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470756X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470757X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470758X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470759X
         1 "1 YES"
         2 "2 NO" ;

label define H1470760X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470761X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470762X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470763X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470764X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470765X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470766X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470767X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470768X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470769X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470770X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470771X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470772X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470773X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470774X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470775X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470776X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PART B NOT ASC"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H1470777X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PART B NOT ASC"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H1470778X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PART B NOT ASC"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H1470779X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1470780X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1470781X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1470782X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1470783X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1470784X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1470785X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1470786X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1470787X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1470788X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470789X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470790X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470791X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1470792X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1470793X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470794X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1470795X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1470796X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470797X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470798X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H1470799X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470800X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H1470801X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470802X
         -1 "-1 INAPPLICALBE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470803X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470804X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1470805X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1470806X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470807X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1470808X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1470809X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1470810X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1470811X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470812X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470813X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470814X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470815X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1470816X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1470817X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1470818X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470819X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470820X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H1470821X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H1470822X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H1470823X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H1470824X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470825X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470826X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470827X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470828X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1470829X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1470830X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470831X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470832X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$75.00"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470833X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$75.00"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470834X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$75.00"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470835X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470836X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470837X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470838X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470839X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470840X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470841X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WEEKS"
         2 "2 MONTHS" ;

label define H1470842X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470843X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470844X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470845X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470846X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470847X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470848X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1470849X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1470850X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1470851X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470852X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470853X
         0 "0.00"
         393 "$1 - $393" ;

label define H1470854X
         0 "0.00"
         273 "$1 - $273" ;

label define H1470855X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470856X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470857X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470858X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470859X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470860X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470861X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1470862X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1470863X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1470864X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470865X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470866X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470867X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470868X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470869X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470870X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470871X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470872X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470873X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470874X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470875X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470876X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470877X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470878X
         1 "1 YES"
         2 "2 NO" ;

label define H1470879X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470880X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470881X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470882X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470883X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470884X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470885X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470886X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470887X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470888X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470889X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470890X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470891X
         1 "1 YES"
         2 "2 NO" ;

label define H1470892X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470893X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470894X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470895X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470896X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470897X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470898X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470899X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470900X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470901X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470902X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470903X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470904X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470905X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470906X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470907X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1470908X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470909X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470910X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470911X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470912X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470913X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470914X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470915X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470916X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470917X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470918X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470919X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470920X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470921X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470922X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470923X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470924X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470925X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470926X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470927X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470928X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470929X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470930X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470931X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470932X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470933X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470934X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470935X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470936X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470937X
         15 "15 PANEL 15"
         16 "16 PANEL 16" ;

label define H1470938X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1470939X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470940X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470941X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470942X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470943X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470944X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470945X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1470946X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1470947X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1470948X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1470949X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1470950X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1470951X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470952X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470953X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470954X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470955X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470956X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470957X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470958X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470959X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470960X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470961X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470962X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470963X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470964X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470965X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470966X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470967X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470968X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470969X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470970X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470971X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470972X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470973X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470974X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470975X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1470976X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470977X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H1470978X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H1470979X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H1470980X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1470981X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1470982X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470983X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470984X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOSPITAL CLINIC/OUTPATIENT DEPT"
         2 "2 HOSPITAL EMERGENCY ROOM"
         3 "3 NON-HOSPITAL PLACE" ;

label define H1470985X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470986X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470987X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1470988X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1470989X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1470990X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470991X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470992X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1470993X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470994X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470995X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1470996X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1470997X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1470998X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1470999X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471000X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471001X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471002X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H1471003X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H1471004X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H1471005X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471006X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1471007X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1471008X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471009X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471010X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471011X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471012X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471013X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471014X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471015X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471016X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471017X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471018X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471019X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471020X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471021X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471022X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471023X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471024X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471025X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471026X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471027X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471028X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471029X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471030X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471031X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471032X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471033X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471034X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471035X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471036X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471037X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471038X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471039X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471040X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471041X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471042X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471043X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471044X
         1 "1 POOR/NEGATIVE"
         2 "2 NEAR POOR"
         3 "3 LOW INCOME"
         4 "4 MIDDLE INCOME"
         5 "5 HIGH INCOME" ;

label define H1471045X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471046X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471047X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST-NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H1471048X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST - NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H1471049X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST - NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H1471050X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471051X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471052X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471053X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471054X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471055X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471056X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471057X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471058X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471059X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471060X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471061X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471062X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471063X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471064X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471065X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471066X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471067X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471068X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471069X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471070X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471071X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471072X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471073X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471074X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471075X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471076X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471077X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471078X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471079X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471080X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471081X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471082X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471083X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471084X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471085X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471086X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471087X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471088X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471089X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471090X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471091X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471092X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471093X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471094X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471095X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471096X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471097X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471098X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471099X
         -1 "-1 INAPPLICABLE"
         1 "1 FACILITY"
         2 "2 PERSON"
         3 "3 PERSON IN FACILITY PROVIDER" ;

label define H1471100X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1471101X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1471102X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1471103X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1471104X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471105X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471106X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471107X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471108X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471109X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471110X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471111X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471112X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471113X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471114X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471115X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471116X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1471117X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471118X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1471119X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1471120X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1471121X
         1 "1 YES"
         2 "2 NO" ;

label define H1471122X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1471123X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1471124X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1471125X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1471126X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1471127X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1471128X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1471129X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1471130X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1471131X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1471132X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471133X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471134X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471135X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471136X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471137X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471138X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471139X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471140X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471141X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471142X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471143X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471144X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1471145X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471146X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471147X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471148X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471149X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471150X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471151X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471152X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471153X
         -1 "-1 INAPPLICABLE"
         1 "1 ASIAN - NO OTHER RACE REPORTED"
         2 "2 ASIAN - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1471154X
         -1 "-1 INAPPLICABLE"
         1 "1 BLACK - NO OTHER RACE REPORTED"
         2 "2 BLACK - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1471155X
         1 "1 PERSON IS HISPANIC"
         2 "2 PERSON IS BLACK-NO OTH RACE/NOT HISPANIC"
         3 "3 PERSON IS ASIAN-NO OTH RACE/NOT HISPANIC"
         4 "4 OTHER RACE/NOT HISPANIC" ;

label define H1471156X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 WHITE - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1471157X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 BLACK - NO OTHER RACE REPORTED"
         3 "3 AMER INDIAN/ALASKA NATIVE - NO OTH RAC"
         4 "4 ASIAN - NO OTHER RACE REPORTED"
         5 "5 NATIVE HAWAIIAN/PACIFIC ISLANDER-NO OTHR"
         6 "6 MULTIPLE RACES REPORTED" ;

label define H1471158X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1471159X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1471160X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471161X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471162X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1471163X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471164X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471165X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1471166X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1471167X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1471168X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1471169X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1471170X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1471171X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1471172X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1471173X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1471174X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1471175X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471176X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471177X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471178X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 FOSTER SISTER"
         48 "48 FOSTER BROTHER"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1471179X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 FOSTER SISTER"
         48 "48 FOSTER BROTHER"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1471180X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 FOSTER SISTER"
         48 "48 FOSTER BROTHER"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1471181X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 FOSTER SISTER"
         48 "48 FOSTER BROTHER"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1471182X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ROUND 1"
         2 "2 ROUND 2"
         3 "3 ROUND 3" ;

label define H1471183X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1471184X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1471185X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1471186X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1471187X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1471188X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1471189X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1471190X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1471191X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1471192X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1471193X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1471194X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1471195X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1471196X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471197X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1471198X
         0 "0 NOT ELIGIBLE FOR SAQ"
         1 "1 ELIGIBLE FOR SAQ - HAS SAQ DATA"
         2 "2 ELIGIBLE FOR SAQ - NO SAQ DATA" ;

label define H1471199X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1471200X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471201X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471202X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1471203X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1471204X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1471205X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1471206X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALWAYS"
         2 "2 NEARLY ALWAYS"
         3 "3 SOMETIMES"
         4 "4 SELDOM"
         5 "5 NEVER"
         6 "6 NEVER DRIVES/RIDES IN A CAR" ;

label define H1471207X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471208X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471209X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471210X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471211X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471212X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H1471213X
         -1 "-1 INAPPLICABLE"
         0 "0 NO"
         1 "1 YES" ;

label define H1471214X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PART OF A ROUTINE EXAM"
         2 "2 BECAUSE OF A PROBLEM"
         3 "3 SOME OTHER REASON" ;

label define H1471215X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 WITHIN PAST 10 YEARS"
         6 "6 MORE THAN 10 YEARS"
         7 "7 NEVER" ;

label define H1471216X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1471217X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1471218X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471219X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471220X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471221X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1471222X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471223X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1471224X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471225X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471226X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471227X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1471228X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1471229X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1471230X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YEARS OLD" ;

label define H1471231X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1471232X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1471233X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1471234X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1471235X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1471236X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1471237X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISABILITY"
         2 "2 SOME OTHER REASON" ;

label define H1471238X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1471239X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1471240X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1471241X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1471242X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471243X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471244X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471245X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471246X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471247X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471248X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471249X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471250X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471251X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471252X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471253X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471254X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471255X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471256X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471257X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471258X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1471259X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1471260X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1471261X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1471262X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1471263X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1471264X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1471265X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1471266X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1471267X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1471268X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1471269X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1471270X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471271X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471272X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H1471273X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H1471274X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471275X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471276X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471277X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471278X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1471279X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471280X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LONG FORM 1040"
         2 "2 SHORT FORM 1040A"
         3 "3 SHORT FORM 1040EZ"
         91 "91 OTHER" ;

label define H1471281X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1471282X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1471283X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1471284X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1471285X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471286X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1471287X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471288X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471289X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 15 MINUTES"
         2 "2 15 TO 30 MINUTES"
         3 "3 31 TO 60 MINUTES (1 HOUR)"
         4 "4 61 TO 90 MINUTES"
         5 "5 91 MINUTES TO 120 MINUTES (2 HOURS)"
         6 "6 MORE THAN 120 MINUTES (2 HOURS)" ;

label define H1471290X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0.00" ;

label define H1471291X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471292X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1471293X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471294X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471295X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471296X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471297X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471298X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471299X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471300X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1471301X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1471302X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1471303X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471304X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471305X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471306X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471307X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471308X
         1 "1 YES"
         2 "2 NO" ;

label define H1471309X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1471310X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1471311X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1471312X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471313X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471314X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471315X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471316X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1471317X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1471318X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1471319X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471320X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471321X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471322X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471323X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1471324X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1471325X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1471326X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1471327X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1471328X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1471329X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1471330X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1471331X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1471332X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471333X
         -1 "-1 INAPPLICABLE"
         1 "1 MD - GENERAL/FAMILY PRACTICE"
         10 "10 PHYSICIAN'S ASSISTANT"
         11 "11 OTHER NON-MD PROVIDER"
         12 "12 UNKNOWN"
         13 "13 MD - CARDIOLOGIST"
         14 "14 DOCTOR OF OSTEOPATHY"
         15 "15 MD - ENDOCRINOLOGIST"
         16 "16 MD - GASTROENTEROLOGIST"
         17 "17 MD - GERIATRICIAN"
         18 "18 MD - NEPHROLOGIST"
         19 "19 MD - ONCOLOGIST"
         2 "2 MD - INTERNAL MEDICINE"
         20 "20 MD - PULMONOLOGIST"
         21 "21 MD - RHEUMATOLOGIST"
         22 "22 PSYCHIATRIST/PSYCHOLOGIST"
         23 "23 MD - NEUROLOGIST"
         24 "24 ALTERNATIVE CARE PROVIDER"
         3 "3 MD - PEDIATRICS"
         4 "4 MD - OB/GYN"
         5 "5 MD - SURGERY"
         6 "6 MD - OTHER"
         7 "7 CHIROPRACTOR"
         8 "8 NURSE"
         9 "9 NURSE PRACTITIONER" ;

label define H1471334X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471335X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471336X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1471337X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1471338X
         1 "1 YES"
         2 "2 NO" ;

label define H1471339X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471340X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471341X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471342X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471343X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471344X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1471345X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1471346X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471347X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1471348X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 IMPAIRED NEAR, BUT NOT FAR"
         4 "4 IMPAIRED BOTH NEAR AND FAR"
         5 "5 BLIND" ;

label define H1471349X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1471350X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471351X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471352X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471353X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471354X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471355X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471356X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471357X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471358X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471359X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471360X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471361X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471362X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471363X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471364X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1471365X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471366X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1471367X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1471368X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1471369X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1471370X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1471371X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1471372X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1471373X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1471374X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1471375X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1471376X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1471377X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471378X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1471379X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1471380X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1471381X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471382X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471383X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1471384X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1471385X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471386X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471387X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471388X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1471389X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471390X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1471391X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE ANOTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H1471392X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE OTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H1471393X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEM"
         91 "91 SOME OTHER REASON" ;

label define H1471394X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEM"
         91 "91 SOME OTHER REASON" ;

label define H1471395X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEMS"
         91 "91 SOME OTHER REASON" ;

label define H1471396X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELDOM OR NEVER SICK"
         10 "10 NO HEALTH INSURANCE"
         11 "11 JOB-RELATED REASONS"
         12 "12 LOOKING FOR A NEW DOCTOR/NO DOCTOR YET"
         13 "13 USC DOCTOR IS SOMEWHERE ELSE"
         14 "14 DON'T LIKE/DON'T TRUST DOCTORS"
         15 "15 HEALTH-RELATED REASONS"
         16 "16 NEWBORN - NO DOCTOR YET"
         17 "17 SELF, RELATIVE, OR FRIEND IS A DOCTOR"
         19 "19 CARE AVAILABLE ON JOB"
         2 "2 RECENTLY MOVED TO AREA"
         20 "20 WILL NOT GO TO THE DOCTOR"
         21 "21 PROBLEMS WITH TIME AND TRANSPORTATION"
         22 "22 GOES TO HOSPITAL/EMERGENCY ROOM/CLINIC"
         23 "23 USES ALTERNATIVE CARE"
         24 "24 INSURANCE-RELATED REASONS"
         3 "3 DON'T KNOW WHERE TO GO"
         4 "4 USC IN AREA NOT AVAILABLE"
         5 "5 CAN'T FIND PROVIDER WHO SPEAKS LANGUAGE"
         6 "6 GOES DIFFERENT PLACES FOR DIFF NEEDS"
         7 "7 JUST CHANGED INSURANCE PLANS"
         8 "8 DON'T USE DOCS/TREAT SELF"
         9 "9 COST OF MEDICAL CARE"
         91 "91 OTHER REASON" ;

label define H1471397X
         0 "0.00"
         73 "$1 - $73" ;

label define H1471398X
         0 "0.00"
         125 "$1 - $125" ;

label define H1471399X
         0 "0.00"
         1732 "$1 - $1,732" ;

label define H1471400X
         0 "0.00"
         38 "$1 - $38" ;

* ASSOCIATE VARIABLES WITH VALUE LABEL DEFINITIONS;
label value ACCELI42 H1470001X;
label value ACTDTY31 H1470002X;
label value ACTDTY42 H1470003X;
label value ACTDTY53 H1470004X;
label value ACTLIM31 H1470005X;
label value ACTLIM53 H1470006X;
label value ADAPPT42 H1470007X;
label value ADCAPE42 H1470008X;
label value ADCLIM42 H1470009X;
label value ADCMPD42 H1470010X;
label value ADCMPM42 H1470011X;
label value ADCMPY42 H1470012X;
label value ADDAYA42 H1470013X;
label value ADDOWN42 H1470014X;
label value ADDPRS42 H1470015X;
label value ADDRBP42 H1470016X;
label value ADEFRT42 H1470017X;
label value ADEGMC42 H1470018X;
label value ADEXPL42 H1470019X;
label value ADEZUN42 H1470020X;
label value ADFFRM42 H1470021X;
label value ADFHLP42 H1470022X;
label value ADGENH42 H1470023X;
label value ADHDADDX H1470024X;
label value ADHDAGED H1470025X;
label value ADHECR42 H1470026X;
label value ADHOPE42 H1470027X;
label value ADILCR42 H1470028X;
label value ADILWW42 H1470029X;
label value ADINSA42 H1470030X;
label value ADINSB42 H1470031X;
label value ADINST42 H1470032X;
label value ADINTR42 H1470033X;
label value ADL3MO31 H1470034X;
label value ADL3MO42 H1470035X;
label value ADL3MO53 H1470036X;
label value ADLANG42 H1470037X;
label value ADLHLP31 H1470038X;
label value ADLHLP42 H1470039X;
label value ADLHLP53 H1470040X;
label value ADLIST42 H1470041X;
label value ADMALS42 H1470042X;
label value ADMWLM42 H1470043X;
label value ADNDCR42 H1470044X;
label value ADNERV42 H1470045X;
label value ADNRGY42 H1470046X;
label value ADNSMK42 H1470047X;
label value ADOVER42 H1470048X;
label value ADPAIN42 H1470049X;
label value ADPALS42 H1470050X;
label value ADPRTM42 H1470051X;
label value ADPRX42 H1470052X;
label value ADPWLM42 H1470053X;
label value ADRESP42 H1470054X;
label value ADREST42 H1470055X;
label value ADRISK42 H1470056X;
label value ADRTCR42 H1470057X;
label value ADRTWW42 H1470058X;
label value ADSAD42 H1470059X;
label value ADSMOK42 H1470060X;
label value ADSOCA42 H1470061X;
label value ADSPEC42 H1470062X;
label value ADSPRF42 H1470063X;
label value ADTLHW42 H1470064X;
label value ADUPRO42 H1470065X;
label value ADWRTH42 H1470066X;
label value AFDC11 H1470067X;
label value AFTHOU42 H1470068X;
label value AIDHLP31 H1470069X;
label value AIDHLP53 H1470070X;
label value ALIIMP11 H1470071X;
label value AMCOPU11 H1470072X;
label value AMCSTL11 H1470073X;
label value AMTOFD11 H1470074X;
label value ANGIAGED H1470075X;
label value ANGIDX H1470076X;
label value ANYLIM11 H1470077X;
label value APRDLM42 H1470078X;
label value APRDLT42 H1470079X;
label value APRTRM42 H1470080X;
label value APRTRT42 H1470081X;
label value ARTHAGED H1470082X;
label value ARTHDX H1470083X;
label value ARTHTYPE H1470084X;
label value ASACUT53 H1470085X;
label value ASATAK31 H1470086X;
label value ASATAK53 H1470087X;
label value ASDALY53 H1470088X;
label value ASEVFL53 H1470089X;
label value ASIANP42 H1470090X;
label value ASMRCN53 H1470091X;
label value ASPKFL53 H1470092X;
label value ASPREV53 H1470093X;
label value ASPRIN53 H1470094X;
label value ASSTIL31 H1470095X;
label value ASSTIL53 H1470096X;
label value ASTHAGED H1470097X;
label value ASTHDX H1470098X;
label value ASTHEP31 H1470099X;
label value ASTHEP53 H1470100X;
label value ASWNFL53 H1470101X;
label value BEGRFD31 H1470102X;
label value BEGRFD42 H1470103X;
label value BEGRFD53 H1470104X;
label value BEGRFM31 H1470105X;
label value BEGRFM42 H1470106X;
label value BEGRFM53 H1470107X;
label value BEGRFY31 H1470108X;
label value BEGRFY42 H1470109X;
label value BEGRFY53 H1470110X;
label value BENDIF31 H1470111X;
label value BENDIF53 H1470112X;
label value BLCKPR42 H1470113X;
label value BLDRAGED H1470114X;
label value BLDRREMS H1470115X;
label value BLIND42 H1470116X;
label value BLODAGED H1470117X;
label value BLODREMS H1470118X;
label value BMINDX53 H1470119X;
label value BONEAGED H1470120X;
label value BONEREMS H1470121X;
label value BOOST42 H1470122X;
label value BPCHEK53 H1470123X;
label value BPMLDX H1470124X;
label value BPMONT53 H1470125X;
label value BRAIAGED H1470126X;
label value BRAIREMS H1470127X;
label value BRSTAGED H1470128X;
label value BRSTEX53 H1470129X;
label value BRSTREMS H1470130X;
label value BSNTY31 H1470131X;
label value BSNTY42 H1470132X;
label value BSNTY53 H1470133X;
label value BSTSRE53 H1470134X;
label value BSTST53 H1470135X;
label value BUSIMP11 H1470136X;
label value CABLADDR H1470137X;
label value CABLOOD H1470138X;
label value CABONE H1470139X;
label value CABRAIN H1470140X;
label value CABREAST H1470141X;
label value CACERVIX H1470142X;
label value CACOLON H1470143X;
label value CAESOPH H1470144X;
label value CAKIDNEY H1470145X;
label value CALARYNX H1470146X;
label value CALEUKEM H1470147X;
label value CALIVER H1470148X;
label value CALUNG H1470149X;
label value CALYMPH H1470150X;
label value CAMELANO H1470151X;
label value CAMOUTH H1470152X;
label value CAMUSCLE H1470153X;
label value CANCERDX H1470154X;
label value CAOTHER H1470155X;
label value CAOVARY H1470156X;
label value CAPANCRS H1470157X;
label value CAPROSTA H1470158X;
label value CARECO42 H1470159X;
label value CARECTUM H1470160X;
label value CASKINDK H1470161X;
label value CASKINNM H1470162X;
label value CASTOMCH H1470163X;
label value CATESTIS H1470164X;
label value CATHROAT H1470165X;
label value CATHYROD H1470166X;
label value CAUTERUS H1470167X;
label value CBCK53 H1470168X;
label value CBCKYR53 H1470169X;
label value CCLHIN53 H1470170X;
label value CCNGFT53 H1470171X;
label value CCNGPT53 H1470172X;
label value CCNRDI53 H1470173X;
label value CDIAG53 H1470174X;
label value CDRET53 H1470175X;
label value CEFACT53 H1470176X;
label value CEFAHU53 H1470177X;
label value CEFASK53 H1470178X;
label value CEFBCK53 H1470179X;
label value CEFCOP53 H1470180X;
label value CEFHLT53 H1470181X;
label value CEFLCT53 H1470182X;
label value CEFMTL53 H1470183X;
label value CEFOG53 H1470184X;
label value CEFOPN53 H1470185X;
label value CEFPOS53 H1470186X;
label value CEFREC53 H1470187X;
label value CEFRHU53 H1470188X;
label value CEFRSP53 H1470189X;
label value CEFSTG53 H1470190X;
label value CELIGI53 H1470191X;
label value CERET53 H1470192X;
label value CERVAGED H1470193X;
label value CERVREMS H1470194X;
label value CEXTDI53 H1470195X;
label value CEXTLT53 H1470196X;
label value CEXTM53 H1470197X;
label value CEXTMT53 H1470198X;
label value CEXTOG53 H1470199X;
label value CEXTOT53 H1470200X;
label value CEXTRT53 H1470201X;
label value CFM2MT53 H1470202X;
label value CFMCOG53 H1470203X;
label value CFMDRT53 H1470204X;
label value CFMEM53 H1470205X;
label value CFMETM53 H1470206X;
label value CFMEXT53 H1470207X;
label value CFMFOG53 H1470208X;
label value CFMFTM53 H1470209X;
label value CFMFTP53 H1470210X;
label value CFMGRT53 H1470211X;
label value CFMLDJ53 H1470212X;
label value CFMNPT53 H1470213X;
label value CFMNTM53 H1470214X;
label value CFMOTH53 H1470215X;
label value CFMPOG53 H1470216X;
label value CFMPTF53 H1470217X;
label value CFMPTM53 H1470218X;
label value CFMTOF53 H1470219X;
label value CFMUOG53 H1470220X;
label value CFNAMT53 H1470221X;
label value CFNBNK53 H1470222X;
label value CFNDBT53 H1470223X;
label value CFNPMT53 H1470224X;
label value CFNSAC53 H1470225X;
label value CFNUNB53 H1470226X;
label value CFREE53 H1470227X;
label value CFRET53 H1470228X;
label value CFTRT53 H1470229X;
label value CFTTOT53 H1470230X;
label value CHAPPT42 H1470231X;
label value CHBMIX42 H1470232X;
label value CHBRON31 H1470233X;
label value CHBRON53 H1470234X;
label value CHCOUN42 H1470235X;
label value CHDAGED H1470236X;
label value CHDDX H1470237X;
label value CHECK53 H1470238X;
label value CHEMPB42 H1470239X;
label value CHENEC42 H1470240X;
label value CHEXPL42 H1470241X;
label value CHEYRE42 H1470242X;
label value CHGJ3142 H1470243X;
label value CHGJ4253 H1470244X;
label value CHHECR42 H1470245X;
label value CHILCR42 H1470246X;
label value CHILWW42 H1470247X;
label value CHLICO42 H1470248X;
label value CHLIHB42 H1470249X;
label value CHLIMI42 H1470250X;
label value CHLIMP11 H1470251X;
label value CHLIST42 H1470252X;
label value CHNDCR42 H1470253X;
label value CHOIC31 H1470254X;
label value CHOIC42 H1470255X;
label value CHOIC53 H1470256X;
label value CHOLAGED H1470257X;
label value CHOLCK53 H1470258X;
label value CHOLDX H1470259X;
label value CHPMCN42 H1470260X;
label value CHPMED42 H1470261X;
label value CHPMHB42 H1470262X;
label value CHPRTM42 H1470263X;
label value CHRESP42 H1470264X;
label value CHRTCR42 H1470265X;
label value CHRTWW42 H1470266X;
label value CHSERV42 H1470267X;
label value CHSPEC42 H1470268X;
label value CHSRCN42 H1470269X;
label value CHSRHB42 H1470270X;
label value CHTHCO42 H1470271X;
label value CHTHER42 H1470272X;
label value CHTHHB42 H1470273X;
label value CIN2OP53 H1470274X;
label value CINCOV53 H1470275X;
label value CINDND53 H1470276X;
label value CINREF53 H1470277X;
label value CLDJOB53 H1470278X;
label value CLHINS53 H1470279X;
label value CLINIC42 H1470280X;
label value CLMDEP11 H1470281X;
label value CLMHIP11 H1470282X;
label value CLNTRE53 H1470283X;
label value CLNTST53 H1470284X;
label value CLPROD53 H1470285X;
label value CLSTRT53 H1470286X;
label value CMCEFF53 H1470287X;
label value CMCFUP53 H1470288X;
label value CMCNEC53 H1470289X;
label value CMCPSY53 H1470290X;
label value CMCSTY53 H1470291X;
label value CMMAIN53 H1470292X;
label value CMNACC53 H1470293X;
label value CMNAFF53 H1470294X;
label value CMNCRE53 H1470295X;
label value CMNINS53 H1470296X;
label value CMNLNG53 H1470297X;
label value CMNOFF53 H1470298X;
label value CMNPLC53 H1470299X;
label value CMNTIM53 H1470300X;
label value CMOTHR H1470301X;
label value CMTASK53 H1470302X;
label value CNGFDI53 H1470303X;
label value CNGFLT53 H1470304X;
label value CNGFLX53 H1470305X;
label value CNGFMT53 H1470306X;
label value CNGFOG53 H1470307X;
label value CNGFTR53 H1470308X;
label value CNGFXD53 H1470309X;
label value CNGFXL53 H1470310X;
label value CNGFXM53 H1470311X;
label value CNGFXT53 H1470312X;
label value CNGLDD53 H1470313X;
label value CNGLDJ53 H1470314X;
label value CNGLDL53 H1470315X;
label value CNGLDM53 H1470316X;
label value CNGLDT53 H1470317X;
label value CNGLOG53 H1470318X;
label value CNGPDI53 H1470319X;
label value CNGPLT53 H1470320X;
label value CNGPMT53 H1470321X;
label value CNGPOG53 H1470322X;
label value CNGPTR53 H1470323X;
label value CNPOG53 H1470324X;
label value CNPTDI53 H1470325X;
label value CNPTLT53 H1470326X;
label value CNPTMT53 H1470327X;
label value CNPTOF53 H1470328X;
label value CNPTOT53 H1470329X;
label value CNPTRT53 H1470330X;
label value COGLIM31 H1470331X;
label value COGLIM53 H1470332X;
label value COLOAGED H1470333X;
label value COLOREMS H1470334X;
label value COTARR53 H1470335X;
label value COVRMM H1470336X;
label value COVRYY H1470337X;
label value CPROM53 H1470338X;
label value CPTASK53 H1470339X;
label value CPTTOT53 H1470340X;
label value CSHCN42 H1470341X;
label value CSHIMP11 H1470342X;
label value CSLHIN53 H1470343X;
label value CSTSVM42 H1470344X;
label value CSTSVT42 H1470345X;
label value CTMOFF53 H1470346X;
label value CTMSK53 H1470347X;
label value CTRTMT53 H1470348X;
label value CWRKEF53 H1470349X;
label value CWRKP53 H1470350X;
label value CWYASK53 H1470351X;
label value CWYCNG53 H1470352X;
label value DADPRO42 H1470353X;
label value DDBDYS31 H1470354X;
label value DDBDYS42 H1470355X;
label value DDBDYS53 H1470356X;
label value DDNSCL31 H1470357X;
label value DDNSCL42 H1470358X;
label value DDNSCL53 H1470359X;
label value DDNWRK31 H1470360X;
label value DDNWRK42 H1470361X;
label value DDNWRK53 H1470362X;
label value DEAF42 H1470363X;
label value DECIDE42 H1470364X;
label value DEDUCT11 H1470365X;
label value DENTAL42 H1470366X;
label value DENTCK53 H1470367X;
label value DENTIN31 H1470368X;
label value DENTIN42 H1470369X;
label value DENTIN53 H1470370X;
label value DEPDNT11 H1470371X;
label value DFTOUS42 H1470372X;
label value DIABAGED H1470373X;
label value DIABDX H1470374X;
label value DIFFPL42 H1470375X;
label value DIFFWG31 H1470376X;
label value DIFFWG42 H1470377X;
label value DIFFWG53 H1470378X;
label value DISVW31X H1470379X;
label value DISVW42X H1470380X;
label value DISVW53X H1470381X;
label value DIVIMP11 H1470382X;
label value DKWHRU42 H1470383X;
label value DNDLAY42 H1470384X;
label value DNDLPR42 H1470385X;
label value DNDLRS42 H1470386X;
label value DNTINS11 H1470387X;
label value DNTINS31 H1470388X;
label value DNUNAB42 H1470389X;
label value DNUNPR42 H1470390X;
label value DNUNRS42 H1470391X;
label value DOBMM H1470392X;
label value DOBYY H1470393X;
label value DOCELS42 H1470394X;
label value DPINRU11 H1470395X;
label value DPOTSD11 H1470396X;
label value DSA1C53 H1470397X;
label value DSCB1053 H1470398X;
label value DSCGRP53 H1470399X;
label value DSCH1053 H1470400X;
label value DSCH1153 H1470401X;
label value DSCH1253 H1470402X;
label value DSCHNV53 H1470403X;
label value DSCINT53 H1470404X;
label value DSCNPC53 H1470405X;
label value DSCONF53 H1470406X;
label value DSCPCP53 H1470407X;
label value DSCPHN53 H1470408X;
label value DSDIA53 H1470409X;
label value DSDIET53 H1470410X;
label value DSEB1053 H1470411X;
label value DSEY1053 H1470412X;
label value DSEY1153 H1470413X;
label value DSEY1253 H1470414X;
label value DSEYNV53 H1470415X;
label value DSEYPR53 H1470416X;
label value DSFB1053 H1470417X;
label value DSFL1053 H1470418X;
label value DSFL1153 H1470419X;
label value DSFL1253 H1470420X;
label value DSFLNV53 H1470421X;
label value DSFT1053 H1470422X;
label value DSFT1153 H1470423X;
label value DSFT1253 H1470424X;
label value DSFTNV53 H1470425X;
label value DSINSU53 H1470426X;
label value DSKIDN53 H1470427X;
label value DSMED53 H1470428X;
label value DSPRX53 H1470429X;
label value DSVB1053 H1470430X;
label value DVGEN11 H1470431X;
label value DVGWCP11 H1470432X;
label value DVOOFD11 H1470433X;
label value DVOOPU11 H1470434X;
label value DVORTH11 H1470435X;
label value DVOVA11 H1470436X;
label value DVTOT11 H1470437X;
label value EATHLT42 H1470438X;
label value EDRECODE H1470439X;
label value EDUCYR H1470440X;
label value EDUYRDEG H1470441X;
label value EICRDT11 H1470442X;
label value ELGRND11 H1470443X;
label value ELGRND31 H1470444X;
label value ELGRND42 H1470445X;
label value ELGRND53 H1470446X;
label value EMPHAGED H1470447X;
label value EMPHDX H1470448X;
label value EMPST31 H1470449X;
label value EMPST42 H1470450X;
label value EMPST53 H1470451X;
label value ENDRFD11 H1470452X;
label value ENDRFD31 H1470453X;
label value ENDRFD42 H1470454X;
label value ENDRFD53 H1470455X;
label value ENDRFM11 H1470456X;
label value ENDRFM31 H1470457X;
label value ENDRFM42 H1470458X;
label value ENDRFM53 H1470459X;
label value ENDRFY11 H1470460X;
label value ENDRFY31 H1470461X;
label value ENDRFY42 H1470462X;
label value ENDRFY53 H1470463X;
label value ENGCMF42 H1470464X;
label value ENGSPK42 H1470465X;
label value ERTOT11 H1470466X;
label value ESPHAGED H1470467X;
label value ESPHREMS H1470468X;
label value EVRETIRE H1470469X;
label value EVRUNAT H1470470X;
label value EVRUNINS H1470471X;
label value EVRWRK H1470472X;
label value EXPLOP42 H1470473X;
label value EXRCIS53 H1470474X;
label value FAMRFPYR H1470475X;
label value FAMSZE31 H1470476X;
label value FAMSZE42 H1470477X;
label value FAMSZE53 H1470478X;
label value FCRP1231 H1470479X;
label value FILEDR11 H1470480X;
label value FILER11 H1470481X;
label value FLSTAT11 H1470482X;
label value FLUSHT53 H1470483X;
label value FMRS1231 H1470484X;
label value FNGRDF31 H1470485X;
label value FNGRDF53 H1470486X;
label value FOODMN11 H1470487X;
label value FOODST11 H1470488X;
label value FOODVL11 H1470489X;
label value FSAAMT31 H1470490X;
label value FSAGT31 H1470491X;
label value FTSTU11X H1470492X;
label value FTSTU31X H1470493X;
label value FTSTU42X H1470494X;
label value FTSTU53X H1470495X;
label value GDCPBM42 H1470496X;
label value GDCPBT42 H1470497X;
label value GENDRP42 H1470498X;
label value GOTOUS42 H1470499X;
label value HASFSA31 H1470500X;
label value HAVEUS42 H1470501X;
label value HAVFUN42 H1470502X;
label value HEALTH42 H1470503X;
label value HEARAD42 H1470504X;
label value HEARDI42 H1470505X;
label value HEARMO42 H1470506X;
label value HEARNG42 H1470507X;
label value HEARSM42 H1470508X;
label value HELD31X H1470509X;
label value HELD42X H1470510X;
label value HELD53X H1470511X;
label value HELMET42 H1470512X;
label value HHAGD11 H1470513X;
label value HHAWCP11 H1470514X;
label value HHINDD11 H1470515X;
label value HHINFD11 H1470516X;
label value HHNOPR11 H1470517X;
label value HHNOPU11 H1470518X;
label value HHTOTD11 H1470519X;
label value HIBPAGED H1470520X;
label value HIBPDX H1470521X;
label value HIDEG H1470522X;
label value HISPANX H1470523X;
label value HISPCAT H1470524X;
label value HLTHLF42 H1470525X;
label value HOMEBH42 H1470526X;
label value HONRDC31 H1470527X;
label value HONRDC42 H1470528X;
label value HONRDC53 H1470529X;
label value HOUR31 H1470530X;
label value HOUR42 H1470531X;
label value HOUR53 H1470532X;
label value HPDAP11 H1470533X;
label value HPDAU11 H1470534X;
label value HPDDE11 H1470535X;
label value HPDFE11 H1470536X;
label value HPDJA11 H1470537X;
label value HPDJL11 H1470538X;
label value HPDJU11 H1470539X;
label value HPDMA11 H1470540X;
label value HPDMY11 H1470541X;
label value HPDNO11 H1470542X;
label value HPDOC11 H1470543X;
label value HPDSE11 H1470544X;
label value HPEAP11 H1470545X;
label value HPEAU11 H1470546X;
label value HPEDE11 H1470547X;
label value HPEFE11 H1470548X;
label value HPEJA11 H1470549X;
label value HPEJL11 H1470550X;
label value HPEJU11 H1470551X;
label value HPEMA11 H1470552X;
label value HPEMY11 H1470553X;
label value HPENO11 H1470554X;
label value HPEOC11 H1470555X;
label value HPESE11 H1470556X;
label value HPNAP11 H1470557X;
label value HPNAU11 H1470558X;
label value HPNDE11 H1470559X;
label value HPNFE11 H1470560X;
label value HPNJA11 H1470561X;
label value HPNJL11 H1470562X;
label value HPNJU11 H1470563X;
label value HPNMA11 H1470564X;
label value HPNMY11 H1470565X;
label value HPNNO11 H1470566X;
label value HPNOC11 H1470567X;
label value HPNSE11 H1470568X;
label value HPOAP11 H1470569X;
label value HPOAU11 H1470570X;
label value HPODE11 H1470571X;
label value HPOFE11 H1470572X;
label value HPOJA11 H1470573X;
label value HPOJL11 H1470574X;
label value HPOJU11 H1470575X;
label value HPOMA11 H1470576X;
label value HPOMY11 H1470577X;
label value HPONO11 H1470578X;
label value HPOOC11 H1470579X;
label value HPOSE11 H1470580X;
label value HPRAP11 H1470581X;
label value HPRAU11 H1470582X;
label value HPRDE11 H1470583X;
label value HPRFE11 H1470584X;
label value HPRJA11 H1470585X;
label value HPRJL11 H1470586X;
label value HPRJU11 H1470587X;
label value HPRMA11 H1470588X;
label value HPRMY11 H1470589X;
label value HPRNO11 H1470590X;
label value HPROC11 H1470591X;
label value HPRSE11 H1470592X;
label value HPSAP11 H1470593X;
label value HPSAU11 H1470594X;
label value HPSDE11 H1470595X;
label value HPSFE11 H1470596X;
label value HPSJA11 H1470597X;
label value HPSJL11 H1470598X;
label value HPSJU11 H1470599X;
label value HPSMA11 H1470600X;
label value HPSMY11 H1470601X;
label value HPSNO11 H1470602X;
label value HPSOC11 H1470603X;
label value HPSSE11 H1470604X;
label value HRHOW31 H1470605X;
label value HRHOW42 H1470606X;
label value HRHOW53 H1470607X;
label value HRWG31X H1470608X;
label value HRWG42X H1470609X;
label value HRWG53X H1470610X;
label value HRWGIM31 H1470611X;
label value HRWGIM42 H1470612X;
label value HRWGIM53 H1470613X;
label value HSELIM31 H1470614X;
label value HSELIM53 H1470615X;
label value HSPLAP42 H1470616X;
label value HYSTER53 H1470617X;
label value IADL3M31 H1470618X;
label value IADL3M42 H1470619X;
label value IADL3M53 H1470620X;
label value IADLHP31 H1470621X;
label value IADLHP42 H1470622X;
label value IADLHP53 H1470623X;
label value INDCAT31 H1470624X;
label value INDCAT42 H1470625X;
label value INDCAT53 H1470626X;
label value INS11X H1470627X;
label value INS31X H1470628X;
label value INS42X H1470629X;
label value INS53X H1470630X;
label value INSAP11X H1470631X;
label value INSAT11X H1470632X;
label value INSAT31X H1470633X;
label value INSAT42X H1470634X;
label value INSAT53X H1470635X;
label value INSAU11X H1470636X;
label value INSC1231 H1470637X;
label value INSCOP11 H1470638X;
label value INSCOP31 H1470639X;
label value INSCOP42 H1470640X;
label value INSCOP53 H1470641X;
label value INSCOPE H1470642X;
label value INSCOV11 H1470643X;
label value INSDE11X H1470644X;
label value INSENDMM H1470645X;
label value INSENDYY H1470646X;
label value INSFE11X H1470647X;
label value INSJA11X H1470648X;
label value INSJL11X H1470649X;
label value INSJU11X H1470650X;
label value INSMA11X H1470651X;
label value INSMY11X H1470652X;
label value INSNO11X H1470653X;
label value INSOC11X H1470654X;
label value INSRPL42 H1470655X;
label value INSSE11X H1470656X;
label value INSURC11 H1470657X;
label value INTIMP11 H1470658X;
label value INTVLANG H1470659X;
label value IPDIS11 H1470660X;
label value IPZERO11 H1470661X;
label value IRAIMP11 H1470662X;
label value JNTPID11 H1470663X;
label value JOBORG31 H1470664X;
label value JOBORG42 H1470665X;
label value JOBORG53 H1470666X;
label value JOBRSN42 H1470667X;
label value JTINRU11 H1470668X;
label value JTPAIN31 H1470669X;
label value JTPAIN53 H1470670X;
label value K6SUM42 H1470671X;
label value KEYNESS H1470672X;
label value KIDNAGED H1470673X;
label value KIDNREMS H1470674X;
label value KIDPRO42 H1470675X;
label value KNOWDR42 H1470676X;
label value LANGHM42 H1470677X;
label value LANGPR42 H1470678X;
label value LAPBLT42 H1470679X;
label value LEUKAGED H1470680X;
label value LEUKREMS H1470681X;
label value LFTDIF31 H1470682X;
label value LFTDIF53 H1470683X;
label value LIVRAGED H1470684X;
label value LIVRREMS H1470685X;
label value LKINFM42 H1470686X;
label value LKINFT42 H1470687X;
label value LOCATN42 H1470688X;
label value LRNXAGED H1470689X;
label value LRNXREMS H1470690X;
label value LSHLTH42 H1470691X;
label value LSTETH53 H1470692X;
label value LUNGAGED H1470693X;
label value LUNGREMS H1470694X;
label value LYMPAGED H1470695X;
label value LYMPREMS H1470696X;
label value MAMOGR53 H1470697X;
label value MARRY11X H1470698X;
label value MARRY31X H1470699X;
label value MARRY42X H1470700X;
label value MARRY53X H1470701X;
label value MCAID11 H1470702X;
label value MCAID11X H1470703X;
label value MCAID31 H1470704X;
label value MCAID31X H1470705X;
label value MCAID42 H1470706X;
label value MCAID42X H1470707X;
label value MCAID53 H1470708X;
label value MCAID53X H1470709X;
label value MCARE11 H1470710X;
label value MCARE11X H1470711X;
label value MCARE31 H1470712X;
label value MCARE31X H1470713X;
label value MCARE42 H1470714X;
label value MCARE42X H1470715X;
label value MCARE53 H1470716X;
label value MCARE53X H1470717X;
label value MCDAP11 H1470718X;
label value MCDAP11X H1470719X;
label value MCDAT11X H1470720X;
label value MCDAT31X H1470721X;
label value MCDAT42X H1470722X;
label value MCDAT53X H1470723X;
label value MCDAU11 H1470724X;
label value MCDAU11X H1470725X;
label value MCDDE11 H1470726X;
label value MCDDE11X H1470727X;
label value MCDEV11 H1470728X;
label value MCDFE11 H1470729X;
label value MCDFE11X H1470730X;
label value MCDHMO11 H1470731X;
label value MCDHMO31 H1470732X;
label value MCDHMO42 H1470733X;
label value MCDJA11 H1470734X;
label value MCDJA11X H1470735X;
label value MCDJL11 H1470736X;
label value MCDJL11X H1470737X;
label value MCDJU11 H1470738X;
label value MCDJU11X H1470739X;
label value MCDMA11 H1470740X;
label value MCDMA11X H1470741X;
label value MCDMC11 H1470742X;
label value MCDMC31 H1470743X;
label value MCDMC42 H1470744X;
label value MCDMY11 H1470745X;
label value MCDMY11X H1470746X;
label value MCDNO11 H1470747X;
label value MCDNO11X H1470748X;
label value MCDOC11 H1470749X;
label value MCDOC11X H1470750X;
label value MCDSE11 H1470751X;
label value MCDSE11X H1470752X;
label value MCRAP11 H1470753X;
label value MCRAP11X H1470754X;
label value MCRAU11 H1470755X;
label value MCRAU11X H1470756X;
label value MCRDE11 H1470757X;
label value MCRDE11X H1470758X;
label value MCREV11 H1470759X;
label value MCRFE11 H1470760X;
label value MCRFE11X H1470761X;
label value MCRJA11 H1470762X;
label value MCRJA11X H1470763X;
label value MCRJL11 H1470764X;
label value MCRJL11X H1470765X;
label value MCRJU11 H1470766X;
label value MCRJU11X H1470767X;
label value MCRMA11 H1470768X;
label value MCRMA11X H1470769X;
label value MCRMY11 H1470770X;
label value MCRMY11X H1470771X;
label value MCRNO11 H1470772X;
label value MCRNO11X H1470773X;
label value MCROC11 H1470774X;
label value MCROC11X H1470775X;
label value MCRPB11 H1470776X;
label value MCRPB31 H1470777X;
label value MCRPB42 H1470778X;
label value MCRPD11 H1470779X;
label value MCRPD11X H1470780X;
label value MCRPD31 H1470781X;
label value MCRPD31X H1470782X;
label value MCRPD42 H1470783X;
label value MCRPD42X H1470784X;
label value MCRPHO11 H1470785X;
label value MCRPHO31 H1470786X;
label value MCRPHO42 H1470787X;
label value MCRSE11 H1470788X;
label value MCRSE11X H1470789X;
label value MDDLAY42 H1470790X;
label value MDDLPR42 H1470791X;
label value MDDLRS42 H1470792X;
label value MDUNAB42 H1470793X;
label value MDUNPR42 H1470794X;
label value MDUNRS42 H1470795X;
label value MELAAGED H1470796X;
label value MELAREMS H1470797X;
label value MESBPR42 H1470798X;
label value MESHGT42 H1470799X;
label value MESVIS42 H1470800X;
label value MESWGT42 H1470801X;
label value MIAGED H1470802X;
label value MIDX H1470803X;
label value MILDIF31 H1470804X;
label value MILDIF53 H1470805X;
label value MINORP42 H1470806X;
label value MNHLTH31 H1470807X;
label value MNHLTH42 H1470808X;
label value MNHLTH53 H1470809X;
label value MOMPRO42 H1470810X;
label value MORE31 H1470811X;
label value MORE42 H1470812X;
label value MORE53 H1470813X;
label value MORECOVR H1470814X;
label value MORJOB31 H1470815X;
label value MORJOB42 H1470816X;
label value MORJOB53 H1470817X;
label value MOUTAGED H1470818X;
label value MOUTREMS H1470819X;
label value MSA11 H1470820X;
label value MSA31 H1470821X;
label value MSA42 H1470822X;
label value MSA53 H1470823X;
label value MUSCAGED H1470824X;
label value MUSCREMS H1470825X;
label value MYSELF42 H1470826X;
label value NATAMP42 H1470827X;
label value NERVAF42 H1470828X;
label value NEVILL42 H1470829X;
label value NEWARE42 H1470830X;
label value NEWDOC42 H1470831X;
label value NHRWG31 H1470832X;
label value NHRWG42 H1470833X;
label value NHRWG53 H1470834X;
label value NOASPR53 H1470835X;
label value NOFAT53 H1470836X;
label value NOGODR42 H1470837X;
label value NOHINS42 H1470838X;
label value NOINSBEF H1470839X;
label value NOINSTM H1470840X;
label value NOINUNIT H1470841X;
label value NOLIKE42 H1470842X;
label value NOREAS42 H1470843X;
label value NOSMOK42 H1470844X;
label value NUMEMP31 H1470845X;
label value NUMEMP42 H1470846X;
label value NUMEMP53 H1470847X;
label value NWK31 H1470848X;
label value NWK42 H1470849X;
label value NWK53 H1470850X;
label value OBASST11 H1470851X;
label value OBCHIR11 H1470852X;
label value OBCOPU11 H1470853X;
label value OBCSTL11 H1470854X;
label value OBDRV11 H1470855X;
label value OBNURS11 H1470856X;
label value OBOPTO11 H1470857X;
label value OBOTHV11 H1470858X;
label value OBTHER11 H1470859X;
label value OBTOTV11 H1470860X;
label value OCCCAT31 H1470861X;
label value OCCCAT42 H1470862X;
label value OCCCAT53 H1470863X;
label value OFFER31X H1470864X;
label value OFFER42X H1470865X;
label value OFFER53X H1470866X;
label value OFFHOU42 H1470867X;
label value OFREMP31 H1470868X;
label value OFREMP42 H1470869X;
label value OFREMP53 H1470870X;
label value OHRTAGED H1470871X;
label value OHRTDX H1470872X;
label value ONGONG42 H1470873X;
label value ONJOB42 H1470874X;
label value OPAAP11 H1470875X;
label value OPAAU11 H1470876X;
label value OPADE11 H1470877X;
label value OPAEV11 H1470878X;
label value OPAFE11 H1470879X;
label value OPAJA11 H1470880X;
label value OPAJL11 H1470881X;
label value OPAJU11 H1470882X;
label value OPAMA11 H1470883X;
label value OPAMY11 H1470884X;
label value OPANO11 H1470885X;
label value OPAOC11 H1470886X;
label value OPASE11 H1470887X;
label value OPBAP11 H1470888X;
label value OPBAU11 H1470889X;
label value OPBDE11 H1470890X;
label value OPBEV11 H1470891X;
label value OPBFE11 H1470892X;
label value OPBJA11 H1470893X;
label value OPBJL11 H1470894X;
label value OPBJU11 H1470895X;
label value OPBMA11 H1470896X;
label value OPBMY11 H1470897X;
label value OPBNO11 H1470898X;
label value OPBOC11 H1470899X;
label value OPBSE11 H1470900X;
label value OPDRV11 H1470901X;
label value OPOTHV11 H1470902X;
label value OPTOTV11 H1470903X;
label value OTHDYS31 H1470904X;
label value OTHDYS42 H1470905X;
label value OTHDYS53 H1470906X;
label value OTHIMP11 H1470907X;
label value OTHINS42 H1470908X;
label value OTHNDD31 H1470909X;
label value OTHNDD42 H1470910X;
label value OTHNDD53 H1470911X;
label value OTHRAGED H1470912X;
label value OTHRCP42 H1470913X;
label value OTHREA42 H1470914X;
label value OTHRREMS H1470915X;
label value OTPAAT11 H1470916X;
label value OTPAAT31 H1470917X;
label value OTPAAT42 H1470918X;
label value OTPAAT53 H1470919X;
label value OTPBAT11 H1470920X;
label value OTPBAT31 H1470921X;
label value OTPBAT42 H1470922X;
label value OTPBAT53 H1470923X;
label value OTPUBA11 H1470924X;
label value OTPUBA31 H1470925X;
label value OTPUBA42 H1470926X;
label value OTPUBA53 H1470927X;
label value OTPUBB11 H1470928X;
label value OTPUBB31 H1470929X;
label value OTPUBB42 H1470930X;
label value OTPUBB53 H1470931X;
label value OVRYAGED H1470932X;
label value OVRYREMS H1470933X;
label value PACISP42 H1470934X;
label value PANCAGED H1470935X;
label value PANCREMS H1470936X;
label value PANEL H1470937X;
label value PAPSMR53 H1470938X;
label value PAYDR31 H1470939X;
label value PAYDR42 H1470940X;
label value PAYDR53 H1470941X;
label value PAYVAC31 H1470942X;
label value PAYVAC42 H1470943X;
label value PAYVAC53 H1470944X;
label value PBINFM42 H1470945X;
label value PBINFT42 H1470946X;
label value PBPWKM42 H1470947X;
label value PBPWKT42 H1470948X;
label value PBSVCM42 H1470949X;
label value PBSVCT42 H1470950X;
label value PDKAP11 H1470951X;
label value PDKAU11 H1470952X;
label value PDKDE11 H1470953X;
label value PDKFE11 H1470954X;
label value PDKJA11 H1470955X;
label value PDKJL11 H1470956X;
label value PDKJU11 H1470957X;
label value PDKMA11 H1470958X;
label value PDKMY11 H1470959X;
label value PDKNO11 H1470960X;
label value PDKOC11 H1470961X;
label value PDKSE11 H1470962X;
label value PEGAP11 H1470963X;
label value PEGAU11 H1470964X;
label value PEGDE11 H1470965X;
label value PEGFE11 H1470966X;
label value PEGJA11 H1470967X;
label value PEGJL11 H1470968X;
label value PEGJU11 H1470969X;
label value PEGMA11 H1470970X;
label value PEGMY11 H1470971X;
label value PEGNO11 H1470972X;
label value PEGOC11 H1470973X;
label value PEGSE11 H1470974X;
label value PENIMP11 H1470975X;
label value PERSLA42 H1470976X;
label value PHMONP11 H1470977X;
label value PHMONP31 H1470978X;
label value PHMONP42 H1470979X;
label value PHNREG42 H1470980X;
label value PHQ242 H1470981X;
label value PHYEXE53 H1470982X;
label value PHYSCL42 H1470983X;
label value PLCTYP42 H1470984X;
label value PMDINS11 H1470985X;
label value PMDINS31 H1470986X;
label value PMDLAY42 H1470987X;
label value PMDLPR42 H1470988X;
label value PMDLRS42 H1470989X;
label value PMEDIN31 H1470990X;
label value PMEDIN42 H1470991X;
label value PMEDIN53 H1470992X;
label value PMEDPP31 H1470993X;
label value PMEDPP42 H1470994X;
label value PMEDPP53 H1470995X;
label value PMEDPY31 H1470996X;
label value PMEDPY42 H1470997X;
label value PMEDPY53 H1470998X;
label value PMEDUP31 H1470999X;
label value PMEDUP42 H1471000X;
label value PMEDUP53 H1471001X;
label value PMNCNP11 H1471002X;
label value PMNCNP31 H1471003X;
label value PMNCNP42 H1471004X;
label value PMUNAB42 H1471005X;
label value PMUNPR42 H1471006X;
label value PMUNRS42 H1471007X;
label value PNGAP11 H1471008X;
label value PNGAU11 H1471009X;
label value PNGDE11 H1471010X;
label value PNGFE11 H1471011X;
label value PNGJA11 H1471012X;
label value PNGJL11 H1471013X;
label value PNGJU11 H1471014X;
label value PNGMA11 H1471015X;
label value PNGMY11 H1471016X;
label value PNGNO11 H1471017X;
label value PNGOC11 H1471018X;
label value PNGSE11 H1471019X;
label value POGAP11 H1471020X;
label value POGAU11 H1471021X;
label value POGDE11 H1471022X;
label value POGFE11 H1471023X;
label value POGJA11 H1471024X;
label value POGJL11 H1471025X;
label value POGJU11 H1471026X;
label value POGMA11 H1471027X;
label value POGMY11 H1471028X;
label value POGNO11 H1471029X;
label value POGOC11 H1471030X;
label value POGSE11 H1471031X;
label value POUAP11 H1471032X;
label value POUAU11 H1471033X;
label value POUDE11 H1471034X;
label value POUFE11 H1471035X;
label value POUJA11 H1471036X;
label value POUJL11 H1471037X;
label value POUJU11 H1471038X;
label value POUMA11 H1471039X;
label value POUMY11 H1471040X;
label value POUNO11 H1471041X;
label value POUOC11 H1471042X;
label value POUSE11 H1471043X;
label value POVCAT11 H1471044X;
label value PPRWKM42 H1471045X;
label value PPRWKT42 H1471046X;
label value PRDRNP11 H1471047X;
label value PRDRNP31 H1471048X;
label value PRDRNP42 H1471049X;
label value PREGNT31 H1471050X;
label value PREGNT42 H1471051X;
label value PREGNT53 H1471052X;
label value PREVCOVR H1471053X;
label value PREVEN42 H1471054X;
label value PRIAP11 H1471055X;
label value PRIAU11 H1471056X;
label value PRIDE11 H1471057X;
label value PRIDK11 H1471058X;
label value PRIDK31 H1471059X;
label value PRIDK42 H1471060X;
label value PRIDK53 H1471061X;
label value PRIEU11 H1471062X;
label value PRIEU31 H1471063X;
label value PRIEU42 H1471064X;
label value PRIEU53 H1471065X;
label value PRIFE11 H1471066X;
label value PRIJA11 H1471067X;
label value PRIJL11 H1471068X;
label value PRIJU11 H1471069X;
label value PRIMA11 H1471070X;
label value PRIMY11 H1471071X;
label value PRING11 H1471072X;
label value PRING31 H1471073X;
label value PRING42 H1471074X;
label value PRING53 H1471075X;
label value PRINO11 H1471076X;
label value PRIOC11 H1471077X;
label value PRIOG11 H1471078X;
label value PRIOG31 H1471079X;
label value PRIOG42 H1471080X;
label value PRIOG53 H1471081X;
label value PRIS11 H1471082X;
label value PRIS31 H1471083X;
label value PRIS42 H1471084X;
label value PRIS53 H1471085X;
label value PRISE11 H1471086X;
label value PRIV11 H1471087X;
label value PRIV31 H1471088X;
label value PRIV42 H1471089X;
label value PRIV53 H1471090X;
label value PRIVAT11 H1471091X;
label value PRIVAT31 H1471092X;
label value PRIVAT42 H1471093X;
label value PRIVAT53 H1471094X;
label value PROUT11 H1471095X;
label value PROUT31 H1471096X;
label value PROUT42 H1471097X;
label value PROUT53 H1471098X;
label value PROVTY42 H1471099X;
label value PROXY11 H1471100X;
label value PROXY31 H1471101X;
label value PROXY42 H1471102X;
label value PROXY53 H1471103X;
label value PRSAP11 H1471104X;
label value PRSAU11 H1471105X;
label value PRSDE11 H1471106X;
label value PRSFE11 H1471107X;
label value PRSJA11 H1471108X;
label value PRSJL11 H1471109X;
label value PRSJU11 H1471110X;
label value PRSMA11 H1471111X;
label value PRSMY11 H1471112X;
label value PRSNO11 H1471113X;
label value PRSOC11 H1471114X;
label value PRSSE11 H1471115X;
label value PRSTAGED H1471116X;
label value PRSTREMS H1471117X;
label value PRVDRL11 H1471118X;
label value PRVDRL31 H1471119X;
label value PRVDRL42 H1471120X;
label value PRVEV11 H1471121X;
label value PRVHMO11 H1471122X;
label value PRVHMO31 H1471123X;
label value PRVHMO42 H1471124X;
label value PRVMNC11 H1471125X;
label value PRVMNC31 H1471126X;
label value PRVMNC42 H1471127X;
label value PSA53 H1471128X;
label value PSTATS31 H1471129X;
label value PSTATS42 H1471130X;
label value PSTATS53 H1471131X;
label value PUB11X H1471132X;
label value PUB31X H1471133X;
label value PUB42X H1471134X;
label value PUB53X H1471135X;
label value PUBAP11X H1471136X;
label value PUBAT11X H1471137X;
label value PUBAT31X H1471138X;
label value PUBAT42X H1471139X;
label value PUBAT53X H1471140X;
label value PUBAU11X H1471141X;
label value PUBDE11X H1471142X;
label value PUBFE11X H1471143X;
label value PUBIMP11 H1471144X;
label value PUBJA11X H1471145X;
label value PUBJL11X H1471146X;
label value PUBJU11X H1471147X;
label value PUBMA11X H1471148X;
label value PUBMY11X H1471149X;
label value PUBNO11X H1471150X;
label value PUBOC11X H1471151X;
label value PUBSE11X H1471152X;
label value RACEAX H1471153X;
label value RACEBX H1471154X;
label value RACETHNX H1471155X;
label value RACEWX H1471156X;
label value RACEX H1471157X;
label value RCHDIF31 H1471158X;
label value RCHDIF53 H1471159X;
label value READNW42 H1471160X;
label value RECPEP42 H1471161X;
label value RECTAGED H1471162X;
label value RECTREMS H1471163X;
label value REFFRL42 H1471164X;
label value REFIMP11 H1471165X;
label value REGION11 H1471166X;
label value REGION31 H1471167X;
label value REGION42 H1471168X;
label value REGION53 H1471169X;
label value RESP11 H1471170X;
label value RESP31 H1471171X;
label value RESP42 H1471172X;
label value RESP53 H1471173X;
label value RESPCT42 H1471174X;
label value RETPLN31 H1471175X;
label value RETPLN42 H1471176X;
label value RETPLN53 H1471177X;
label value RFREL11X H1471178X;
label value RFREL31X H1471179X;
label value RFREL42X H1471180X;
label value RFREL53X H1471181X;
label value RNDFLG31 H1471182X;
label value RTHLTH31 H1471183X;
label value RTHLTH42 H1471184X;
label value RTHLTH53 H1471185X;
label value RTPLNM42 H1471186X;
label value RTPLNT42 H1471187X;
label value RUCLAS11 H1471188X;
label value RUCLAS31 H1471189X;
label value RUCLAS42 H1471190X;
label value RUCLAS53 H1471191X;
label value RUSIZE11 H1471192X;
label value RUSIZE31 H1471193X;
label value RUSIZE42 H1471194X;
label value RUSIZE53 H1471195X;
label value SAFEST42 H1471196X;
label value SALIMP11 H1471197X;
label value SAQELIG H1471198X;
label value SCHLBH42 H1471199X;
label value SCHLIM31 H1471200X;
label value SCHLIM53 H1471201X;
label value SCHPRO42 H1471202X;
label value SCLNBD31 H1471203X;
label value SCLNBD42 H1471204X;
label value SCLNBD53 H1471205X;
label value SEATBE53 H1471206X;
label value SEEDIF42 H1471207X;
label value SELDSI42 H1471208X;
label value SELFCM31 H1471209X;
label value SELFCM42 H1471210X;
label value SELFCM53 H1471211X;
label value SEX H1471212X;
label value SFFLAG42 H1471213X;
label value SGMTRE53 H1471214X;
label value SGMTST53 H1471215X;
label value SIBPRO42 H1471216X;
label value SICEAS42 H1471217X;
label value SICPAY31 H1471218X;
label value SICPAY42 H1471219X;
label value SICPAY53 H1471220X;
label value SKDKAGED H1471221X;
label value SKDKREMS H1471222X;
label value SKNMAGED H1471223X;
label value SKNMREMS H1471224X;
label value SOCLIM31 H1471225X;
label value SOCLIM53 H1471226X;
label value SPOUID11 H1471227X;
label value SPOUID31 H1471228X;
label value SPOUID42 H1471229X;
label value SPOUID53 H1471230X;
label value SPOUIN11 H1471231X;
label value SPOUIN31 H1471232X;
label value SPOUIN42 H1471233X;
label value SPOUIN53 H1471234X;
label value SPRPRO42 H1471235X;
label value SSCIMP11 H1471236X;
label value SSIDIS11 H1471237X;
label value SSIIMP11 H1471238X;
label value SSNLJB31 H1471239X;
label value SSNLJB42 H1471240X;
label value SSNLJB53 H1471241X;
label value STAAP11 H1471242X;
label value STAAU11 H1471243X;
label value STADE11 H1471244X;
label value STAFE11 H1471245X;
label value STAJA11 H1471246X;
label value STAJL11 H1471247X;
label value STAJU11 H1471248X;
label value STAMA11 H1471249X;
label value STAMY11 H1471250X;
label value STANO11 H1471251X;
label value STAOC11 H1471252X;
label value STAPR11 H1471253X;
label value STAPR31 H1471254X;
label value STAPR42 H1471255X;
label value STAPR53 H1471256X;
label value STASE11 H1471257X;
label value STJBDD31 H1471258X;
label value STJBDD42 H1471259X;
label value STJBDD53 H1471260X;
label value STJBMM31 H1471261X;
label value STJBMM42 H1471262X;
label value STJBMM53 H1471263X;
label value STJBYY31 H1471264X;
label value STJBYY42 H1471265X;
label value STJBYY53 H1471266X;
label value STNDIF31 H1471267X;
label value STNDIF53 H1471268X;
label value STOMAGED H1471269X;
label value STOMCH53 H1471270X;
label value STOMREMS H1471271X;
label value STPDIF31 H1471272X;
label value STPDIF53 H1471273X;
label value STPRAT11 H1471274X;
label value STPRAT31 H1471275X;
label value STPRAT42 H1471276X;
label value STPRAT53 H1471277X;
label value STRKAGED H1471278X;
label value STRKDX H1471279X;
label value TAXFRM11 H1471280X;
label value TEMPJB31 H1471281X;
label value TEMPJB42 H1471282X;
label value TEMPJB53 H1471283X;
label value THRTAGED H1471284X;
label value THRTREMS H1471285X;
label value THYRAGED H1471286X;
label value THYRREMS H1471287X;
label value TIMALN42 H1471288X;
label value TMTKUS42 H1471289X;
label value TOTDED11 H1471290X;
label value TRANS42 H1471291X;
label value TRBLE42 H1471292X;
label value TREATM42 H1471293X;
label value TRIAP11X H1471294X;
label value TRIAT11X H1471295X;
label value TRIAT31X H1471296X;
label value TRIAT42X H1471297X;
label value TRIAT53X H1471298X;
label value TRIAU11X H1471299X;
label value TRICH11X H1471300X;
label value TRICH31X H1471301X;
label value TRICH42X H1471302X;
label value TRICR11X H1471303X;
label value TRICR31X H1471304X;
label value TRICR42X H1471305X;
label value TRICR53X H1471306X;
label value TRIDE11X H1471307X;
label value TRIEV11 H1471308X;
label value TRIEX11X H1471309X;
label value TRIEX31X H1471310X;
label value TRIEX42X H1471311X;
label value TRIFE11X H1471312X;
label value TRIJA11X H1471313X;
label value TRIJL11X H1471314X;
label value TRIJU11X H1471315X;
label value TRILI11X H1471316X;
label value TRILI31X H1471317X;
label value TRILI42X H1471318X;
label value TRIMA11X H1471319X;
label value TRIMY11X H1471320X;
label value TRINO11X H1471321X;
label value TRIOC11X H1471322X;
label value TRIPR11X H1471323X;
label value TRIPR31X H1471324X;
label value TRIPR42X H1471325X;
label value TRISE11X H1471326X;
label value TRIST11X H1471327X;
label value TRIST31X H1471328X;
label value TRIST42X H1471329X;
label value TRTIMP11 H1471330X;
label value TSTSAGED H1471331X;
label value TSTSREMS H1471332X;
label value TYPEPE42 H1471333X;
label value UNABLE31 H1471334X;
label value UNABLE53 H1471335X;
label value UNEIMP11 H1471336X;
label value UNHAP42 H1471337X;
label value UNINS11 H1471338X;
label value UNION31 H1471339X;
label value UNION42 H1471340X;
label value UNION53 H1471341X;
label value USBORN42 H1471342X;
label value USCNOT42 H1471343X;
label value USLIVE42 H1471344X;
label value UTERAGED H1471345X;
label value UTERREMS H1471346X;
label value VETIMP11 H1471347X;
label value VISION42 H1471348X;
label value WAGIMP11 H1471349X;
label value WASAFDC H1471350X;
label value WASCHAMP H1471351X;
label value WASESTB H1471352X;
label value WASMCAID H1471353X;
label value WASMCARE H1471354X;
label value WASOTGOV H1471355X;
label value WASOTHER H1471356X;
label value WASPRIV H1471357X;
label value WASSSI H1471358X;
label value WASSTAT1 H1471359X;
label value WASSTAT2 H1471360X;
label value WASSTAT3 H1471361X;
label value WASSTAT4 H1471362X;
label value WASVA H1471363X;
label value WCPIMP11 H1471364X;
label value WHITPR42 H1471365X;
label value WHNBPR42 H1471366X;
label value WHNBST42 H1471367X;
label value WHNDEN42 H1471368X;
label value WHNEAT42 H1471369X;
label value WHNHEL42 H1471370X;
label value WHNHGT42 H1471371X;
label value WHNLAP42 H1471372X;
label value WHNPHY42 H1471373X;
label value WHNSAF42 H1471374X;
label value WHNSMK42 H1471375X;
label value WHNWGT42 H1471376X;
label value WILFIL11 H1471377X;
label value WKINBD31 H1471378X;
label value WKINBD42 H1471379X;
label value WKINBD53 H1471380X;
label value WLK3MO31 H1471381X;
label value WLK3MO53 H1471382X;
label value WLKDIF31 H1471383X;
label value WLKDIF53 H1471384X;
label value WLKLIM31 H1471385X;
label value WLKLIM53 H1471386X;
label value WRGLAS42 H1471387X;
label value WRHLTH42 H1471388X;
label value WRKLIM31 H1471389X;
label value WRKLIM53 H1471390X;
label value YCHJ3142 H1471391X;
label value YCHJ4253 H1471392X;
label value YNOINS31 H1471393X;
label value YNOINS42 H1471394X;
label value YNOINS53 H1471395X;
label value YNOUSC42 H1471396X;
label value ZIDOPU11 H1471397X;
label value ZIDTRI11 H1471398X;
label value ZIDWCP11 H1471399X;
label value ZIFOPR11 H1471400X;

*DISPLAY A DESCRIPTION OF STATA FILE;
describe;

*LIST FIRST 20 OBSERVATIONS IN THE FILE;
list in 1/20;


#delimit cr



/************************************************************************************************
 NOTES:                                                                                          
                                                                                                 
 1. This program has been tested on Stata Version 10 (for Windows).                              
                                                                                                 
 2. This program will create a permanent Stata dataset.  All additional analyses                 
    can be run using this dataset.  In addition to the dataset, this program creates             
    a log file named H147.LOG and a data file named H147.DTA.  If these files (H147.DTA and H147.LOG)
    already exist in the working directory, they will be replaced when this program is executed. 
                                                                                                 
 3. If the program ends prematurely, the log file will remain open.  Before running this         
    program again, the user should enter the following Stata command: log close                  
                                                                                                 
 4. The cd command assigns C:\MEPS\DATA as the working directory and location of the input       
    ASCII and output .DTA and .LOG files and can be modified by the user as necessary.           
                                                                                                 
 5. Stata commands end with a carriage return by default. The command                            
    #delimit ;                                                                                   
    temporarily changes the command ending delimiter from a carriage return to a semicolon.      
                                                                                                 
 6. The infix command assumes that the input variables are numeric unless the variable name      
    is prefaced by str.  For example, DUPERSID is the a string (or character) variable.          
                                                                                                 
************************************************************************************************/

